package jp.sourceforge.shovel.xa;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

import org.seasar.extension.jta.xa.DefaultXAResource;
import org.seasar.framework.exception.SXAException;

import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.exception.ApplicationException;

/**
 * ファイル管理
 */
public class XAServerFile extends DefaultXAResource {
    private String root_;
    private List<IServerFile> copies_;
    private List<IServerFile> removes_;
    
    public void setCommonProperties( Properties commonProperties ) throws ApplicationException {
        root_ = commonProperties.getProperty("files.dir");
        File dir = new File(root_);
        if (!dir.isDirectory() || !dir.canWrite()) {
            //TODO
            ApplicationException ex = new ApplicationException("");
            ex.setCauseArgs(dir.getPath());
            throw ex;
        }
    }
    public XAServerFile() {
        copies_ = new ArrayList<IServerFile>();
        removes_ = new ArrayList<IServerFile>();
    }
    protected void doBegin(Xid xid) throws XAException {
        try {
        } catch(Exception ex) {
            throw new SXAException(ex);
        }
    }
    protected void doCommit(Xid xid, boolean onePhase) throws XAException {
        try {
            int count = copies_.size();
            for (int i = 0; i < count; i++) {
                copies_.get(i).commit(0);
            }
            count = removes_.size();
            for (int i = 0; i < count; i++) {
                removes_.get(i).commit(1);
            }
        } catch(Exception e) {
            throw new SXAException(e);
        }
    }
    protected int doPrepare(Xid xid) throws XAException {
        try {
            return XA_OK;
        } catch(Exception e) {
            throw new SXAException(e);
        }
    }
    protected void doRollback(Xid xid) throws XAException {
        try {
            copies_.clear();
            removes_.clear();
        } catch(Exception e) {
            throw new SXAException(e);
        }
    }
    public void addToCopy(IServerFile file) {
        copies_.add(file);
    }
    public void addToRemove(IServerFile file) {
        removes_.add(file);
    }
}
