package jp.sourceforge.shovel.thread;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.log.Logger;

import jp.sourceforge.shovel.entity.IConnectionWrapper;
import jp.sourceforge.shovel.exception.ApplicationException;

public class XMPPMain extends Thread {
    static Logger logger = Logger.getLogger(XMPPMain.class);

    S2Container container_;
    IConnectionWrapper connection_;
    
    public void setXMPPConnectionWrapper(IConnectionWrapper connection) {
        connection_ = connection;
    }
    public void run() {
        try {
            connection_.connect();
            while (true) {
                connection_.dispatch();
            }
        } catch (ApplicationException e) {
            logger.info(connection_.getDevice() + "(XMPP device) start-up failed.");
        } finally {
            //割り込まれたら糸冬了
            connection_.disconnect();
        }
    }
}
