package jp.sourceforge.shovel.servlet.shovel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Map.Entry;
//import java.util.concurrent.BlockingQueue;
//import java.util.concurrent.SynchronousQueue;

import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import jp.sourceforge.shovel.ServicePropertyType;
import jp.sourceforge.shovel.entity.IConnectionWrapper;
import jp.sourceforge.shovel.logic.IShovelLogic;
import jp.sourceforge.shovel.thread.XMPPMain;

public class ShovelServlet extends GenericServlet {
    static final long serialVersionUID = -1L;
    
    void setProperty(Map<String, IConnectionWrapper> connectionMap, Entry<Object, Object> entry) {
        String[] tokens = entry.getKey().toString().split("\\.");
        
        String uniqueId = tokens[0];
        IConnectionWrapper connection = (IConnectionWrapper)connectionMap.get(uniqueId);
        if (connection == null) {
            connection = (IConnectionWrapper)getContainer().getComponent(IConnectionWrapper.class);
            connection.setDevice(uniqueId);
            connectionMap.put(uniqueId, connection);
        }
        String key = tokens[1];
        String value = entry.getValue().toString();

        switch(ServicePropertyType.find(key)) {
        case DISPLAY_NAME:
            connection.setDisplayName(value);
            break;
        case HOST:
            connection.setHost(value);
            break;
        case PORT:
            connection.setPort(Integer.valueOf(value));
            break;
        case SASL:
            connection.setSasl(Boolean.valueOf(value));
            break;
        case SSL:
            connection.setSsl(Boolean.valueOf(value));
            break;
        case SERVICE_NAME:
            connection.setServiceName(value);
            break;
        case USER_ID:
            connection.setUserId(value);
            break;
        case PASSWORD:
            connection.setPassword(value);
            break;
        default:
            break;
        }
    }
    Map<String, IConnectionWrapper> createConnectionWrapperMap() {
        Set<Entry<Object, Object>> entrySet = getProperties().entrySet();
        Map<String, IConnectionWrapper> connectionMap = new HashMap<String, IConnectionWrapper>();
        for (Entry<Object, Object> entry: entrySet) {
            setProperty(connectionMap, entry);
        }
        return connectionMap;
    }
//    BlockingQueue<Object> queue_;
    public void init(ServletConfig config) throws ServletException {
//        queue_ = new SynchronousQueue<Object>();
        Map<String, IConnectionWrapper> connectionWrapperMap = createConnectionWrapperMap();
        getShovelLogic().setConnectionWrapperMap(connectionWrapperMap);
        for (IConnectionWrapper connectionWrapper : connectionWrapperMap.values()) {
//            connectionWrapper.setQueue(queue_);
            XMPPMain main = getXMPPMain();
            main.setXMPPConnectionWrapper(connectionWrapper);
            main.start();
        }
    }
    S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }
    IShovelLogic getShovelLogic() {
        return (IShovelLogic)getContainer().getComponent(IShovelLogic.class);
    }
    XMPPMain getXMPPMain() {
        return (XMPPMain)getContainer().getComponent(XMPPMain.class);
    }
    Properties getProperties() {
        return (Properties)getContainer().getComponent("imProperties");
    }
    @Override
    public void service( ServletRequest arg0, ServletResponse arg1 ) throws ServletException, IOException {
    }
}
