package jp.sourceforge.shovel.entity.impl;

import static jp.sourceforge.shovel.RepliesType.*;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.TimeZone;

import org.seasar.dao.annotation.tiger.Bean;
import org.seasar.dao.annotation.tiger.Id;
import org.seasar.dao.annotation.tiger.IdType;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;

@Bean(table = "users")
public class UserImpl implements IUser {
    boolean administrator_;
    long createdTime_;
    long creatorId_;
    String description_;
    int directMessages_;
    String displayName_;
    String email_;
    int favorites_;
    int followers_;
    int friends_;
    String foreignKey_;
    String location_;
    long modifiedTime_;
    long modifierId_;
    String password_;
    boolean removed_;
    int statuses_;
    long userId_;
    int viewLines_;
    TimeZone timeZone_;
    boolean remove_;
    RepliesType repliesType_;
    int givenFavorites_;
    
    public UserImpl() {
        serverFile_ = (IServerFile)getContainer().getComponent(IServerFile.class);
        device_ = (IDevice)getContainer().getComponent(IDevice.class);
        status_ = (IStatus)getContainer().getComponent(IStatus.class);
    }
    public boolean isAdministrator() {
        return administrator_;
    }
    public void setAdministrator(boolean administrator) {
        administrator_ = administrator;
    }
    public long getCreatedTime() {
        return createdTime_;
    }
    public void setCreatedTime(long createdTime) {
        createdTime_ = createdTime;
    }
    public long getCreatorId() {
        return creatorId_;
    }
    public void setCreatorId(long creatorId) {
        creatorId_ = creatorId;
    }
    public String getDescription() {
        return description_;
    }
    public void setDescription(String description) {
        description_ = description;
    }
    public int getDirectMessages() {
        return directMessages_;
    }
    public void setDirectMessages(int directMessages) {
        directMessages_ = directMessages;
    }
    public String getDisplayName() {
        return displayName_;
    }
    public void setDisplayName(String displayName) {
        displayName_= displayName;
    }
    public String getEmail() {
        return email_;
    }
    public void setEmail(String email) {
        email_ = email;
    }
    public int getFavorites() {
        return favorites_;
    }
    public void setFavorites(int favorites) {
        favorites_ = favorites;
    }
    public int getFollowers() {
        return followers_;
    }
    public void setFollowers(int followers) {
        followers_ = followers;
    }
    //TODO 廃止予定
    public int getFollowing() {
        return friends_;
    }
    //TODO 廃止予定
    public void setFollowing(int following) {
        friends_ = following;
    }
    public int getFriends() {
        return friends_;
    }
    public void setFriends(int friends) {
        friends_ = friends;
    }
    public String getForeignKey() {
        return foreignKey_;
    }
    public void setForeignKey(String foreignKey) {
        foreignKey_ = foreignKey;
    }
    public String getLocation() {
        return location_;
    }
    public void setLocation(String location) {
        location_ = location;
    }
    public long getModifiedTime() {
        return modifiedTime_;
    }
    public void setModifiedTime(long modifiedTime) {
        modifiedTime_ = modifiedTime;
    }
    public long getModifierId() {
        return modifierId_;
    }
    public void setModifierId(long modifierId) {
        modifierId_ = modifierId;
    }
    public String getPassword() {
        return password_;
    }
    public void setPassword(String password) {
        password_ = password;
    }
    public boolean isRemoved() {
        return removed_;
    }
    public void setRemoved(boolean removed) {
        removed_ = removed;
    }
    public long getServerFileId() {
        return serverFile_.getServerFileId();
    }
    public void setServerFileId(long serverFileId) {
        serverFile_.setServerFileId(serverFileId);
    }
    public int getStatuses() {
        return statuses_;
    }
    public void setStatuses(int statuses) {
        statuses_ = statuses;
    }
    public String getTimeZoneId() {
        return getTimeZone().getID();
    }
    public void setTimeZoneId(String tzId) {
        TimeZone tz;
        if (tzId == null || tzId.length() <= 0) {
            tz = TimeZone.getDefault();
        } else {
            tz = TimeZone.getTimeZone(tzId);
        }
        setTimeZone(tz);
    }
    public long getUserId() {
        return userId_;
    }
    @Id(value = IdType.IDENTITY)
    public void setUserId(long userId) {
        userId_ = userId;
    }
    public int getViewLines() {
        return viewLines_;
    }
    public void setViewLines(int viewLines) {
        viewLines_ = viewLines;
    }
    public boolean isRemove() {
        return remove_;
    }
    public void setRemove(boolean remove) {
        remove_ = remove;
    }
    public int getReplies() {
        return getRepliesType().getId();
    }
    public void setReplies(int replies) {
        setRepliesType(RepliesType.find(replies));
    }
    public RepliesType getRepliesType() {
        return repliesType_ == null ? ALWAYS : repliesType_;
    }
    public void setRepliesType(RepliesType repliesType) {
        repliesType_ = repliesType;
    }
    public int getGivenFavorites() {
        return givenFavorites_;
    }
    public void setGivenFavorites(int givenFavorites) {
        givenFavorites_ = givenFavorites;
    }
    
    /////

    public String getCharset() {
        return serverFile_.getCharset();
    }
    public void setCharset(String charset) {
        serverFile_.setCharset(charset);
    }
    public String getMime() {
        return serverFile_.getMime();
    }
    public void setMime(String mime) {
        serverFile_.setMime(mime);
    }
    public String getName() {
        return serverFile_.getName();
    }
    public void setName(String name) {
        serverFile_.setName(name);
    }
    public int getSize() {
        return serverFile_.getSize();
    }
    public void setSize(int size) {
        serverFile_.setSize(size);
    }
    public int getWidth() {
        return serverFile_.getWidth();
    }
    public void setWidth(int width) {
        serverFile_.setWidth(width);
    }
    public int getHeight() {
        return serverFile_.getHeight();
    }
    public void setHeight(int height) {
        serverFile_.setHeight(height);
    }
    public long getServerFileCreatedTime() {
        return serverFile_.getCreatedTime();
    }
    public void setServerFileCreatedTime(long createdTime) {
        serverFile_.setCreatedTime(createdTime);
    }
    
    /////
    
    public String getAddress() {
        return device_.getAddress();
    }
    public void setAddress(String address) {
        device_.setAddress(address);
    }
    public int getAvailability() {
        return device_.getAvailability();
    }
    public void setAvailability(int availability) {
        device_.setAvailability(availability);
    }
    public long getDeviceId() {
        return device_.getDeviceId();
    }
    public void setDeviceId(long deviceId) {
        device_.setDeviceId(deviceId);
    }
    public int getType() {
        return device_.getType();
    }
    public void setType(int type) {
        device_.setType(type);
    }
    
    /////
    
    public String getBody() {
        return status_.getBody();
    }
    public void setBody(String body) {
        status_.setBody(body);
    }
    
    /////
    
    public TimeZone getTimeZone() {
        return timeZone_ == null ? TimeZone.getDefault() : timeZone_;
    }
    public void setTimeZone(TimeZone timeZone) {
        timeZone_ = timeZone;
    }
    
    IServerFile serverFile_;
    IDevice device_;
    IStatus status_;
    
    public IServerFile getServerFile() {
        return serverFile_;
    }
    @Binding(bindingType=BindingType.NONE)
    public void setServerFile(IServerFile serverFile) {
        serverFile_ = serverFile;
    }
    public IDevice getDevice() {
        return device_;
    }
    @Binding(bindingType=BindingType.NONE)
    public void setDevice(IDevice device) {
        device_ = device;
    }

    public String getReleaseKey() throws ApplicationException {
        //初回は解除キーを期待
        String address = getAddress();
        if (address == null || address.length() <= 0) {
            return null;
        }
        StringBuilder releaseKey = new StringBuilder(address);
        releaseKey.append(getPassword());
        
        byte[] hash;
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(releaseKey.toString().getBytes());
            hash = md5.digest();
        } catch (NoSuchAlgorithmException e) {
            //TODO
            throw new ApplicationException("");
        }
        
        releaseKey = new StringBuilder();
        for (int i = 0; i < hash.length; i++) {
            int digest = hash[i];
            if (digest < 0) {
                digest += 256;
            }
            if (digest < 16) {
                releaseKey.append("0");
            }
            releaseKey.append(Integer.toString(digest, 16));
        }
        
        int offset = Integer.parseInt(String.valueOf(getCreatedTime() & 3));
        offset *= 8;
        return releaseKey.toString().substring(offset, offset + 8);
    }
    
    /////
    
    S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }
}
