package jp.sourceforge.shovel.entity.impl;

import java.io.UnsupportedEncodingException;

import javax.mail.internet.MimeUtility;

import jp.sourceforge.shovel.entity.IClient;
import jp.sourceforge.shovel.exception.ApplicationException;

public class FirefoxImpl extends AbstractClientImpl implements IClient {
    public String getApplication() {
        return "firefox";
    }
    public static IClient testUserAgent(String userAgent) {
        IClient client = null;
        if (userAgent.startsWith("mozilla/5") && userAgent.indexOf("msie") == -1 &&
                userAgent.indexOf("firefox") != -1) {
            client = (IClient)getContainer().getComponent(FirefoxImpl.class);
        }
        return client;
    }
    public String encodeText(String text) throws ApplicationException {
        try {
            return MimeUtility.encodeText(text, "UTF-8", "B");
        } catch (UnsupportedEncodingException ex) {
            throw new ApplicationException("");
        }
    }
}
