package jp.sourceforge.shovel.entity.impl;

import static jp.sourceforge.shovel.AvailabilityType.*;
import static jp.sourceforge.shovel.DeviceType.*;

import org.seasar.dao.annotation.tiger.Bean;
import org.seasar.dao.annotation.tiger.Id;
import org.seasar.dao.annotation.tiger.IdType;

import jp.sourceforge.shovel.AvailabilityType;
import jp.sourceforge.shovel.DeviceType;
import jp.sourceforge.shovel.entity.IDevice;

@Bean(table = "devices")
public class DeviceImpl implements IDevice {
    boolean activation_;
    String address_;
    AvailabilityType availabilityType_;
    long deviceId_;
    DeviceType deviceType_;
    long userId_;
    
    public boolean isActivation() {
        return activation_;
    }
    public void setActivation(boolean activation) {
        activation_ = activation;
    }
    public String getAddress() {
        return address_;
    }
    public void setAddress(String address) {
        address_ = address;
    }
    public int getAvailability() {
        return getAvailabilityType().getId();
    }
    public void setAvailability(int availability) {
        setAvailabilityType(AvailabilityType.find(availability));
    }
    public AvailabilityType getAvailabilityType() {
        return availabilityType_ == null ? INACTIVATION : availabilityType_;
    }
    public void setAvailabilityType(AvailabilityType availabilityType) {
        availabilityType_ = availabilityType;
    }
    public int getType() {
        return getDeviceType().getId();
    }
    public void setType(int type) {
        setDeviceType(DeviceType.find(type));
    }
    public DeviceType getDeviceType() {
        return deviceType_ == null ? UNKNOWN : deviceType_;
    }
    public void setDeviceType(DeviceType deviceType) {
        deviceType_ = deviceType;
    }
    public long getDeviceId() {
        return deviceId_;
    }
    @Id( IdType.IDENTITY )
    public void setDeviceId(long deviceId) {
        deviceId_ = deviceId;
    }
    public long getUserId() {
        return userId_;
    }
    public void setUserId(long userId) {
        userId_ = userId;
    }
}
