package jp.sourceforge.shovel.entity.impl;

import static org.jivesoftware.smack.Roster.SubscriptionMode.*;
import static jp.sourceforge.shovel.AvailabilityType.*;
import static jp.sourceforge.shovel.DeviceType.*;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;

import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import org.apache.commons.lang.ArrayUtils;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.collections.ReferenceMap;
import org.jivesoftware.smackx.packet.ChatStateExtension;
import org.jivesoftware.smackx.packet.MessageEvent;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.log.Logger;


import jp.sourceforge.shovel.DeviceType;
import jp.sourceforge.shovel.entity.IConnectionWrapper;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IStatusToken;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IDirectoryLogic;
import jp.sourceforge.shovel.logic.IShovelLogic;
import jp.sourceforge.shovel.thread.XMPPMain;

public class ConnectionWrapperImpl implements IConnectionWrapper {
    static Logger logger = Logger.getLogger(XMPPMain.class);
    
    DeviceType deviceType_;
    String displayName_;
    String host_;
    String userId_;
    String password_;
    int port_;
    String serviceName_;
    boolean sasl_;
    boolean ssl_;
    
    public String getDevice() {
        return getDeviceType().getKey();
    }
    public void setDevice(String device) {
        setDeviceType(DeviceType.find(device));
    }
    public DeviceType getDeviceType() {
        return deviceType_ == null ? UNKNOWN : deviceType_;
    }
    public void setDeviceType(DeviceType deviceType) {
        deviceType_ = deviceType;
    }
    public String getDisplayName() {
        return displayName_;
    }
    public void setDisplayName(String displayName) {
        displayName_ = displayName;
    }
    public String getHost() {
        return host_;
    }
    public void setHost(String host) {
        host_ = host;
    }
    public String getUserId() {
        return userId_;
    }
    public void setUserId(String userId) {
        userId_ = userId;
    }
    public String getPassword() {
        return password_;
    }
    public void setPassword(String password) {
        password_ = password;
    }
    public int getPort() {
        return port_;
    }
    public void setPort(int port) {
        port_ = port;
    }
    public String getServiceName() {
        return serviceName_;
    }
    public void setServiceName(String serviceName) {
        serviceName_ = serviceName;
    }
    public boolean isSasl() {
        return sasl_;
    }
    public void setSasl(boolean sasl) {
        sasl_ = sasl;
    }
    public boolean isSsl() {
        return ssl_;
    }
    public void setSsl(boolean ssl) {
        ssl_ = ssl;
    }
    
    /////
    
    final static String NS_MESSAGE_EVENT = "jabber:x:event";
    final static String NS_CHAT_STATE = "http://jabber.org/protocol/chatstates";
    
    BlockingQueue<Object> queue_;
    Map<String, Chat> chatsByJabber_ = new ReferenceMap<String, Chat>(
            ReferenceMap.HARD, ReferenceMap.WEAK);
    XMPPConnection connection_;
    
    String splitJabberId(Chat chat) {
        String jabberId = chat.getParticipant();
        int endIndex = jabberId.lastIndexOf("/");
        if (endIndex == -1) {
            return jabberId;
        }
        return jabberId.substring(0, endIndex);
    }
    String splitClientId(Chat chat) {
        String jabberId = chat.getParticipant();
        int endIndex = jabberId.lastIndexOf("/");
        if (endIndex == -1) {
            return jabberId;
        }
        return jabberId.substring(endIndex);
    }
    public void chatCreated(Chat chat, boolean createdLocally) {
        chat.addMessageListener(this);
    }
    public void processMessage(Chat chat, Message message) {
        MessageEvent msgEvent = (MessageEvent)message.getExtension(NS_MESSAGE_EVENT);
        ChatStateExtension chatState = (ChatStateExtension)message.getExtension(NS_CHAT_STATE);
        
        try {
            boolean post = false;
            //TODO メッセンジャーによって若干癖が。。
            if (msgEvent == null) {
                //GTalk
                if (chatState.getElementName() == "active") {
                    post = true;
                }
            } else {
                //Adium, Spark
                if (msgEvent.isComposing() && (chatState == null || chatState.getElementName() == "active")) {
                    post = true;
                }
            }
            if (post) {
                String address = splitJabberId(chat).toLowerCase();
                chatsByJabber_.put(address, chat);
                IUser user = getDirectoryLogic().getUserByDevice(deviceType_, address);
                
                if (user == null) {
                    //BAN
                    return;
                }
                IDevice device = user.getDevice();
                if (device.getAvailabilityType() == INACTIVATION) {
                    String releaseKey = user.getReleaseKey();
                    if (releaseKey.compareTo(message.getBody()) == 0) {
                        //解除！
                        device.setAvailabilityType(ON);
                        getShovelLogic().updateDevice(device);
                        //TODO アクティベートしたことを通知
                        //Your device has been verified and is on. Send 'off' at any time to silence. Send 'help' for more.
                        sendMessage(address, "アカウントを確認しました。\nデバイスに通知を開始します。\n通知を止めたいときは\"off\"を送ってください。\n詳細については\"help\"を送ってください。");
                    } else {
                        //TODO 解除キーを催促
                    }
                    return;
                }
                
                String status = message.getBody();
                
                IStatusToken[] tokens = getShovelLogic().parseStatus(status);
                long referenceSenderId = 0;
                boolean open = false;
                long senderId = user.getUserId();
                if (tokens != null && tokens.length > 0) {
                    for (IStatusToken token : tokens) {
                        switch (token.getType()) {
                        case 2:
                            open = true;
                        case 1:
                            String foreignKey = tokens[0].getRegs()[1];
                            user = getDirectoryLogic().getUserByForeignKey(foreignKey);
                            referenceSenderId = user.getUserId();
                        default:
                            break;
                        }
                    }
                }
                getDirectoryLogic().incrementStatus(user.getForeignKey());
                getShovelLogic().recvStatus(message.getBody(), "im", referenceSenderId, open, senderId);
            }
        } catch (XMPPException e) {
            //TODO 送信に失敗
        } catch (ApplicationException e) {
            //TODO 受信に失敗
        }
    }
    //（チャットできる人）名簿回り
    public void entriesAdded(Collection<String> addresses) {
    }
    public void entriesUpdated(Collection<String> addresses) {
    }
    public void entriesDeleted(Collection<String> addresses) {
    }
    public void presenceChanged(Presence presence) {
    }
    //Jetiのパクリ
    public static class MySSLSocketFactory extends SSLSocketFactory {
        SSLSocketFactory factory;
        public MySSLSocketFactory() {
            try {
                SSLContext sslcontent = SSLContext.getInstance("TLS");
                sslcontent.init(null, // KeyManager not required
                                new TrustManager[] {new MyTrustManager()},
                                new java.security.SecureRandom());
                factory = sslcontent.getSocketFactory();
            } catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            } catch (KeyManagementException e) {
                e.printStackTrace();
            }
        }
        public Socket createSocket(Socket socket, String s, int i,boolean flag) throws IOException {
            return factory.createSocket(socket, s, i, flag);
        }
        public Socket createSocket(InetAddress inaddr, int i,InetAddress inaddr2, int j) throws IOException {
            return factory.createSocket(inaddr, i, inaddr2, j);
        }
        public Socket createSocket(InetAddress inaddr, int i) throws IOException {
            return factory.createSocket(inaddr, i);
        }
        public Socket createSocket(String s, int i, InetAddress inaddr, int j)  throws IOException {
            return factory.createSocket(s, i, inaddr, j);
        }
        public Socket createSocket(String s, int i) throws IOException {
            Socket so = factory.createSocket(s, i);
             ((SSLSocket)so).addHandshakeCompletedListener(
                new HandshakeCompletedListener() {
                   public void handshakeCompleted(
                      HandshakeCompletedEvent event) {
                      System.out.println("Handshake finished!");
                      System.out.println(
                      "\t CipherSuite:" + event.getCipherSuite());
                      System.out.println(
                      "\t SessionId " + event.getSession());
                      System.out.println(
                      "\t PeerHost " + event.getSession().getPeerHost());
                   }
                }
             );
            return so;
        }
        public String[] getDefaultCipherSuites() {
            return factory.getSupportedCipherSuites();
        }
        public String[] getSupportedCipherSuites() {
            return factory.getSupportedCipherSuites();
        }
    }
    static class MyTrustManager implements X509TrustManager {
        public void checkClientTrusted(X509Certificate[] chain, String authType) {  }
        public void checkServerTrusted(X509Certificate[] chain, String authType)  {
            try {
                chain[0].checkValidity();
            } catch (CertificateExpiredException e) {
            } catch (CertificateNotYetValidException e) {
            }
        }
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
    
    /////
    
    /**
     * XMPPサーバーに接続
     * Google talkはしょっぱなからSSL/TSLでの通信を要求する
     * 環境によりポートが5223だったり443だったりする理由はいまいち
     */
    public void connect() throws ApplicationException {
        queue_ = new SynchronousQueue<Object>();
        ConnectionConfiguration config;
        if (host_ != null && port_ > 0) {
            if (serviceName_ == null) {
                config = new ConnectionConfiguration(host_, port_);
            } else {
                config = new ConnectionConfiguration(host_, port_, serviceName_);
            }
        } else {
            config = new ConnectionConfiguration(serviceName_);
        }
        
        try {
            if (sasl_) {
                config.setSASLAuthenticationEnabled(true);
            }
            if (ssl_) {
                config.setSocketFactory(new MySSLSocketFactory());
            }
            connection_ = new XMPPConnection(config);
            //connection_.DEBUG_ENABLED = true;
            
            connection_.connect();
            connection_.login(getUserId(), getPassword());
        } catch (XMPPException e) {
            //isConnectedがtrueを返すので。。
            throw new ApplicationException("");
        }
        
        ChatManager chatManager = connection_.getChatManager();
        chatManager.addChatListener(this);
        
        Roster roster = connection_.getRoster();
        roster.setSubscriptionMode(accept_all);
        roster.addRosterListener(this);
    }
    /**
     * XMPPサーバーとの接続の切断
     */
    public void disconnect() {
        //呼ぶと次回起動時にsocket closedで失敗する。。
//      connection_.disconnect();
        connection_ = null;
    }
    /**
     * 送信するメッセージをキューに溜める
     */
    public void pushMessage(IStatus status) throws ApplicationException {
        if (!isConnected()) {
            return;
        }

        try {
            queue_.put(status);
        } catch (InterruptedException e) {
            //TODO
            throw new ApplicationException("");
        }
    }
    
    /**
     * こちらから接触を試みる
     */
    public void pushContact(IUser user) throws ApplicationException {
        try {
            queue_.put(user);
        } catch (InterruptedException e) {
            //TODO
            throw new ApplicationException("");
        }
    }
    
    //TODO リソース化
    //書式は{アカウントID}: {本文}
    String bodyFormat_ = "{0}: {1}";
    
    public void dispatch() throws ApplicationException {
        if (!isConnected()) {
            return;
        }
        
        try {
            Object o = queue_.take();
            sendMessage((IStatus)o);
        } catch (InterruptedException e) {
            //TODO
            throw new ApplicationException("");
        } catch (XMPPException e) {
            //TODO
            throw new ApplicationException("");
        } catch (Exception e) {
        }
    }
    
    void createEntry(IUser user) throws XMPPException {
        Roster roster = connection_.getRoster();
        roster.createEntry(user.getAddress(), user.getForeignKey(), null);
    }
    
    void sendMessage(String address, String body) throws XMPPException {
        if (address == null || address.length() <= 0) {
            return;
        }
        Message message = new Message();
        message.setTo(address);
        message.setBody(body);
        
        String to = message.getTo();
        Chat chat = chatsByJabber_.get(to);
        if (chat == null) {
            ChatManager chatManager = connection_.getChatManager();
            chat = chatManager.createChat(to, this);
        }
        chat.sendMessage(message);
    }
    /**
     * キューに溜めたメッセージの送信
     * Application Server > XMPP Server
     */
    void sendMessage(IStatus status) throws XMPPException {
        long senderId = status.getSenderId();
        long receiverId = status.getReferenceSenderId();
        IUser sender = getDirectoryLogic().getUser(senderId);
        Object[] args = {sender.getForeignKey(), status.getBody()};
        MessageFormat formatter = new MessageFormat(bodyFormat_);
        String body = formatter.format(args);
        
        Set<Long> userIdSet = new HashSet<Long>();
        //初回は送信者にも返す
        userIdSet.add(senderId);
        long friendshipId = 0;
        //TODO
        int limit = 50;
        while (true) {
            boolean nextPage = false;
            if (receiverId <= 0) {
                IFriendship[] follows = getShovelLogic().getFollowers(senderId, deviceType_, friendshipId, limit + 1);
                if (follows != null && follows.length > 0) {
                    nextPage = follows.length > limit;
                    if (nextPage) {
                        follows = (IFriendship[])ArrayUtils.subarray(follows, 0, limit);
                    }
                    for (IFriendship follow : follows) {
                        long userId = follow.getActiveId();
                        userIdSet.add(userId);
                    }
                }
            }
            userIdSet.remove(0);
            long[] userIds = ArrayUtils.toPrimitive(userIdSet.toArray(new Long[userIdSet.size()]));
            IUser[] users = this.getDirectoryLogic().getUsers(userIds);
            if (users == null || users.length <= 0) {
                return;
            }
            //TODO 一括でメッセージを投げる方法はないものか。。
            for (IUser user : users) {
                sendMessage(user.getAddress(), body);
            }
            if (!nextPage) {
                break;
            }
        }
    }
    
    public boolean isConnected() {
        return connection_ != null && connection_.isConnected();
    }
/*
    public void setQueue(BlockingQueue<Object> queue) {
        queue_ = queue;
    }
*/
    
    /////
    
    S2Container container_;
    
    public void setContainer(S2Container container) {
        container_ = container;
    }
    S2Container getContainer() {
        return container_;
    }
    IDirectoryLogic getDirectoryLogic() {
        return (IDirectoryLogic)getContainer().getComponent(IDirectoryLogic.class);
    }
    IShovelLogic getShovelLogic() {
        return (IShovelLogic)getContainer().getComponent(IShovelLogic.class);
    }
}
