package jp.sourceforge.shovel.dao;

import org.seasar.dao.annotation.tiger.Arguments;
import org.seasar.dao.annotation.tiger.S2Dao;

import jp.sourceforge.shovel.DeviceType;
import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.entity.impl.UserImpl;

@S2Dao(bean = UserImpl.class)
public interface IUserDao {
    int insert(IUser user);
    
    @Arguments("user")
    int update(IUser user);
    @Arguments({"userId", "serverFileId", "modifiedTime"})
    int updatePicture(long userId, long serverFileId, long modifiedTime);
    @Arguments({"userId", "password", "modifiedTime"})
    int updatePassword(long userId, String password, long modifiedTime);
    @Arguments({"userId", "repliesType", "modifiedTime"})
    int updateReplies(long userId, RepliesType repliesType, long modifiedTime);
    @Arguments("user")
    int updateFromImportCsv(IUser user);
    @Arguments({"userIds", "modifiedTime", "remove"})
    int updateRemove(long[] userIds, long modifiedTime, boolean remove);
    @Arguments("userId")
    int updateIncrementGivenFavorites(long userId);
    @Arguments("userId")
    int updateDecrementGivenFavorites(long userId);
    @Arguments("foreignKey")
    int updateIncrementFavorites(String foreignKey);
    @Arguments("foreignKey")
    int updateDecrementFavorites(String foreignKey);
    @Arguments("statusId")
    int updateDecrementFavoritesByStatus(long statusId);
    @Arguments("foreignKey")
    int updateIncrementFriends(String foreignKey);
    @Arguments("foreignKey")
    int updateDecrementFriends(String foreignKey);
    @Arguments("foreignKey")
    int updateIncrementDirectMessages(String foreignKey);
    @Arguments("foreignKey")
    int updateDecrementDirectMessages(String foreignKey);
    //TODO オブジェクトじゃないとだめ？
    @Arguments("userIds")
    int updateDecrementAllFriends(long[] userIds);
    @Arguments("foreignKey")
    int updateIncrementFollowers(String foreignKey);
    @Arguments("foreignKey")
    int updateDecrementFollowers(String foreignKey);
    //TODO オブジェクトじゃないとだめ？
    @Arguments("userIds")
    int updateDecrementAllFollowers(long[] userIds);
    @Arguments("foreignKey")
    int updateIncrementStatuses(String foreignKey);
    @Arguments("foreignKey")
    int updateDecrementStatuses(String foreignKey);
    
    //データを残すので廃止
    @Arguments("userId")
    int delete(long userId);
    //データを残すので廃止
    @Arguments("userIds")
    int deleteAll(long[] userIds);
    
    @Arguments("userId")
    IUser find( long userId );
    @Arguments("foreignKey")
    IUser findByForeignKey(String foreignKey);
    @Arguments({"deviceType", "address"})
    IUser findByDevice(DeviceType deviceType, String address);
    @Arguments({"remove", "sortType", "sortOrderType", "offset", "limit"})
    IUser[] findAll(boolean remove, SortType sortType, SortOrderType sortOrderType, int offset, int limit);
    @Arguments({"remove", "offset", "limit"})
    IUser[] findAllByRand(boolean remove, int offset, int limit);
    @Arguments({"userIds", "limit"})
    IUser[] findAllByUser(long[] userIds, int limit);
    @Arguments({"foreignKeys", "limit"})
    IUser[] findAllByForeignKey(String[] foreignKeys, int limit);
}
