package jp.sourceforge.shovel.dao;

import jp.sourceforge.shovel.entity.IFavorite;
import jp.sourceforge.shovel.entity.impl.FavoriteImpl;

import org.seasar.dao.annotation.tiger.Arguments;
import org.seasar.dao.annotation.tiger.S2Dao;

@S2Dao(bean = FavoriteImpl.class)
public interface IFavoriteDao {
    int insert(IFavorite favorite);
    
    @Arguments({"statusId", "userId"})
    int delete(long statusId, long userId);
    
    @Arguments({"statusId", "userId"})
    IFavorite findFavorite(long statusId, long userId);
    @Arguments({"statusIds", "userId", "limit"})
    IFavorite[] findAllFavorite(long[] statusIds, long userId, int limit);
}
