package jp.sourceforge.shovel.dao;

import org.seasar.dao.annotation.tiger.Arguments;
import org.seasar.dao.annotation.tiger.S2Dao;

import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.entity.impl.DirectMessageImpl;

@S2Dao(bean = DirectMessageImpl.class)
public interface IDirectMessageDao {
    int insert(IDirectMessage directMessage);
    
    @Arguments({"directMessageId", "sent"})
    int updateRemove(long directMessageId, boolean sent);
    
    @Arguments("directMessageId")
    IDirectMessage find(long directMessageId);
    @Arguments({"recipientId", "offset", "limit"})
    IDirectMessage[] findAllInbox(long recipientId, int offset, int limit);
    @Arguments({"senderId", "offset", "limit"})
    IDirectMessage[] findAllSent(long senderId, int offset, int limit);
    @Arguments({"recipientId", "sinceId", "limit"})
    IDirectMessage[] findAllInboxSinceId(long recipientId, long sinceId, int limit);
    @Arguments({"senderId", "sinceId", "limit"})
    IDirectMessage[] findAllSentSinceId(long senderId, long sinceId, int limit);
    @Arguments({"recipientId", "sentTime", "limit"})
    IDirectMessage[] findAllInboxSinceTime(long recipientId, long sentTime, int limit);
    @Arguments({"senderId", "sentTime", "limit"})
    IDirectMessage[] findAllSentSinceTime(long senderId, long sentTime, int limit);
    
    int delete();
}
