package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.IUpdateStatusAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusForm;
import jp.sourceforge.shovel.service.IShovelService;

public class UpdateStatusActionImpl implements IUpdateStatusAction {
    IStatusForm actionForm_;
    S2Container container_;
    HttpServletRequest request_;
    HttpSession session_;
    
    @Perform(CSRF=true)
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        
        IShovelService shovelService = getShovelService();
        IStatus status = shovelService.updateStatus(actionForm_.getStatus(), actionForm_.getSource());
        
        shovelService.prepareForView(new IStatus[] {status}, 1, false);
        request_.setAttribute("status", status);
        
        String forward = null;
        switch (formatType) {
        case HTML:
            break;
        case JSON:
        case XML:
            forward = XML;
            break;
        default:
            throw new ApplicationException("");
        }
        return forward;
    }
    public void setStatusForm(IStatusForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setSession(HttpSession session) {
        session_ = session;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
