package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.ISessionConst.*;
import static jp.sourceforge.shovel.SortType.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;


import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.action.IUpdateAccountAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.IUpdateAccountForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IServerFileService;
import jp.sourceforge.shovel.service.IShovelService;
import jp.sourceforge.shovel.util.ServerFileUtil;

/**
 * iframeからのアクセスはコンテンツを返す
 */
public class UpdateAccountActionImpl implements IUpdateAccountAction {
    IUpdateAccountForm actionForm_;
    HttpServletRequest request_;
    HttpSession session_;
    
    @Perform(CSRF=true, administrator=true)
    public String perform() throws Exception {
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IServerFileService serverFileService = shovelService.getServerFileService();
        
        IUser user = directoryService.getUser(actionForm_.getUserId());
        user.setAdministrator(actionForm_.isAdministrator());
        user.setDisplayName(actionForm_.getDisplayName());
        user.setForeignKey(actionForm_.getForeignKey());
        user.setEmail(actionForm_.getEmail());
        user.setLocation(actionForm_.getLocation());
        user.setTimeZoneId(actionForm_.getTimeZoneId());
        user.setDescription(actionForm_.getDescription());
        user.setPassword(actionForm_.getPassword());
        IServerFile serverFile = user.getServerFile();
        if (actionForm_.isRemoveFile() && serverFile.isExist()) {
            serverFileService.removeServerFile(serverFile);
        }
        serverFile = ServerFileUtil.toServerFile(actionForm_.getFile(), null);
        if (serverFile.isExist()) {
            serverFileService.createServerFile(serverFile, false);
            user.setServerFile(serverFile);
        } else if (actionForm_.isRemoveFile()) {
            user.setServerFile(serverFile);
        }
        directoryService.updateUserFromSettings(user);
        
        IListRefine listRefine = (IListRefine)session_.getAttribute(S_LIST_REFINE);
        SortOrderType sortOrderType = listRefine.getSortOrderType();
        int page = listRefine.getPage();
        IUser[] temp = directoryService.getUsers(false, USER_ID, sortOrderType, page);
        boolean nextPage = false;
        if (temp != null && temp.length > 0) {
            IUser[] users = shovelService.prepareForView(temp, 0);
            nextPage = temp.length > users.length;
            request_.setAttribute("users", users);
        }
        request_.setAttribute("nextPage", nextPage);
        
        request_.setAttribute("callback", "window.parent.shovel.controller.onChangeConfig($('#content').html());");
        request_.setAttribute("template", "system/accounts.ftl");
        
        return SUCCESS;
    }
    public void setUpdateAccountForm(IUpdateAccountForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setSession(HttpSession session) {
        session_ = session;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
