package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.ICommonConst.*;
import static jp.sourceforge.shovel.ISessionConst.*;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;


import jp.sourceforge.shovel.ErrorPageType;
import jp.sourceforge.shovel.action.IRootAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.form.ILoginForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.util.HttpUtil;

public class RootActionImpl implements IRootAction {
    IDirectoryService directoryService_;
    ILoginForm actionForm_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    HttpSession session_;
    
    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        //クライアントからログアウトを要求された
        if (actionForm_.isLogout()) {
            directoryService_.logout();
            session_.removeAttribute(S_LOGOUT);
            session_.removeAttribute(S_LIST_REFINE);
            //トップページにリダイレクト
            HttpUtil.sendRedirect(response_, "/");
            return null;
        }
        boolean administrator = false;
        if (session_.getAttribute(S_ADMINISTRATOR) == null) {
            //ログインしてる人が管理者でない
            if (session_.getAttribute(S_LOGIN) != null) {
                //ログイン中ならHomeにリダイレクト
                HttpUtil.sendRedirect(response_, "/home");
                return null;
            }
        } else {
            administrator = true;
        }
        request_.setAttribute("administrator", administrator);
        
        //「次回もこのログイン名を使用する」がON
        Cookie[] cookies = request_.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getName().compareTo(LOGIN_COOKIE_NAME) == 0) {
                    actionForm_.setAccount(cookie.getValue());
                    actionForm_.setSaveAccount(true);
                    break;
                }
            }
        }
        
        //クッキーより書き戻しを優先させる
        ILoginForm sessionForm = (ILoginForm)session_.getAttribute(S_ACTION_FORM);
        if (sessionForm != null) {
            actionForm_.setAccount(sessionForm.getAccount());
            actionForm_.setSaveAccount(sessionForm.isSaveAccount());
            //書き戻しはログインの失敗が起因
            String errorCode = (String)session_.getAttribute(S_ERROR_CODE);
            session_.removeAttribute(S_ERROR_CODE);
            //TODO
            request_.setAttribute("errorCode", errorCode);
        }
        session_.removeAttribute(S_ADMINISTRATOR);
        session_.removeAttribute(S_ACTION_FORM);
        
        ErrorPageType errorPageType = (ErrorPageType)request_.getAttribute(ERROR_PAGE_TYPE);
        if (errorPageType.isXhr()) {
            //ajaxによるリクエストはコンテンツを空で
            return null;
        }
        return SUCCESS;
    }
    public void setDirectoryService(IDirectoryService directoryService) {
        directoryService_ = directoryService;
    }
    public void setLoginForm(ILoginForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setResponse(HttpServletResponse response) {
        response_ = response;
    }
    public void setSession(HttpSession session) {
        session_ = session;
    }
}
