package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.ICommonConst.*;
import static jp.sourceforge.shovel.ISessionConst.*;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.sourceforge.shovel.action.ILoginAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.ILoginForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.util.HttpUtil;

public class LoginActionImpl implements ILoginAction {
    ILoginForm actionForm_;
    IDirectoryService directoryService_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    HttpSession session_;
    
    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        //フォーム認証はログイン情報をセッションに積む
        IUser user = directoryService_.login(actionForm_.getAccount(),
                                             actionForm_.getPassword(),
                                             actionForm_.isAdministrator(),
                                             false);
        String url;
        if (user == null) {
            //セッション経由でエラーを伝播
            //TODO
            session_.setAttribute(S_ERROR_CODE, "LOGIN00000");
            session_.setAttribute(S_ACTION_FORM, actionForm_);
            url = "/";
        } else {
            //クッキーにユーザ名書き出し
            Cookie cookie = new Cookie(LOGIN_COOKIE_NAME, actionForm_.getAccount());
            cookie.setPath("/");
            if (actionForm_.isSaveAccount()) {
                //賞味期限は1週間
                cookie.setMaxAge(60 * 60 * 24 * 7);
            } else {
                //即削除
                cookie.setMaxAge(0);
            }
            response_.addCookie(cookie);
            //UrlRewriteFilterでつんでれ
            url = (String)session_.getAttribute(S_LOGIN_REDIRECT_URL);
            if (url == null) {
                url = "/public_timeline";
            }
        }
        HttpUtil.sendRedirect(response_, url);
        return null;
    }
    public void setDirectoryService(IDirectoryService directoryService) {
        directoryService_ = directoryService;
    }
    public void setLoginForm(ILoginForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setResponse(HttpServletResponse response) {
        response_ = response;
    }
    public void setSession(HttpSession session) {
        session_ = session;
    }
}
