package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.ILeaveNotificationAction;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IFriendshipForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class LeaveNotificationActionImpl implements ILeaveNotificationAction {
    IFriendshipForm actionForm_;
    HttpServletRequest request_;
    
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        
        IShovelService shovelService = getShovelService();
        long userId = actionForm_.getUserId();
        String foreignKey = actionForm_.getForeignKey();
        int result;
        if (foreignKey.matches("^[0-9]+$")) {
            foreignKey = null;
            result = shovelService.updateFriendshipNotify(userId, false);
        } else {
            userId = 0;
            result = shovelService.updateFriendshipNotify(foreignKey, false);
        }
        if (result <= 0) {
            //TODO
            throw new ApplicationException("");
        }
        
        String forward = null;
        switch (formatType) {
        case HTML:
            break;
        case JSON:
        case XML:
            IStatus status;
            if (userId > 0) {
                status = shovelService.getRecent(userId);
            } else {
                status = shovelService.getRecent(foreignKey);
            }
            if (status == null) {
                IDirectoryService directoryService = shovelService.getDirectoryService();
                IUser user = directoryService.getUser(foreignKey);
                shovelService.prepareForView(new IUser[] {user}, 1);
                request_.setAttribute("user", user);
            } else {
                shovelService.prepareForView(new IStatus[] {status}, 1, false);
                request_.setAttribute("status", status);
            }
            forward = formatType.getId();
            break;
        default:
            throw new ApplicationException("");
        }
        return forward;
    }
    
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setFriendshipForm(IFriendshipForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
