package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.ISessionConst.*;
import static jp.sourceforge.shovel.ViewType.*;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.ArrayUtils;
import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.IFriendsTimelineAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class FriendsTimelineActionImpl implements IFriendsTimelineAction {
    IStatusesForm actionForm_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    S2Container container_;
    HttpSession session_;
    
    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        String foreignKey = actionForm_.getForeignKey();
        long userId = actionForm_.getUserId();
        IUser user = null;
        if (foreignKey == null || foreignKey.length() <= 0) {
            user = directoryService.getLoginUser();
        } else if (foreignKey.matches("^[0-9]+$")) {
            user = directoryService.getUser(userId);
        } else {
            user = directoryService.getUser(foreignKey);
        }
        shovelService.prepareForView(new IUser[] {user}, 1);
        request_.setAttribute("user", user);
        
        int page = actionForm_.getPage();
        String since = actionForm_.getSince();
        int limit = actionForm_.getCount();
        IListRefine listRefine = null;
        IStatus[] statuses = null;
        IStatus[] temp = null;
        IStatus status = null;
        if (formatType.isHtml()) {
            listRefine = (IListRefine)session_.getAttribute(S_LIST_REFINE);
            if (listRefine == null ||
                (!listRefine.getViewType().isRecent() && !listRefine.getViewType().isWithFriends()) ||
                (listRefine.getViewType().isRecent() && foreignKey != null && foreignKey.length() > 0) ||
                (listRefine.getViewType().isWithFriends() && (foreignKey == null || foreignKey.length() <= 0))) {
                listRefine = (IListRefine)container_.getComponent(IListRefine.class);
                session_.setAttribute(S_LIST_REFINE, listRefine);
            } else if (actionForm_.getMethodType().isPage()) {
                listRefine.setPage(actionForm_.getPage());
            }
            page = listRefine.getPage();
            since = null;
            limit = 0;
            
            if (foreignKey == null || foreignKey.length() <= 0) {
                temp = shovelService.getStatuses(user.getForeignKey(), true, page, limit, 0, 1);
                statuses = shovelService.prepareForView(temp, limit, true);
            } else {
                int correctedLimit = 0;
                if (formatType.isHtml()) {
                    correctedLimit = 2;
                    status = shovelService.getRecent(user.getForeignKey());
                    request_.setAttribute("status", status);
                }
                statuses = shovelService.getStatuses(user.getForeignKey(), true, page, limit, 0, correctedLimit);
                if (status == null) {
                    temp = statuses;
                } else {
                    temp = (IStatus[])ArrayUtils.add(statuses, status);
                }
                shovelService.prepareForView(temp, limit, false);
            }
        } else {
            if (since == null) {
                since = request_.getHeader("If-Modified-Since");
            }
            if (since == null) {
                statuses = shovelService.getStatuses(user.getForeignKey(), true, page, limit, 0, 0);
            } else {
                statuses = shovelService.getStatuses(user.getForeignKey(), true, since, limit);
            }
            shovelService.prepareForView(statuses, limit, false);
        }
        
        String forward = null;
        switch (formatType) {
        case HTML:
            if (foreignKey == null || foreignKey.length() <= 0) {
                listRefine.setViewType(RECENT);
                forward = actionForm_.isPartial() ? HOME_PARTIAL : HOME_FULL;
            } else {
                listRefine.setViewType(WITH_FRIENDS);
                boolean friend = shovelService.isFriend(user.getForeignKey());
                request_.setAttribute("friend", friend);
                
                //truncate位置の決定
                temp = statuses;
                if (status != null) {
                    if (temp[0].getStatusId() < status.getStatusId()) {
                        //上にあるから上を削る
                        temp = (IStatus[])ArrayUtils.subarray(temp, 1, temp.length);
                    } else if (temp[temp.length - 1].getStatusId() > status.getStatusId()) {
                        //下にあるから下を削る
                        temp = (IStatus[])ArrayUtils.subarray(temp, 0, temp.length - 1);
                    } else {
                        //取得した中にある
                        List<IStatus> statusList = new ArrayList<IStatus>();
                        for (IStatus tmp : temp) {
                            if (tmp.getStatusId() != status.getStatusId()) {
                                statusList.add(tmp);
                            }
                        }
                        temp = statusList.toArray(new IStatus[statusList.size()]);
                    }
                }
                statuses = shovelService.truncate(temp, limit);
                forward = actionForm_.isPartial() ? PEOPLE_PARTIAL : PEOPLE_FULL;
            }
            boolean nextPage = false;
            if (statuses != null && statuses.length > 0) {
                nextPage = temp.length > statuses.length;
            }
            request_.setAttribute("nextPage", nextPage);
            
            IFriendship[] friendships = shovelService.getFriends(user.getForeignKey(), 0, 100);
            request_.setAttribute("viewAllFriends", friendships.length > 100);
            friendships = shovelService.prepareForView(friendships, 100, true);
            request_.setAttribute("friendships", friendships);
            break;
        case XML:
        case JSON:
            forward = formatType.getId();
            break;
        case ATOM:
        case RSS:
            shovelService.outputFeed(formatType, FRIENDS_TIMELINE, user, statuses);
            return null;
        default:
            throw new ApplicationException("");
        }
        request_.setAttribute("statuses", statuses);
        
        return forward;
    }
    
    public void setStatusesForm(IStatusesForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setResponse(HttpServletResponse response) {
        response_ = response;
    }
    public void setSession(HttpSession session) {
        session_ = session;
    }
}
