package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.ISessionConst.*;
import static jp.sourceforge.shovel.ViewType.*;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.IFollowersAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IFriendshipForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class FollowersActionImpl implements IFollowersAction {
    IFriendshipForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;
    HttpSession session_;
    
    @Perform(CSRF=false, login=true)
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        
        int page = actionForm_.getPage();
        int limit = actionForm_.getCount();
        if (formatType.isHtml()) {
            //TODO
            IListRefine listRefine = (IListRefine)session_.getAttribute(S_LIST_REFINE);
            if (listRefine == null || !listRefine.getViewType().isFollowers()) {
                listRefine = (IListRefine)container_.getComponent(IListRefine.class);
                session_.setAttribute(S_LIST_REFINE, listRefine);
            } else if (actionForm_.getMethodType().isPage()) {
                listRefine.setPage(actionForm_.getPage());
            }
            listRefine.setViewType(FOLLOWERS);

            page = listRefine.getPage();
            limit = 0;
        }
        
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        String foreignKey = actionForm_.getForeignKey();
        long userId = actionForm_.getUserId();
        IUser user;
        if (foreignKey == null || foreignKey.length() <= 0) {
            user = directoryService.getLoginUser();
            foreignKey = user.getForeignKey();
        } else if (foreignKey.matches("^[0-9]+$")) {
            user = directoryService.getUser(userId);
        } else {
            user = directoryService.getUser(foreignKey);
        }
        request_.setAttribute("user", user);
        
        IFriendship[] temp = shovelService.getFollowers(foreignKey, true, page, limit);
        IFriendship[] followers = shovelService.prepareForView(temp, limit, true);
        request_.setAttribute("friendships", followers);
        
        String forward = null;
        switch (formatType) {
        case JSON:
        case XML:
            IStatus[] statuses;
            if (followers != null && followers.length > 0) {
                long[] userIds = new long[followers.length];
                int i = 0;
                for (IFriendship follower : followers) {
                    userIds[i++] = follower.getActiveId();
                }
                statuses = shovelService.getRecents(userIds);
                shovelService.prepareForView(statuses, 0, true);
            } else {
                statuses = new IStatus[0];
            }
            Map<String, IStatus> statusMap = new HashMap<String, IStatus>();
            for (IStatus status : statuses) {
                long senderId = status.getSenderId();
                statusMap.put(String.valueOf(senderId), status);
            }
            request_.setAttribute("statuses", statusMap);
            
            forward = formatType.getId();
            break;
        case HTML:
            if (followers != null && followers.length > 0) {
                request_.setAttribute("nextPage", temp.length > followers.length);
            }
            
            forward = actionForm_.isPartial() ? PARTIAL : FULL;
            break;
        default:
            throw new ApplicationException("");
        }
        
        return forward;
    }
    public void setFriendshipForm(IFriendshipForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setSession(HttpSession session) {
        session_ = session;
    }
}
