package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.arnx.jsonic.JSON;

import jp.sourceforge.shovel.DeviceType;
import jp.sourceforge.shovel.action.IDeviceAction;
import jp.sourceforge.shovel.entity.IConnectionWrapper;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IDeviceForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class DeviceActionImpl implements IDeviceAction {
    IDeviceForm actionForm_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    
    class JSONBean {
        IUser user_;
        IConnectionWrapper connectionWrapper_;
        
        public JSONBean(IUser user, IConnectionWrapper connectionWrapper) {
            user_ = user;
            connectionWrapper_ = connectionWrapper;
        }
        public String getReleaseKey() throws ApplicationException {
            return user_.getReleaseKey();
        }
        public String getAddress() {
            StringBuilder address = new StringBuilder(connectionWrapper_.getUserId());
            address.append("@");
            address.append(connectionWrapper_.getServiceName());
            return address.toString();
        }
    }
    
    public String perform() throws Exception {
        IUser user = getDirectoryService().getLoginUser();
        IConnectionWrapper connectionWrapper = null;
        
        switch (actionForm_.getPhase()) {
        default:
        case 0:  //デバイスの種類とアドレスの入力
            DeviceType deviceType = actionForm_.getDeviceType();
            String address = actionForm_.getAddress();
            getShovelService().createDevice(deviceType, address);
            connectionWrapper = getShovelService().getConnectionWrapper(deviceType);
            break;
        case 1:  //やり直し
            getShovelService().resetDevice();
            break;
        case 2:  //使用する機能
            getShovelService().updateDevice(actionForm_.getAvailabilityType());
            break;
        }
        
        String json = JSON.encode(new JSONBean(user, connectionWrapper));
        response_.getOutputStream().write(json.getBytes("UTF-8"));
        
        return null;
    }
    public void setDeviceForm(IDeviceForm actionForm) {
        actionForm_ = actionForm;
    }
    public IDirectoryService getDirectoryService() {
        return getShovelService().getDirectoryService();
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setResponse(HttpServletResponse response) {
        response_ = response;
    }
}
