package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.IDestroyDirectMessageAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IDirectMessageForm;
import jp.sourceforge.shovel.service.IShovelService;

public class DestroyDirectMessageActionImpl implements IDestroyDirectMessageAction {
    IDirectMessageForm actionForm_;
    HttpServletRequest request_;
    HttpSession session_;
    S2Container container_;
    
    @Perform(CSRF=true)
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        
        IShovelService shovelService = getShovelService();
        long directMessageId = actionForm_.getDirectMessageId();
        shovelService.removeDirectMessage(directMessageId);
        
        String forward = null;
        switch (formatType) {
        case HTML:
            break;
        case JSON:
        case XML:
            IDirectMessage directMessage = shovelService.getDirectMessage(
                    directMessageId);
            shovelService.prepareForView(new IDirectMessage[] {directMessage}, false);
            
            request_.setAttribute("directMessage", directMessage);
            
            forward = formatType.getId();
            break;
        default:
            throw new ApplicationException("");
        }
        return forward;
    }
    
    public void setDirectMessageForm(IDirectMessageForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
}
