package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.ISessionConst.*;
import static jp.sourceforge.shovel.ViewType.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.IArchiveAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

//TODO 削除されたユーザーを友だちから削除
public class ArchiveActionImpl implements IArchiveAction {
    IStatusesForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;
    HttpSession session_;
    
    @Perform(CSRF=false)
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser user = directoryService.getLoginUser();
        
        int page = actionForm_.getPage();
        int limit = actionForm_.getCount();
        if (formatType.isHtml()) {
            IListRefine listRefine = (IListRefine)session_.getAttribute(S_LIST_REFINE);
            if (listRefine == null || !listRefine.getViewType().isArchive()) {
                listRefine = (IListRefine)container_.getComponent(IListRefine.class);
                session_.setAttribute(S_LIST_REFINE, listRefine);
            } else if (actionForm_.getMethodType().isPage()) {
                listRefine.setPage(actionForm_.getPage());
            }
            listRefine.setViewType(ARCHIVE);

            page = listRefine.getPage();
            limit = 0;
        }
        
        IStatus[] temp = shovelService.getStatuses(user.getForeignKey(), false, page, limit, 0, 1);
        IStatus[] statuses = shovelService.prepareForView(temp, limit, true);
        boolean nextPage = false;
        if (statuses != null && statuses.length > 0) {
            nextPage = temp.length > statuses.length;
        }
        request_.setAttribute("nextPage", nextPage);
        request_.setAttribute("statuses", statuses);
        
        String forward = null;
        switch (formatType) {
        case HTML:
            if (user != null) {
                shovelService.prepareForView(new IUser[] {user}, 1);
                request_.setAttribute("user", user);
                IFriendship[] friendships = shovelService.getFriends(user.getForeignKey(), 0, 100);
                request_.setAttribute("viewAllFriends", friendships.length > 100);
                friendships = shovelService.prepareForView(friendships, 100, true);
                request_.setAttribute("friendships", friendships);
            }
            forward = actionForm_.isPartial() ? PARTIAL : FULL;
            break;
        case JSON:
        case XML:
            forward = formatType.getId();
            break;
        default:
            //TODO
            throw new ApplicationException("");
        }
        
        return forward;
    }
    
    public void setStatusesForm(IStatusesForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setSession(HttpSession session) {
        session_ = session;
    }
}
