package jp.sourceforge.shovel;

public enum SizeType {
    X_LARGE     ("xlarge",  73),
    LARGE       ("large",   48),
    MIDDLE      ("middle",  31),
    SMALL       ("small",   24);
    
    String id_;
    int px_;
    
    SizeType(String id, int px) {
        id_ = id;
        px_ = px;
    }
    public String getId() {
        return id_;
    }
    public int getPx() {
        return px_;
    }
    public static SizeType find(String id) {
        for (SizeType type :SizeType.values()) {
            if (id.compareToIgnoreCase(type.getId()) == 0) {
                return type;
            }
        }
        return null;
    }
    public boolean isXLarge() {
        return this == X_LARGE;
    }
    public boolean isLarge() {
        return this == LARGE;
    }
    public boolean isMiddle() {
        return this == MIDDLE;
    }
    public boolean isSmall() {
        return this == SMALL;
    }
}
