package jp.sourceforge.shovel;

public enum ServicePropertyType {
    UNKNOWN         ("unknown"),
    DISPLAY_NAME    ("displayName"),
    TYPE            ("type"),
    HOST            ("host"),
    PORT            ("port"),
    SASL            ("sasl"),
    SSL             ("ssl"),
    SERVICE_NAME    ("serviceName"),
    USER_ID         ("userId"),
    PASSWORD        ("password");
    
    String key_;
    
    ServicePropertyType(String key) {
        key_ = key;
    }
    public String getKey() {
        return key_;
    }
    public static ServicePropertyType find(String key) {
        for(ServicePropertyType type :ServicePropertyType.values()) {
            if(type.getKey().compareToIgnoreCase(key) == 0) {
                return type;
            }
        }
        return UNKNOWN;
    }
}
