package jp.sourceforge.shovel;

public enum DeviceType {
    ALL         ("all", -1, ""),
    UNKNOWN     ("unknown", 0, ""),
    GTALK       ("gtalk", 1, "GTalk"),
    JABBER      ("jabber", 2, "Jabber");
    
    String key_;
    int id_;
    String displayName_;
    
    DeviceType(String key, int id, String displayName) {
        key_ = key;
        id_ = id;
        displayName_ = displayName;
    }
    public String getKey() {
        return key_;
    }
    public int getId() {
        return id_;
    }
    public String getDisplayName() {
        return displayName_;
    }
    public static DeviceType find(String key) {
        for(DeviceType type :DeviceType.values()) {
            if(key.compareTo(type.getKey()) == 0) {
                return type;
            }
        }
        return UNKNOWN;
    }
    public static DeviceType find(int id) {
        for(DeviceType type :DeviceType.values()) {
            if(type.getId() == id) {
                return type;
            }
        }
        return UNKNOWN;
    }
    public boolean isAll() {
        return this == ALL;
    }
    public boolean isUnknown() {
        return this == UNKNOWN;
    }
    public boolean isGtalk() {
        return this == GTALK;
    }
    public boolean isJabber() {
        return this == JABBER;
    }
}
