<?php
require_once( dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'HttpRequest.class.php');
require_once( dirname(__FILE__)
	.DIRECTORY_SEPARATOR.'Terminal.class.php');
//
//header('Content-Type: text/plain;charset=UTF-8');
//$hash	= util_mobile_getDoCoMoAgentHash();
//echo "現在の機種数：".count( $hash )."\n\n";
//print_r( $hash );
//
/**
 * DoCoMo
 */
function util_mobile_getDoCoMoAgentHash() {
	$url			= 'http://www.nttdocomo.co.jp/service/imode/make/content/spec/useragent/index.html';
	$IRREGULAR_TAGS	= array(
		'D253i'	=> '<!-- /D506i -->',
		'D253iWM'	=> '<!-- /P253i -->',
		'D851iWM'	=> '<!-- /P702i -->',
		'F883iES'	=> '</tr>',
		'D903iTV'	=> '<!-- /SO903i -->',
	);
	$VENDER_STRING_HASH	= array(
		'SH'	=> 'SHARP',
		'SO'	=> 'SONY',
		'SA'	=> 'SANYO',
		'ER'	=> 'エリクソン',
		'KO'	=> '日立国際電気',
		'N'		=> 'NEC',
		'D'		=> '三菱',
		'F'		=> '富士通',
		'P'		=> 'Panasonic',
		'L'		=> 'LG電子',
		'M'		=> 'Motorola',
		'T'		=> '東芝',
		'R'		=> '日本無線',
	);
	
	$http_object	= new util_HttpRequest();
	$http_object->open($url);
	$http_object->send(null);
	$body_string	= mb_convert_encoding( $http_object->responseBody, 'UTF-8', 'SJIS-win' );
	
	$terminal_hash			= array();
	$vars_tags_aray			= array();
	preg_match_all( '/\\<\\!\\-\\-\\s[A-Z][0-9a-zA-Z]+\\s\\-\\-\\>/'
		, $body_string
		, $vars_tags_aray
		, PREG_OFFSET_CAPTURE );
	foreach ( $vars_tags_aray as $vars_tags ) {
		foreach ( $vars_tags as $vars_tag_info ) {
			$var_tag	= $vars_tag_info[0];
			$tag_pos	= $vars_tag_info[1];
			$terminal_name	= preg_replace('/^\\<\\!\\-\\-\\s/','',$var_tag);
			$terminal_name	= preg_replace('/\\s\\-\\-\\>$/','',$terminal_name);
			$end_tag		= '<!-- /'.$terminal_name.' -->';
			
			if( isset($IRREGULAR_TAGS[$terminal_name]) ) {
				$end_tag	= $IRREGULAR_TAGS[$terminal_name];
			}
			$end_pos		= strpos($body_string,$end_tag,$tag_pos);
			$target_str		= substr($body_string,$tag_pos,$end_pos-$tag_pos);
			$target_str		= str_replace($var_tag,"",$target_str);
			$target_str		= str_replace("</tr>","",$target_str);
			$target_str		= str_replace("</td>","",$target_str);
			$target_str		= preg_replace('/\\sclass\\=\\"[0-9a-zA-Z]+\\"/','',$target_str);
			$target_str		= str_replace("<span>","",$target_str);
			$target_str		= str_replace("</span>","",$target_str);
			list( $blank, $terminal_view_name, $agent_cell, $agent_cell2 )	= explode('<td>',$target_str);
			$terminal_view_name		= preg_replace('/<[aA]\\s[^>]+?>(.)+?<\\/[aA]>/','',$terminal_view_name);
			$terminal_view_name		= preg_replace('/<[^>]+?>/','',$terminal_view_name);
			$terminal_view_name		= trim($terminal_view_name);
			
			
			$agent_cell				= trim( $agent_cell.$agent_cell2 );
			$agent_cell				= preg_replace('/<[aA]\\s[^>]+?>(.)+?<\\/[aA]>/','',$agent_cell);
			$agent_cell				= preg_replace('/<[bB][rR]>/',"\n",$agent_cell);
			$agent_cell				= preg_replace('/<[bB][rR]\\s\\/>/',"\n",$agent_cell);
			$agent_cell				= str_replace("\n\n","\n",$agent_cell);
			$agent_cell				= preg_replace('/<[^>]+?>/','',$agent_cell);
			$agent_cell				= trim($agent_cell);
			$agent_array			= explode("\n", $agent_cell );
			$agent_new_array		= array();
			foreach( $agent_array as $agent_str ) {
				if( preg_match( '/DoCoMo/', $agent_str ) > 0 ) {
					list( $agent_str, $ext )	= explode('&nbsp',$agent_str );
					list( $agent_str, $ext )	= explode(' （',$agent_str );
					if( strlen(trim($agent_str)) > 0 ) {
						$agent_str		= str_replace("（","(",$agent_str);
						$agent_str		= str_replace("）",")",$agent_str);
						array_push( $agent_new_array, trim($agent_str) );
					}
				}
			}
			// 判断用
			$terminal_view_name	= str_replace("&nbsp;"," ",$terminal_view_name);
			$generation	= 'MOVA';
			$agent_str	= $agent_new_array[0];
			if( preg_match('/\\(/',$agent_str) > 0 ) {
				// (を含むなら(までを抜き出し
				$result_user_agent
					= substr($agent_str,0,strpos($agent_str, '(')+1 );
				$carrier	= 'docomo2';
				$generation	= 'FOMA';
			} else {
				// (を含まないなら/で区切って3つ目までを抜き出し
				$elms	= explode('/',$agent_str );
				$result_user_agent
					= $elms[0].'/'.$elms[1].'/'.$elms[2];
				$carrier	= 'docomo';
			}
			$vender		= '不明';
			foreach( $VENDER_STRING_HASH as $key => $name ) {
				if( preg_match('/^'.$key.'/',$terminal_view_name) > 0 ) {
					$vender	= $name;
					break;
				}
			}
			
			$terminal_hash[$result_user_agent]	= new util_mobile_Terminal();
			$terminal_hash[$result_user_agent]->terminal_name	= $terminal_view_name;
			$terminal_hash[$result_user_agent]->generation		= $generation;
			$terminal_hash[$result_user_agent]->user_agent		= $result_user_agent;
			$terminal_hash[$result_user_agent]->carrier			= $carrier;
			$terminal_hash[$result_user_agent]->vender			= $vender;
			$terminal_hash[$result_user_agent]->user_agents		= $agent_new_array;
		}
		return $terminal_hash;
	}
}
/**
 * SoftBank
 */
function util_mobile_getSoftBankAgentHash() {
	$IRREGULAR_TAGS	= array(
		'304T'	=> '</table>',
	);
	$url			= 'http://creation.mb.softbank.jp/terminal/index.html';
	$http_object	= new util_HttpRequest();
	$http_object->open($url);
	$http_object->send(null);
	$http_object->responseBody	= mb_convert_encoding( $http_object->responseBody, 'UTF-8', 'SJIS-win' );
	$http_object->responseBody	= preg_replace('/\\sclass\\=\\"[0-9a-zA-Z]+\\"/','',$http_object->responseBody);
	$http_object->responseBody	= preg_replace('/\\sbgcolor\\=\\"\\#[0-9a-zA-Z]+\\"/','',$http_object->responseBody);
	$http_object->responseBody	= preg_replace('/\\swidth\\=\\"[0-9a-zA-Z]+\\"/','',$http_object->responseBody);
	$http_object->responseBody	= preg_replace('/\\sheight\\=\\"[0-9a-zA-Z]+\\"/','',$http_object->responseBody);
	$terminal_hash			= array();
	$vars_tags_aray			= array();
	preg_match_all( '/<td\\srowspan\\=\\"5\\">(.)+<\\/td>/'
		, $http_object->responseBody
		, $vars_tags_aray
		, PREG_OFFSET_CAPTURE );
	foreach ( $vars_tags_aray as $vars_tags ) {
		foreach ( $vars_tags as $vars_tag_info ) {
			$var_tag	= $vars_tag_info[0];
			$tag_pos	= $vars_tag_info[1];
			$terminal_name	= str_replace('<td rowspan="5">','',$var_tag);
			$terminal_name	= str_replace('</td>','',$terminal_name);
			$terminal_name	= str_replace("\r\n","",$terminal_name);
			$terminal_name	= str_replace("\r","",$terminal_name);
			$terminal_name	= str_replace("\n","",$terminal_name);
			list( $terminal_name, $comment )	= explode('<!--',$terminal_name);
			$terminal_name	= str_replace("　"," ",$terminal_name);
			$terminal_name	= str_replace("<br>"," ",$terminal_name);
			$comment	= str_replace("-->","",$comment);
			list( $null, $vender, $generation )	= explode('<br>',$comment);

			$end_tag		= '<td rowspan="5">';
			if( isset($IRREGULAR_TAGS[$terminal_name]) ) {
				$end_tag	= $IRREGULAR_TAGS[$terminal_name];
			}
			$end_pos		= strpos($http_object->responseBody,$end_tag,$tag_pos+strlen($end_tag));
			$target_str		= substr($http_object->responseBody,$tag_pos+strlen($end_tag),$end_pos-$tag_pos-strlen($end_tag));
			
			$target_str		= trim(substr($target_str,strpos($target_str,'</td>')+5));
			$string_array	= explode('<tr>',$target_str);
			foreach( $string_array as $key => $str ) {
				$str	= trim(substr($str,0,strpos($str,'</tr>')));
				if( strlen(trim($str)) > 0 ) {
					$string_array[$key]
						= trim(preg_replace('/<[^>]+?>/','',$str));
				} else {
					unset($string_array[$key]);
				}
			}
			// シリアルがあるならシリアルの前までを抜き出し
			$agent	= $string_array[0];
			if( preg_match('/\\[\\/Serial\\]/', $agent ) > 0 ) {
				$result_user_agent
					= trim(substr($agent,0,strpos($agent,'[/Serial]')));
			} else {
				$result_user_agent
					= $agent;
			}
			// ベンダ
			$vender	= preg_replace('/^\\[/','',$vender);
			$vender	= preg_replace('/\\]$/','',$vender);
			
			$terminal_hash[$result_user_agent]	= new util_mobile_Terminal();
			$terminal_hash[$result_user_agent]->terminal_name	= $terminal_name;
			$terminal_hash[$result_user_agent]->generation		= $generation;
			$terminal_hash[$result_user_agent]->vender			= $vender;
			$terminal_hash[$result_user_agent]->user_agent		= $result_user_agent;
			$terminal_hash[$result_user_agent]->carrier			= 'softbank';
			$terminal_hash[$result_user_agent]->user_agents		= $string_array;

		}
		
		return $terminal_hash;
	}
	
}
/**
 * au
 */
function util_mobile_getAuAgentHash() {
	$url			= 'http://www.au.kddi.com/ezfactory/tec/spec/4_4.html';
	$VENDER_STRING_HASH	= array(
		'CA'	=> 'CASIO',
		'SH'	=> 'SHARP',
		'SO'	=> 'SONY',
		'SA'	=> 'SANYO',
		'ER'	=> 'エリクソン',
		'KO'	=> '日立国際電気',
		'K'		=> 'KYOCERA',
		'S'		=> 'ソニーエリクソン',
		'N'		=> 'NEC',
		'D'		=> '三菱',
		'F'		=> '富士通',
		'P'		=> 'Panasonic',
		'L'		=> 'LG電子',
		'M'		=> 'Motorola',
		'T'		=> '東芝',
		'R'		=> '日本無線',
		'H'		=> 'HITACHI',
	);
	$http_object	= new util_HttpRequest();
	$http_object->open($url);
	$http_object->send(null);
	$http_object->responseBody	= mb_convert_encoding( $http_object->responseBody, 'UTF-8', 'SJIS-win' );
	$http_object->responseBody	= str_replace( "\r\n", "\n", $http_object->responseBody );
	$http_object->responseBody	= str_replace( "\r", "\n", $http_object->responseBody );
	$terminal_hash			= array();
	$vars_tags_aray			= array();
	preg_match_all( '/<tr\\sbgcolor\\=\\"\\#ffffff\\">/'
		, $http_object->responseBody
		, $vars_tags_aray
		, PREG_OFFSET_CAPTURE );
	foreach ( $vars_tags_aray as $vars_tags ) {
		foreach ( $vars_tags as $vars_tag_info ) {
			$var_tag	= $vars_tag_info[0];
			$tag_pos	= $vars_tag_info[1];
			$end_tag		= '</tr>';
			$end_pos		= strpos($http_object->responseBody,$end_tag,$tag_pos+22);
			$target_str		= substr($http_object->responseBody,$tag_pos+22,$end_pos-$tag_pos-22);
			$target_str	= str_replace( "\r\n", "", $target_str );
			$target_str	= str_replace( "\r", "", $target_str );
			$target_str	= str_replace( "\n", "", $target_str );
			$target_str	= preg_replace('/\\sclass\\=\\"[0-9a-zA-Z]+\\"/','',$target_str);
			$target_str	= preg_replace('/\\snowrap/','',$target_str);
			$target_str	= preg_replace('/\\sbgcolor\\=\\"\\#[0-9a-zA-Z]+\\"/','',$target_str);
			$target_str	= preg_replace('/<div>/','',$target_str);
			$target_str	= preg_replace('/<\\/div>/','',$target_str);
			$target_str	= preg_replace('/<td>/','',$target_str);
			$target_str	= preg_replace('/<br>/','',$target_str);
			$tmp_array	= explode('</td>',$target_str);
			
			$terminal_name	= trim($tmp_array[0]);
			$terminal_name	= str_replace('<br>','',$terminal_name);
			$terminal_name	= str_replace('&nbsp;','',$terminal_name);
			if( strlen(trim($terminal_name)) > 0 ) {
				$generation		= trim($tmp_array[1]);
				$vender		= '不明';
				foreach( $VENDER_STRING_HASH as $key => $name ) {
					if( preg_match('/[0-9][0-9]'.$key.'/',$terminal_name) > 0 ) {
						$vender	= $name;
						break;
					}
				}
				if( preg_match('/\\//',$generation) > 0 ) {
					$generation_array	= explode('/',$generation);
					foreach( $generation_array as $generation_str ) {
						if( strlen(trim($generation_str)) > 4 ) {
							$generation_str	= substr($generation_str,0,4);
						}
						$hash_key	= 'KDDI-'.$generation_str;
						$terminal_hash[$hash_key]	= new util_mobile_Terminal();
						$terminal_hash[$hash_key]->terminal_name	= $terminal_name;
						$terminal_hash[$hash_key]->generation		= $generation_str;
						$terminal_hash[$hash_key]->vender			= $vender;
						$terminal_hash[$hash_key]->user_agent		= 'KDDI-'.$generation_str.' UP.Browser';
						$terminal_hash[$hash_key]->carrier			= 'au';
						$terminal_hash[$hash_key]->user_agents		= array('KDDI-'.$generation_str.' UP.Browser');
					}
				} else {
					if( strlen(trim($generation)) > 4 ) {
						$generation	= substr($generation,0,4);
					}
					$hash_key	= 'KDDI-'.$generation;
					$terminal_hash[$hash_key]	= new util_mobile_Terminal();
					$terminal_hash[$hash_key]->terminal_name	= $terminal_name;
					$terminal_hash[$hash_key]->generation		= $generation;
					$terminal_hash[$hash_key]->vender			= $vender;
					$terminal_hash[$hash_key]->user_agent		= 'KDDI-'.$generation.' UP.Browser';
					$terminal_hash[$hash_key]->carrier			= 'au';
					$terminal_hash[$hash_key]->user_agents		= array('KDDI-'.$generation.' UP.Browser');
				}
			}

			$terminal_name	= trim($tmp_array[2]);
			$terminal_name	= str_replace('<br>','',$terminal_name);
			$terminal_name	= str_replace('&nbsp;','',$terminal_name);
			if( strlen(trim($terminal_name)) > 0 ) {
				$generation		= trim($tmp_array[3]);
				$vender		= '不明';
				foreach( $VENDER_STRING_HASH as $key => $name ) {
					if( preg_match('/[0-9][0-9]'.$key.'/',$terminal_name) > 0 ) {
						$vender	= $name;
						break;
					}
				}
				if( preg_match('/\\//',$generation) > 0 ) {
					$generation_array	= explode('/',$generation);
					foreach( $generation_array as $generation_str ) {
						if( strlen(trim($generation_str)) > 4 ) {
							$generation_str	= substr($generation_str,0,4);
						}
						$hash_key	= 'KDDI-'.$generation_str;
						$terminal_hash[$hash_key]	= new util_mobile_Terminal();
						$terminal_hash[$hash_key]->terminal_name	= $terminal_name;
						$terminal_hash[$hash_key]->generation		= $generation_str;
						$terminal_hash[$hash_key]->vender			= $vender;
						$terminal_hash[$hash_key]->user_agent		= 'KDDI-'.$generation_str.' UP.Browser';
						$terminal_hash[$hash_key]->carrier			= 'au';
						$terminal_hash[$hash_key]->user_agents		= array('KDDI-'.$generation_str.' UP.Browser');
					}
				} else {
					if( strlen(trim($generation)) > 4 ) {
						$generation	= substr($generation,0,4);
					}
					$hash_key	= 'KDDI-'.$generation;
					$terminal_hash[$hash_key]	= new util_mobile_Terminal();
					$terminal_hash[$hash_key]->terminal_name	= $terminal_name;
					$terminal_hash[$hash_key]->generation		= $generation;
					$terminal_hash[$hash_key]->vender			= $vender;
					$terminal_hash[$hash_key]->user_agent		= 'KDDI-'.$generation.' UP.Browser';
					$terminal_hash[$hash_key]->carrier			= 'au';
					$terminal_hash[$hash_key]->user_agents		= array('KDDI-'.$generation.' UP.Browser');
				}
			}

			$terminal_name	= trim($tmp_array[4]);
			$terminal_name	= str_replace('<br>','',$terminal_name);
			$terminal_name	= str_replace('&nbsp;','',$terminal_name);
			if( strlen(trim($terminal_name)) > 0 ) {
				$generation		= trim($tmp_array[5]);
				$vender		= '不明';
				foreach( $VENDER_STRING_HASH as $key => $name ) {
					if( preg_match('/[0-9][0-9]'.$key.'/',$terminal_name) > 0 ) {
						$vender	= $name;
						break;
					}
				}
				if( preg_match('/\\//',$generation) > 0 ) {
					$generation_array	= explode('/',$generation);
					foreach( $generation_array as $generation_str ) {
						if( strlen(trim($generation_str)) > 4 ) {
							$generation_str	= substr($generation_str,0,4);
						}
						$hash_key	= 'KDDI-'.$generation_str;
						$terminal_hash[$hash_key]	= new util_mobile_Terminal();
						$terminal_hash[$hash_key]->terminal_name	= $terminal_name;
						$terminal_hash[$hash_key]->generation		= $generation_str;
						$terminal_hash[$hash_key]->vender			= $vender;
						$terminal_hash[$hash_key]->user_agent		= 'KDDI-'.$generation_str.' UP.Browser';
						$terminal_hash[$hash_key]->carrier			= 'au';
						$terminal_hash[$hash_key]->user_agents		= array('KDDI-'.$generation_str.' UP.Browser');
					}
				} else {
					if( strlen(trim($generation)) > 4 ) {
						$generation	= substr($generation,0,4);
					}
					$hash_key	= 'KDDI-'.$generation;
					$terminal_hash[$hash_key]	= new util_mobile_Terminal();
					$terminal_hash[$hash_key]->terminal_name	= $terminal_name;
					$terminal_hash[$hash_key]->generation		= $generation;
					$terminal_hash[$hash_key]->vender			= $vender;
					$terminal_hash[$hash_key]->user_agent		= 'KDDI-'.$generation.' UP.Browser';
					$terminal_hash[$hash_key]->carrier			= 'au';
					$terminal_hash[$hash_key]->user_agents		= array('KDDI-'.$generation.' UP.Browser');
				}
			}


		}
	}
	return $terminal_hash;
}
?>