<?php
/*
 * topic/Load.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class topic_Load extends system_login_ModuleBase {
	function topic_Load() {
	}
	function execute( & $request ) {
		
		if( !defined('TOPIC_FILE_URI_TOPICS') || strlen(TOPIC_FILE_URI_TOPICS)==0 ) {
			$request->addError('設定が正しく行われていません。');
			return false;
		}
		
		$topicId				= mb_convert_kana(trim(stripslashes($_GET['tid'])),'a');
		
		if( strlen($topicId) == 0 ) {
			// 記事ID未指定
			$request->addError('記事の指定方法が正しくありません。');
		} else if( preg_match('/^[0-9]+$/',$topicId) == 0 ) {
			// 記事IDが不正
			$request->addError('記事の指定方法が正しくありません。');
		} else {
			// 番号指定があるなら記事を読み込み
			$topicObject	= spider_Controller::createObject('topic_Topic');
			if( $topicObject->load( $request, $topicId ) ) {
				// 表示の為の調整
				$topicObject->convertForView( $request );
			} else {
				$request->addError('指定された記事は存在しません。');
			}
		}
		$request->setAttribute('topic.topicObject',$topicObject);
	}
}
?>