<?php
/*
 * topic/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class topic_Execute extends system_login_ModuleBase {
	function topic_Execute() {
	}
	function execute( & $request ) {
		
		$topicId			= stripslashes( $_GET['tid'] );
		$sessionObjectName		= 'topic.modify.object.'.$topicId;
		$sessionConfirmName		= 'topic.modify.confirm.'.$topicId;
		$topicObject			= $request->getSession($sessionObjectName);
		$compareTopicObject		= spider_Controller::createObject('topic_Topic');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$comfirmResult			= $request->getSession($sessionConfirmName);
		
		if( 'OK' != $comfirmResult ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( get_class($topicObject) != get_class($compareTopicObject) ){
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			if ( strlen($topicObject->topicId) == 0 ) {
				// 記事IDが設定されていないなら記事IDを生成
				$topicObject->topicId	= null;
				for( $i=0; $i<99; $i++ ) {
					$id	= date('Ymd').sprintf('%02d',$i);	//Ymd+2桁
					// 重複チェック
					$enable	= false;
					if( !$compareTopicObject->load( $request, $id ) ) {
						$enable	= true;
					}
					// 重複がないなら
					if( $enable ) {
						$topicObject->topicId	= $id;
						break;
					}
				}
				if( is_null($topicObject->topicId) ) {
					$request->addError('記事番号を正しく発行できませんでした。');
				}
				$topicObject->registeredDate	= date('Y-m-d H:i:s');
			}
			if( $request->isError() ) {
			} else {
				// 最終更新日時を設定
				$topicObject->updatedDate	= date('Y-m-d H:i:s');
				$topicObject->convertKanaFields( 'KVa' );
				// 記事情報の保存
				if ( $topicObject->save( $request ) ) {
				} else {
					$request->addError('記事本文の保存に失敗しました。');
				}
			}
		}
		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('topic.topicObject',$topicObject);
	}
}
?>