<?php
/*
 * system/tools/update/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-10-08
 */
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 
 * 
 * @package system
 * @subpackage tools
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 */
class system_tools_update_LoadList extends system_login_ModuleBase {
	function system_tools_update_LoadList(){
	}
	function execute( & $request ) {
		// 更新SVNのURL
		$svnBaseUrl	= SYSTEM_UPDATE_SVN_URL;
		if( preg_match('/\\/$/',$svnBaseUrl) == 0 ) {
			$svnBaseUrl	.= '/';
		}
		// XMLのURL
		$upXmlUrl	= $svnBaseUrl.RELEASE_NAME.'/current/update.xml';
		// SVN接続
		$headerParms	= array();
		$headerParms['Authorization']	= 'Basic '.base64_encode(SYSTEM_UPDATE_SVN_ID.':'.SYSTEM_UPDATE_SVN_PW);
		spider_Controller::loadClassDefinition('util_HttpRequest');
		$httpRequest	= new util_HttpRequest($upXmlUrl,'get',$headerParms);
		// HTTPリクエスト実行
		if( false === $httpRequest->send(null,60) ) {
			// リクエスト失敗
			$request->addLocaledError('system.error.tools.update.httprequest',SPIDER_LOG_LEVEL_ERROR,array($httpRequest->statusCode,$httpRequest->statusMessage));
			return false;
		}
		if( '200' != $httpRequest->statusCode ) {
			// レスポンスエラー
			$request->addLocaledError('system.error.tools.update.httprequest',SPIDER_LOG_LEVEL_ERROR,array($httpRequest->statusCode,$httpRequest->statusMessage));
			return false;
		}
		// 通信に問題ないならレスポンスボディを出力
		$request->setResponseHeader('Content-Type','text/plain;charset=UTF-8');
		$request->setResponseBody($httpRequest->responseBody);
	}
}
?>