<?php
/*
 * system/login/Login.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
/**
 * ログイン用アクションモジュールクラス
 * 
 * 管理システムにログインする機能を提供します。
 * ログイン情報読み込みの処理は設定ファイルに指定されたsystem_admin_IFLoginインターフェースの
 * 実装に移譲します。設定ファイルにログイン情報読み込み処理が指定されていない場合、
 * システム管理者ログイン情報を利用してログイン処理を行います。
 * 
 * @package system
 * @subpackage login
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 */
class system_login_Login extends system_login_ModuleBase {
	function system_login_Login(){
	}
	function execute( & $request ) {

		$keepLogin				= trim( stripslashes( $_POST['keep'] ) );
		$loginId				= stripslashes( $_POST['login_id'] );
		$loginPassword			= stripslashes( $_POST['password'] );
		// ログイン操作のたびにセッションIDを変更
		$request->renewSessionId();
		// ログインベースURIの確認
		if( !$request->existsSession(SYSTEM_SESSION_NAME_LOGIN_BASE_URI) ) {
			$request->setSession( SYSTEM_SESSION_NAME_LOGIN_BASE_URI, dirname(SPIDER_URI_REQUEST)
				, SPIDER_SESSION_SCOPE_GLOBAL );
		}
		// リダイレクトURLの確認
		$redirectUri	= $request->getSession( SYSTEM_SESSION_NAME_LAST_LOGIN_ERROR_URI );
		// ログインユーザーオブジェクトの宣言 
		$loginInformationObject	= null;
		$loginUserClassName		= null;
		if ( strlen( $loginId ) < 1 ) {
			$request->addLocaledError('system.error.login.user.requireloginid',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if ( strlen( $loginPassword ) < 1 ){
			$request->addLocaledError('system.error.login.user.requirepassword',SPIDER_LOG_LEVEL_ERROR,array());
		}
		
		$userClassNameArray	= array();
		if( !$request->isError() ) {
			// 全てのユーザー定義クラスの読み込み
			$userClassNameArray	= system_PackageConfig::loadAllUserClassFile( $request );
		}
		if( !$request->isError() ) {
			// 全ての定義クラスで優先順に指定ログインIDの情報を読み込めるか確認
			$existsUser	= false;
			foreach( $userClassNameArray as $userClassName ) {
				if( class_exists($userClassName) ) {
					$loginInformationObject	= new $userClassName;
					if( is_a($loginInformationObject,'system_login_AbstractUser') ) {
						// ユーザークラスの実装として定義されている
						if( $loginInformationObject->loadLoginUser( $request, $loginId ) ) {
							// 読み込みに成功したらパスワードを比較
							if( $loginInformationObject->confirmPassword( $request, $loginPassword ) ) {
								$loginUserClassName	= $userClassName;
							} else {
								$request->addLocaledError('system.error.login.user.invalidlogin',SPIDER_LOG_LEVEL_ERROR,array());
							}
							$existsUser	= true;
							break;
						} else {
							// 読み込めなかったら次の定義クラスを確認する為エラーにしない
							$loginInformationObject	= null;
						}
					} else {
						// AbstractUserの実装ではない
						$loginInformationObject	= null;
						$request->addLocaledError('system.error.config.invalidsendclassname',SPIDER_LOG_LEVEL_ERROR,array($userClassName));
						break;
					}
				}
			}
			if( !$existsUser ) {
				// 全ての定義クラスで読み込んでもユーザーが見つからない場合はエラー
				$request->addLocaledError('system.error.login.user.invalidlogin',SPIDER_LOG_LEVEL_ERROR,array());
			}
		}

		if ( $request->isError() || is_null($loginInformationObject) ) {
			// ログインエラーの場合はリダイレクト先をセッションに再登録
			$request->setSession( SYSTEM_SESSION_NAME_LAST_LOGIN_ERROR_URI, $redirectUri, SPIDER_SESSION_SCOPE_GLOBAL );
			if( !is_null($loginInformationObject) && is_a($loginInformationObject,'system_login_AbstractUser') ) {
				$loginInformationObject->registLoginHistory( $request, '201' );
			}
		} else {
			// ログインに成功している場合
			$loginInformationObject->setLoginUserAgent($_SERVER['HTTP_USER_AGENT']);
			$loginInformationObject->setLoginRemoteAddress($_SERVER['REMOTE_ADDR']);
			$loginInformationObject->setLastLoginDate(date('Y-m-d H:i:s'));
			$loginInformationObject->registLoginHistory( $request, '0' );
			$loginInformationObject->save( $request );
			// 情報をログイン情報をセッションに登録
			$request->setSession( SYSTEM_SESSION_NAME_LOGIN_INFORMATION, $loginInformationObject, SPIDER_SESSION_SCOPE_GLOBAL );
			$request->setSession( SYSTEM_SESSION_NAME_LOGIN_CLASS_NAME, $loginUserClassName, SPIDER_SESSION_SCOPE_GLOBAL );
			// クッキーを焼く(期間は30日間固定)
			if ( 'on' == $keepLogin ) {
				setcookie(SYSTEM_COOKIE_NAME_LOGIN_ID, $loginId, time()+(60*60*24*30));
				setcookie(SYSTEM_COOKIE_NAME_LOGIN_PASSWORD, $loginPassword, time()+(60*60*24*30));
			} else {
				setcookie(SYSTEM_COOKIE_NAME_LOGIN_ID, null, time()+(60*60*24*30));
				setcookie(SYSTEM_COOKIE_NAME_LOGIN_PASSWORD, null, time()+(60*60*24*30));
			}
			$request->removeSession( SYSTEM_SESSION_NAME_LAST_LOGIN_ERROR_URI, SPIDER_SESSION_SCOPE_GLOBAL );
			
			if ( strlen( trim( $redirectUri ) ) > 0 ) {
				// リダイレクト先が指定されているならリダイレクト
				$request->setResponseHeader( 'Expires', 'Mon, 26 Jul 1997 05:00:00 GMT' );
				$request->setResponseHeader( 'Cache-Control', 'no-store, no-cache, must-revalidate' );
				$request->setResponseHeader( 'Cache-Control', 'pre-check=0, post-check=0, max-age=0' );
				$request->setResponseHeader( 'Pragma', 'no-cache' );
				$request->setResponseHeader( 'Expires', '0' );
				$request->redirectTo($redirectUri);
			} else {
				// リダイレクト先が指定されていないならindex.phpにリダイレクト
				if( $request->existsSession(SYSTEM_SESSION_NAME_LOGIN_BASE_URI) ) {
					$redirectUri	= $request->getSession( SYSTEM_SESSION_NAME_LOGIN_BASE_URI );
				}
				$this->pageRedirect( $request, 'index.php' );
			}
		}
	}
}
?>