<?php
/*
 * framework-spider
 * spider/tags/SetRequestParam.class.php
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.06.23
 * 
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'TagBase.class.php');
/**
 * HTML用変換タグ：リクエストパラメータを属性に自動的に設定するタグ
 * 
 * {set-request-param:[true/false]}
 * 
 * HTTPリクエストと同時にPOST及びGETで渡されたパラメータの値を
 * get.[getのキー], post.[postキー]の名前でrequest属性に登録します。
 * 
 * デフォルトはtrueです。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.2.00
 * @copyright Copyright &copy; 2008, <m_nakashima@users.sourceforge.jp> http://sourceforge.jp/projects/shopformer/
 * @author  m.nakashima <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.3
 */
class spider_tags_SetRequestParam extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_SetRequestParam() {
		$this->priority	= 0;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$build_information ){
		
		if( preg_match('/\\{set\\-request\\-param\\:[fF][aA][lL][sS][eE]\\}/', $result_strings ) > 0
			|| preg_match('/\\{set\\-request\\-param\\:[nN][oO]\\}/', $result_strings ) > 0 ) {
			// falseかnoが指定されているなら登録しない
			$result_strings = preg_replace( '/\\{set\\-request\\-param\\:[fF][aA][lL][sS][eE]\\}/'
				, "", $result_strings );
			$result_strings = preg_replace( '/\\{set\\-request\\-param\\:[fF][aA][lL][sS][eE]\\}/'
				, "", $result_strings );
		} else {
			// 明示的に否定していないなら暗黙的にcookie及びpost,getの値をリクエストに登録
			$process_code = 'foreach($_POST as $key=>$value){'."\n";
			$process_code	.= '$request_object->setAttribute(\'post.\'.$key,$value);'."\n";
			$process_code	.= '}'."\n";
			$process_code	.= 'foreach($_GET as $key=>$value){'."\n";
			$process_code	.= '$request_object->setAttribute(\'get.\'.$key,$value);'."\n";
			$process_code	.= '}'."\n";
			$process_code	.= 'foreach($_COOKIE as $key=>$value){'."\n";
			$process_code	.= '$request_object->setAttribute(\'cookie.\'.$key,$value);'."\n";
			$process_code	.= '}'."\n";
			if( !isset($build_information->processPreModuleHash)
				|| !is_array($build_information->processPreModuleHash) ){
				$build_information->processPreModuleHash	= array();
			}
			if( !isset($build_information->processPreModuleHash[$this->priority])
				|| !is_array($build_information->processPreModuleHash[$this->priority]) ){
				$build_information->processPreModuleHash[$this->priority]	= array();
			}
			array_push( $build_information->processPreModuleHash[$this->priority], $process_code );
		}
		
	}
}
?>