<?php
/*
 * shopping/report/promotion/Payment.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-09-30
 * 
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_report_promotion_Payment extends system_login_ModuleBase {
	
	function shopping_report_promotion_Payment() {
	}
	function execute( & $request ) {
		
		$dbo				= $request->getAttribute( 'dbo' );
		$minimumPayment		= $request->getParam('minp','get');
		$command			= $request->getParam('cmd','get');
		$endYear			= $request->getParam('ey','get');
		$endMonth			= $request->getParam('em','get');
		$endDay				= $request->getParam('ed','get');
		$loginUserObject	= $this->getLoginUserObject( $request );
		
		// 最低金額の調整
		if( preg_match('/^[0-9]{1,6}$/',$minimumPayment) == 0 ) {
			$minimumPayment	= 0;
		}
		// 日付入力の調整
		if( preg_match('/^(20[0-2][0-9]|203[0-8]|19[0-9][0-9])$/',$endYear) == 0 and strlen(trim($endYear)) == 0 ) {
			$endYear = date('Y');
		}
		if( preg_match('/^((|0)[1-9]|1[0-2])$/',$endMonth) == 0 and strlen(trim($endMonth)) == 0 ) {
			$endMonth = date('m');
		}
		if( preg_match('/^((|0)[1-9]|[12][0-9]|3[0-1])$/',$endDay) == 0 and strlen(trim($endDay)) == 0 ) {
			$endDay = date('t');
		}
		if ( strlen(trim($endDay)) == 0
			|| !is_numeric($endDay)
			|| $endDay < 1
			|| $endDay > 31
		) {
			// 日が正しく指定されていない場合、月末を設定
			$end_time	= strtotime($endYear.'-'.$endMonth);
			$endDay	= date('t',$end_time);
		}
		$endDate	= '';
		spider_Controller::loadClassDefinition('util_ValidateFunctions');
		if( !util_ValidateFunctions::isAvailableDate( $endYear, $endMonth, $endDay ) ) {
			// 日付の指定が正しくない場合今月末にする
			$endYear	= date('Y');
			$endMonth	= date('m');
			$endDay		= date('t');
		} else {
			$endDate = $endYear.'-'.$endMonth.'-'.$endDay;
		}
		
		// 集計問い合わせ
		$sql	= 'SELECT '
		.TABLE_NAME_MEMBER.'.member_id, '
		.TABLE_NAME_MEMBER.'.view_name, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_code, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_name, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_kana, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_branch_code, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_branch_name, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_branch_kana, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_account_type, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_account_code, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_account_name, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_account_kana, '
		.'COUNT('.TABLE_NAME_SHOPPING_ORDER.'.order_number) AS purchase_count,'
		.'SUM('.TABLE_NAME_SHOPPING_ORDER.'.promotion_fee) AS payment_fee'
		.' FROM '.TABLE_NAME_MEMBER
		.' INNER JOIN '.TABLE_NAME_SHOPPING_PROMOTION.' ON '.TABLE_NAME_SHOPPING_PROMOTION.'.member_id='.TABLE_NAME_MEMBER.'.member_id '
		.' INNER JOIN '.TABLE_NAME_SHOPPING_ORDER.' ON '.TABLE_NAME_SHOPPING_ORDER.'.promotion_code='.TABLE_NAME_SHOPPING_PROMOTION.'.promotion_code '
		.' AND '.TABLE_NAME_SHOPPING_ORDER.'.status_promotion=10 '
		.' AND '.TABLE_NAME_SHOPPING_ORDER.'.order_date<='.$dbo->quote($endDate.' 23:59:59')
		.' LEFT OUTER JOIN '.TABLE_NAME_MEMBER_BANK_ACCOUNT.' ON '.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.member_id='.TABLE_NAME_MEMBER.'.member_id '
		.' AND '.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.order_number=0 ';
		if ( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() ) {
			$sql	.= ' WHERE '.TABLE_NAME_MEMBER.'.member_id='.$dbo->quote($loginUserObject->getUniqueId());
		}
		$sql	.= ' GROUP BY '
		.TABLE_NAME_MEMBER.'.member_id, '
		.TABLE_NAME_MEMBER.'.view_name, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_code, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_name, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_kana, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_branch_code, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_branch_name, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_branch_kana, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_account_type, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_account_code, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_account_name, '
		.TABLE_NAME_MEMBER_BANK_ACCOUNT.'.bank_account_kana'
		.' HAVING SUM('.TABLE_NAME_SHOPPING_ORDER.'.promotion_fee)>='.$minimumPayment
		;
		$resultHash	= $dbo->queryAll( $sql, 'hash' );
		if( false === $resultHash ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else if( 'topaied' == $command && SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
			// コマンド処理があるならコマンド処理
			$memberIdArray	= array();
			foreach( $resultHash as $infoHash ) {
				array_push($memberIdArray,$dbo->quote($infoHash['member_id']));
			}
			$sql	= 'UPDATE '.TABLE_NAME_SHOPPING_ORDER
			.' SET '
			.TABLE_NAME_SHOPPING_ORDER.'.status_promotion=101, '
			.TABLE_NAME_SHOPPING_ORDER.'.updated_date='.$dbo->quote(date('Y-m-d H:i:s'))
			.' WHERE '
			.TABLE_NAME_SHOPPING_ORDER.'.status_promotion=10 '
			.' AND '
			.TABLE_NAME_SHOPPING_ORDER.'.promotion_code IN ( '
			.' SELECT '.TABLE_NAME_SHOPPING_PROMOTION.'.promotion_code FROM '.TABLE_NAME_SHOPPING_PROMOTION
			.' WHERE '.TABLE_NAME_SHOPPING_PROMOTION.'.member_id IN('.implode(',',$memberIdArray).') '
			.' )';
			$result	= $dbo->query($sql);
			if( false === $result ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
			} else {
				$redirectUri	= SPIDER_URI_APP;
				$params			= array();
				foreach( $_GET as $k => $v ) {
					if( 'cmd' != $k ) {
						array_push($params,urlencode($k).'='.urlencode($v));
					}
				}
				if( count($params) > 0 ) {
					$redirectUri	.= '?'.implode('&',$params);
				}
				$request->redirectTo($redirectUri);
			}
		}
		$resultHashCount	= count($resultHash);
		$request->setAttribute('shopping.report.promotion.payment.resultHash', $resultHash);
		$request->setAttribute('shopping.report.promotion.payment.total_count', $resultHashCount);

		$request->setAttribute('shopping.report.promotion.payment.minimumPayment', $minimumPayment);
		$request->setAttribute('shopping.report.promotion.payment.end_year',	$endYear );
		$request->setAttribute('shopping.report.promotion.payment.end_month',	$endMonth );
		$request->setAttribute('shopping.report.promotion.payment.end_day',		$endDay );
	}
}
?>