<?php
/*
 * shopping/product/unit/Stock.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_product_unit_Stock extends system_login_ModuleBase {
	function shopping_product_unit_Stock(){
	}
	function execute( & $request ) {
		$dbo		= $request->getAttribute( 'dbo' );
		$unitNumber	= $request->getParam('unit_number','post');
		$stock		= $request->getParam('stock','post');
		$shoppingProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
		$loginUserObject	= $this->getLoginUserObject( $request );
		if( preg_match('/^[0-9]{1,6}$/',$unitNumber) == 0 ) {
			$request->addLocaledError('shopping.error.product.unit.invalidid',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else if( preg_match('/^[0-9]{1,6}$/',$stock) == 0 && '-1' != $stock) {
			$request->addLocaledError('shopping.error.dao.product.unit.invalidstock',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			// データ番号が指定されているなら編集の為読み込み
			if( $dbo->loadByNumber( $shoppingProductUnitObject, $unitNumber ) ) {
				if( false === $this->lockData( $request, $shoppingProductUnitObject ) ) {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else {
					if ( !$shoppingProductUnitObject->canEditData( $request, $loginUserObject ) ) {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
					} else {
						// 問題がなければ、状態をオブジェクトにセット
						$shoppingProductUnitObject->stock			= $stock;
						$shoppingProductUnitObject->updated_date	= date('Y-m-d H:i:s');
						// 問題なければ更新
						if( $dbo->update($shoppingProductUnitObject,false) ) {
						} else {
							$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
						}
					}
					$this->unlockData( $request, $shoppingProductUnitObject );
				}
			} else {
				$request->addLocaledError('shopping.error.product.unit.invalidid',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		$request->setAttribute('shopping.product.unit.unit_object',		$shoppingProductUnitObject);
	}
}
?>