<?php
/*
 * shopping/product/unit/MemberClass.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_product_unit_MemberClass extends system_login_ModuleBase {
	function shopping_product_unit_MemberClass(){
	}
	function execute( & $request ) {
		$dbo						= $request->getAttribute( 'dbo' );
		$unitNumber					= $request->getParam('unit_number','post');
		$memberViewableArray		= $request->getParam('member_viewable','post','array');
		$memberPurchasableArray		= $request->getParam('member_purchasable','post','array');
		$shoppingProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
		$loginUserObject			= $this->getLoginUserObject( $request );
		if( preg_match('/^[0-9]{1,6}$/',$unitNumber) == 0 ) {
			$request->addLocaledError('shopping.error.product.unit.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			// データ番号が指定されているなら編集の為読み込み
			if( $dbo->loadByNumber( $shoppingProductUnitObject, $unitNumber ) ) {
				if( false === $this->lockData( $request, $shoppingProductUnitObject ) ) {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else {
					if ( !$shoppingProductUnitObject->canEditData( $request, $loginUserObject ) ) {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
					} else {
						// 問題がなければ、状態をオブジェクトにセット
						$shoppingProductUnitObject->memberViewableArray		= $memberViewableArray;
						$shoppingProductUnitObject->memberPurchasableArray	= $memberPurchasableArray;
						$shoppingProductUnitObject->updated_date			= date('Y-m-d H:i:s');
						if( $shoppingProductUnitObject->validate( $request ) ) {
							$shoppingProductUnitObject->updated_date		= date('Y-m-d H:i:s');
							if( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() ) {
								// 管理者ログイン以外の場合、ステータスを新規に設定
								$shoppingProductUnitObject->status_flag = 0;
							}
							// 問題なければ更新
							if( $dbo->update($shoppingProductUnitObject,false) ) {
							} else {
									$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
							}
						}
					}
					$this->unlockData( $request, $shoppingProductUnitObject );
				}
			} else {
				$request->addLocaledError('shopping.error.product.unit.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		$request->setAttribute('shopping.product.unit.unit_object',		$shoppingProductUnitObject);
	}
}
?>