<?php
/*
 * shopping/product/status/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_product_status_Confirm extends system_login_ModuleBase {
	
	function shopping_product_status_Confirm(){
	}
	function execute( & $request ) {
		
		$dbo				= $request->getAttribute( 'dbo' );
		$productNumber		= stripslashes( $_GET['shpdn'] );
		$sessionObjectName	= 'shopping.product.status.modify.object.'.$productNumber;
		$sessionConfirmName	= 'shopping.product.status.modify.confirm.'.$productNumber;
		$request->removeSession($sessionObjectName);
		$request->removeSession($sessionConfirmName);
		$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
		$loginUserObject	= $this->getLoginUserObject( $request );

		if( !$request->isError() ) {
			if( strlen(trim($productNumber)) > 0 ) {
				// データ番号が指定されているなら編集の為読み込み
				if( $dbo->loadByNumber( $shoppingProductObject, $productNumber ) ) {
					if( false === $this->lockData( $request, $shoppingProductObject ) ) {
						$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
					} else if ( !$shoppingProductObject->canEditData( $request, $loginUserObject ) ) {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
					}
				} else {
					$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
			// 状態のセットとチェック
			$statusFlag		= stripslashes($_POST['status_flag']);
			if( strlen($GLOBALS['SHOPPING_PRODUCT_STATUS_HASH'][$statusFlag]) == 0
				|| !is_numeric($statusFlag) ) {
				$request->addLocaledError('shopping.error.common.invalidstatus',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else {
				// 問題がなければ、状態をオブジェクトにセット
				$shoppingProductObject->status_flag	= $statusFlag;
				if ( !$shoppingProductObject->canEditStatus( $request, $loginUserObject ) ) {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				}
			}
		}

		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName,$shoppingProductObject);
		$request->setAttribute('shopping.product.product_object',		$shoppingProductObject);
	}
}
?>