<?php
/*
 * shopping/product/unit/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_product_LoadList extends system_login_ModuleBase {
	function shopping_product_LoadList() {
		array_push($this->require_module_array,'shopping.category.LoadList');
	}
	function execute( & $request ) {
		$dbo				= $request->getAttribute( 'dbo' );
		$pageRows			= $request->getParam('pr','get');
		$pageNumber			= $request->getParam('pn','get');
		$queryWords			= $request->getParam('shpq','get');
		$sortItem			= $request->getParam('shpsi','get','array');
		$sortOrder			= $request->getParam('shpso','get','array');
		$shoppingCategoryId	= $request->getParam('shpci','get','array');
		$lowerLimit			= $request->getParam('shpll','get');
		$upperLimit			= $request->getParam('shpul','get');
		$statusFlag			= $request->getParam('shpstf','get');
		$memberId			= $request->getParam('mi','get');
		$owner				= $request->getParam('owner','get');
		$searchDataId		= $request->getParam('schdi','get');
		$deliveryType		= $request->getParam('shppdt','get');
		$loginUserObject	= $this->getLoginUserObject( $request );
		// カート確認
		$shoppingOrderObject	= $request->getSession(SHOPPING_SESSION_NAME_ORDER_OBJECT,SPIDER_SESSION_SCOPE_GLOBAL);
		$accessAgentClass		= $request->getAttribute('spider.access_agent_class');
		// ページング制御
		if ( !is_numeric( $pageNumber ) || $pageNumber < 1 ) {
			$pageNumber	= 1;
		}
		if ( !is_numeric( $pageRows ) || $pageRows < 1 ) {
			if( 'au'==$accessAgentClass || 'docomo'==$accessAgentClass || 'docomo2'==$accessAgentClass || 'softbank'==$accessAgentClass) {
				$pageRows		= 5;
			} else {
				$pageRows		= 20;
			}
		} else if ( $pageRows > 100 ) {
			if( 'au'==$accessAgentClass || 'docomo'==$accessAgentClass || 'docomo2'==$accessAgentClass || 'softbank'==$accessAgentClass) {
				$pageRows		= 5;
			} else {
				$pageRows		= 20;
			}
		}
		// 並び替え制御
		$sortOrderArray = array();
		if ( is_array($sortOrder) ) {
			$sortOrderArray = $sortOrder;
		} else {
			if ( strlen(trim($sortOrder)) > 0 ) {
				array_push($sortOrderArray,$sortOrder);
			}
		}
		$sortItemArray			= array();
		$orderConditionArray	= array();
		$duplicateCheckArray	= array();
		if ( is_array($sortItem) ) {
			$sortItemArray = $sortItem;
		} else {
			if ( strlen(trim($sortItem)) > 0 ) {
				array_push($sortItemArray,$sortItem);
			}
		}
		// 並べ替え
		if ( !is_array($sortItemArray) || count($sortItemArray) == 0 ) {
			// 並び替え項目が指定されていなければ
			array_push($sortItemArray,'order');
			array_push($sortItemArray,'upd');
			$sortOrderArray	= array();
			array_push($sortOrderArray,'ASC');
			array_push($sortOrderArray,'DESC');
		} else {
			// 並び替え項目が指定されている場合
			if( !in_array('order',$sortItemArray) ) { array_push($sortItemArray,'order'); array_push($sortOrderArray,'ASC'); }
			if( !in_array('upd',$sortItemArray) ) { array_push($sortItemArray,'upd'); array_push($sortOrderArray,'DESC'); }
			if( !in_array('reg',$sortItemArray) ) { array_push($sortItemArray,'reg'); array_push($sortOrderArray,'DESC'); }
		}

		if( preg_match('/^[lL][oO][gG][iI][nN]$/',$owner) > 0 ) {
			// オーナーログインしている場合、オーナーIDをログインIDに設定
			$memberId = $loginUserObject->getUniqueId();
		}
		foreach ( $sortItemArray as $key => $sortItemName ) {
			$orderCondition	= '';
			if ( strlen(trim($sortItemName)) > 0 && !in_array($sortItemName,$duplicateCheckArray) ) {
				// 並び替えの設定
				if ( !isset($sortOrderArray[$key]) || strlen(trim($sortOrderArray[$key])) == 0 ) {
					// 何も指定されていなければ、降順
					$sortOrderArray[$key]	= 'DESC';
				} else {
					if( preg_match('/^[aA][sS][cC]$/',$sortOrderArray[$key] ) > 0 ) {
						$sortOrderArray[$key]	= 'ASC';
					} else {
						$sortOrderArray[$key]	= 'DESC';
					}
				}

				if( 'did' == $sortItemName ) {
					$orderCondition	= TABLE_NAME_SHOPPING_PRODUCT.'.product_id '.$sortOrderArray[$key];
				} else if ( 'upd' == $sortItemName ) {
					$orderCondition	= TABLE_NAME_SHOPPING_PRODUCT.'.updated_date '.$sortOrderArray[$key];
				} else if ( 'dname' == $sortItemName ) {
					$orderCondition	= TABLE_NAME_SHOPPING_PRODUCT.'.product_kana '.$sortOrderArray[$key];
				} else if ( 'order' == $sortItemName ) {
					$orderCondition	= TABLE_NAME_SHOPPING_PRODUCT.'.order_number '.$sortOrderArray[$key];
				} else if ( 'order_count' == $sortItemName ) {
					$orderCondition	= 'order_count '.$sortOrderArray[$key];
				}
				if( strlen($orderCondition) > 0 ) {
					array_push($orderConditionArray,$orderCondition);
					array_push($duplicateCheckArray,$sortItemName);
				}
			}
		}
		$orderConditionString	= '';
		if ( count( $orderConditionArray ) > 0 ) {
			$orderConditionString	= ' ORDER BY ' . implode( ', ', $orderConditionArray );
		}
		
		$categoryIdArray = array();
		if ( is_array($shoppingCategoryId) ) {
			$categoryIdArray = $shoppingCategoryId;
		} else {
			if ( strlen(trim($shoppingCategoryId))>0 ) {
				array_push($categoryIdArray,$shoppingCategoryId);
			}
		}

		$condition_array	= array();
		$joinTables			= array();
		
		// 配送種別
		if(preg_match('/^[0-9]{1,6}$/',$deliveryType) > 0) {
			$str	= '( '.TABLE_NAME_SHOPPING_PRODUCT.'.delivery_type='.$deliveryType.' )';
			array_push( $condition_array, $str );
		}
		// オーナーID
		if ( strlen($memberId) > 0 ) {
			$str	= '( '.TABLE_NAME_SHOPPING_PRODUCT.'.owner_id='.$dbo->quote($memberId).' )';
			array_push( $condition_array, $str );
		}
		// ログイン状態ごとの条件
		spider_Controller::loadClassDefinition('util_CharUtility');
		if( preg_match('/^\\/'.util_CharUtility::escapeRegxStr(SYSTEM_DIR_NAME_ADMIN_PANEL).'\\//',SPIDER_URI_APP) > 0
		|| preg_match('/^\\/admin\\//',SPIDER_URI_APP) > 0 ){
			// 管理パネルの場合
			if( preg_match('/^[0-9]{1,3}$/',$statusFlag) > 0 ) {
				$str = TABLE_NAME_SHOPPING_PRODUCT.'.status_flag='.$statusFlag;
				array_push( $condition_array, $str );
			} else {
				$str = '( '.TABLE_NAME_SHOPPING_PRODUCT.'.status_flag>=0'
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT.'.status_flag<200 )';
				array_push( $condition_array, $str );
			}
		} else if( $this->isLogin( $request ) && is_a($loginUserObject,'member_DaoMember') ) {
			// 会員ログインの場合は自己所有商品で削除以外と公開商品
			$str = '( ( '.TABLE_NAME_SHOPPING_PRODUCT.'.status_flag>=100'
			.' AND '.TABLE_NAME_SHOPPING_PRODUCT.'.status_flag<200 ) OR ('
			.TABLE_NAME_SHOPPING_PRODUCT.'.status_flag<200'
			.' AND '.TABLE_NAME_SHOPPING_PRODUCT.'.owner_id='.$dbo->quote($loginUserObject->getUniqueId()).' ) )';
			array_push( $condition_array, $str );
			// 会員ログインの場合は会員種別で条件
			$definedClassKeyArray	= array_keys($GLOBALS['MEMBER_MEMBER_CLASS_HASH']);
			$str	= '(';
			$keyCol = 1;
			foreach ( $definedClassKeyArray as $key=>$classKey ) {
				if ( $classKey == $loginUserObject->member_class ) {
					$str	.= TABLE_NAME_SHOPPING_PRODUCT.'.member_viewable & '.$keyCol.' = '.$keyCol.' OR ';
					break;
				}
				$keyCol = $keyCol * 2;
			}
			$str	.= TABLE_NAME_SHOPPING_PRODUCT.'.owner_id='.$dbo->quote($loginUserObject->getUniqueId()).' )';
			array_push( $condition_array, $str );
		} else {
			// ログインしていない場合は公開商品のみ
			$str = '( '.TABLE_NAME_SHOPPING_PRODUCT.'.status_flag>=100'
			.' AND '.TABLE_NAME_SHOPPING_PRODUCT.'.status_flag<200 )';
			array_push( $condition_array, $str );
			// 非公開が閲覧可能な場合のみ閲覧可能
			$str	= TABLE_NAME_SHOPPING_PRODUCT.'.member_viewable & 1 = 1';
			array_push( $condition_array, $str );
			// TODO: ログインしていない場合はプロモーション紹介特別商品も表示
			
		}
		
		// カテゴリ条件
		$selectedRootCategoryObject	= null;
		if( count($categoryIdArray) > 0 ) {
			$categoryObjectHash	= $request->getAttribute('shopping.category.objectHash');
			foreach( $categoryIdArray as $categoryId ) {
				if( strlen(trim($categoryId)) > 0 ) {
					if( isset($categoryObjectHash[$categoryId]) && is_object($categoryObjectHash[$categoryId]) ){
						$categoryObject							= $categoryObjectHash[$categoryId];
						if( !is_object($selectedRootCategoryObject) ){
							$selectedRootCategoryObject	= $categoryObject;
							while(strlen($selectedRootCategoryObject->parent_id) > 0){
								$selectedRootCategoryObject	= $categoryObjectHash[$selectedRootCategoryObject->parent_id];
							}
						}
						$idArray	= $categoryObject->getAllChildCategoryIdArray();
						array_push($idArray,$categoryId);
						$quotedIdArray	= array();
						foreach( $idArray as $cId ){
							array_push($quotedIdArray,$dbo->quote($cId));
						}
						$str	= TABLE_NAME_SHOPPING_PRODUCT.'.product_id IN('
						.' SELECT '.TABLE_NAME_SHOPPING_CATEGORY_PRODUCT.'.product_id '
						.' FROM '.TABLE_NAME_SHOPPING_CATEGORY_PRODUCT
						.' WHERE '.TABLE_NAME_SHOPPING_CATEGORY_PRODUCT.'.category_id IN('.implode(',',$quotedIdArray).')'
						.')';
						array_push( $condition_array, $str );
					}
				}
			}
		}
		
		// 価格条件
		if( preg_match('/^[0-9]{1,9}$/',$lowerLimit ) > 0 && preg_match('/^[0-9]{1,9}$/',$upperLimit ) > 0 ) {
			if( $lowerLimit > $upperLimit ) {
				$tmp	= $lowerLimit;
				$lowerLimit	= $upperLimit;
				$upperLimit	= $tmp;
			}
			// 下限価格と上限価格
			$str	= TABLE_NAME_SHOPPING_PRODUCT.'.product_id IN('
				.'SELECT DISTINCT '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.product_id FROM '.TABLE_NAME_SHOPPING_PRODUCT_UNIT
				.' WHERE '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.price_sell BETWEEN '.$lowerLimit.' AND '.$upperLimit
				.')';
			array_push( $condition_array, $str );
		} else if( preg_match('/^[0-9]{1,9}$/',$lowerLimit ) > 0 ) {
			// 下限価格のみ
			$str	= TABLE_NAME_SHOPPING_PRODUCT.'.product_id IN('
				.'SELECT DISTINCT '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.product_id FROM '.TABLE_NAME_SHOPPING_PRODUCT_UNIT
				.' WHERE '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.price_sell >= '.$lowerLimit
				.')';
			array_push( $condition_array, $str );
		} else if( preg_match('/^[0-9]{1,9}$/',$upperLimit ) > 0 ) {
			// 上限価格のみ
			$str	= TABLE_NAME_SHOPPING_PRODUCT.'.product_id IN('
				.'SELECT DISTINCT '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.product_id FROM '.TABLE_NAME_SHOPPING_PRODUCT_UNIT
				.' WHERE '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.price_sell <= '.$upperLimit
				.')';
			array_push( $condition_array, $str );
		}
		// 検索データID
		if( strlen($searchDataId) > 0 ) {
			$searchDataObject	= spider_Controller::createObject('search_DaoSearchData');
			if( $dbo->loadById($searchDataObject,$searchDataId) ) {
				$str	= TABLE_NAME_SHOPPING_PRODUCT.'.search_data_id='.$dbo->quote($searchDataId);
				array_push( $condition_array, $str );
				$request->setAttribute('shopping.product.searchDataObject', $searchDataObject );
			} else {
				$request->addLocaledError('shopping.error.search.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		// 検索ワード
		if ( strlen(trim($queryWords)) > 0 ) {
			$queryWords	= str_replace('　', ' ', $queryWords);
			$queryWordArray	= explode(' ',$queryWords);
			foreach( $queryWordArray as $queryWord ) {
				if( strlen($queryWord) > 0 ) {
					// 検索文字列
					$str	= '( '.TABLE_NAME_SHOPPING_PRODUCT.'.product_id LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
						. ' OR '
						. TABLE_NAME_SHOPPING_PRODUCT.'.product_name LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
						. ' OR '
						. TABLE_NAME_SHOPPING_PRODUCT.'.product_kana LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
						. ' OR '
						. TABLE_NAME_SHOPPING_PRODUCT.'.catch_copy LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
						. ' OR '
						. TABLE_NAME_SHOPPING_PRODUCT.'.keywords LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
						. ' OR '
						. TABLE_NAME_SHOPPING_PRODUCT.'.description LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
						. ' OR '
						. TABLE_NAME_SHOPPING_PRODUCT.'.detail_comment LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
					;
					$str	.= ' )'	;
					array_push( $condition_array, $str );
				}
			}
		}
		
		$condition_string	= '';
		if ( count( $condition_array ) > 0 ) {
			$condition_string	= ' WHERE ' . implode( ' AND ', $condition_array );
		}
		// Last Query
		$lastQueryHash	= array();
		
		// トータル件数を取得
		$sql	= 'SELECT COUNT(DISTINCT('.TABLE_NAME_SHOPPING_PRODUCT. '.product_id)) '
			. ' FROM ' . TABLE_NAME_SHOPPING_PRODUCT
		;
		if ( in_array( TABLE_NAME_SHOPPING_CATEGORY_PRODUCT, $joinTables ) ) {
			$sql	.= ' LEFT OUTER JOIN ' . TABLE_NAME_SHOPPING_CATEGORY_PRODUCT
				. ' ON ' . TABLE_NAME_SHOPPING_CATEGORY_PRODUCT . '.product_id='.TABLE_NAME_SHOPPING_PRODUCT.'.product_id '
			;
		}
		$sql	.= $condition_string;
		$lastQueryHash['countQuery']	= $sql;
		$totalCount	= 0;
		$totalCount	= $dbo->queryOne( $sql );
		if ( $totalCount === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			if ( is_numeric( $totalCount ) || $totalCount < 0 ) {
				$totalPage		= ceil( $totalCount / $pageRows );
			} else {
				$totalCount	= 0;
				$totalPage		= 1;
			}
		}
		// オフセットの整理
		if ( !is_numeric( $pageNumber ) || $pageNumber <= 0 ) {
			$pageNumber	= 1;
		} else if ( $pageNumber > $totalPage	 ) {
			$pageNumber	= $totalPage;
		}
		
		// IDをページ分取得
		$sql	= 'SELECT DISTINCT '.TABLE_NAME_SHOPPING_PRODUCT.'.* ';
		if ( in_array('order_count',$sortItemArray) ) {
			$sql	.= ', COUNT('.TABLE_NAME_SHOPPING_ORDER_ITEM.'.item_number) AS order_count ';
		}
		$sql	.= ' FROM ' . TABLE_NAME_SHOPPING_PRODUCT;
		if ( in_array( TABLE_NAME_SHOPPING_CATEGORY_PRODUCT, $joinTables ) ) {
			$sql	.= ' LEFT OUTER JOIN ' . TABLE_NAME_SHOPPING_CATEGORY_PRODUCT
				. ' ON ' . TABLE_NAME_SHOPPING_CATEGORY_PRODUCT . '.product_id='.TABLE_NAME_SHOPPING_PRODUCT.'.product_id '
			;
		}
		if ( in_array('order_count',$sortItemArray) ) {
			$sql	.= ' LEFT OUTER JOIN ' . TABLE_NAME_SHOPPING_PRODUCT_UNIT
				. ' ON ' . TABLE_NAME_SHOPPING_PRODUCT_UNIT . '.product_id='.TABLE_NAME_SHOPPING_PRODUCT.'.product_id ' 
				. ' LEFT OUTER JOIN ' . TABLE_NAME_SHOPPING_ORDER_ITEM
				. ' ON ' . TABLE_NAME_SHOPPING_ORDER_ITEM . '.unit_id='.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.unit_id '
			;
		}
		$sql	.= $condition_string
			. ' GROUP BY '
			.TABLE_NAME_SHOPPING_PRODUCT.'.product_id '
			. $orderConditionString
		;
		$dbo->setLimit( $pageRows, ( $pageNumber - 1 ) * $pageRows );
		$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
		$productObjectArray	= $dbo->queryAll( $sql, $shoppingProductObject, false, false );
		$productObjectHash	= array();
		$lastQueryHash['loadQuery']	= $sql;
		$request->setSession(SHOPPING_SESSION_NAME_PRODUCT_SEARCH_LAST_QUERY, $lastQueryHash, SPIDER_SESSION_SCOPE_GLOBAL);
		if ( $productObjectArray === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			foreach( $productObjectArray as $shoppingProductObject ) {
				$this->setLockStatus( $request, $shoppingProductObject );
				$shoppingProductObject->optimizeLoadedVars();
				if( 'default' != $accessAgentClass
				&& mb_strlen($shoppingProductObject->description) > 60 ) {
					// 携帯の場合は文字数を削っておく
					$shoppingProductObject->description	= mb_substr( $accessAgentClass->description, 0, 56 ).'..';
				}
				$productObjectHash[$shoppingProductObject->product_id]	= $shoppingProductObject;
			}
			$productIdArray		= array_unique(array_keys($productObjectHash));
			$ownerIdArray		= array();
			$productOwnerHash	= array();
			foreach( $productObjectArray as $key => $object ) {
				$productId			= $object->product_id;
				$ownerId = trim($object->owner_id);
				if ( strlen($ownerId)>0 ) {
					if ( !in_array($ownerId,$ownerIdArray) ) {
						array_push($ownerIdArray,$ownerId);
					}
					$productOwnerHash[$productId]	= $ownerId;
				}
			}
			// 所属カテゴリIDの読み込み
			$sql	= 'SELECT * FROM '.TABLE_NAME_SHOPPING_CATEGORY_PRODUCT
				.' WHERE product_id IN (\''.implode('\',\'',$productIdArray).'\')'
				.' ORDER BY order_number ASC'
			;
			$rows	= $dbo->queryAll( $sql, 'hash', false );
			if( false === $rows ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
			} else {
				foreach( $rows as $row ) {
					$productId	= trim($row['product_id']);
					$categoryId	= trim($row['category_id']);
					if( isset($productObjectHash[$productId]) ) {
						array_push($productObjectHash[$productId]->categoryIdArray,$categoryId);
					}
				}
			}
			// 画像ファイル情報の読み込み
			$sql	= 'SELECT * FROM '.TABLE_NAME_SHOPPING_PRODUCT_FILE
				.' WHERE product_id IN (\''.implode('\',\'',$productIdArray).'\')'
				.' ORDER BY order_number ASC'
			;
			$rows	= $dbo->queryAll( $sql, 'hash', false );
			if( false === $rows ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
			} else {
				foreach( $rows as $row ) {
					$productId		= trim($row['product_id']);
					$fileId			= trim($row['file_id']);
					$orderNumber	= trim($row['order_number']);
					if( isset($productObjectHash[$productId]) ) {
						$productObjectHash[$productId]->fileIdArray[$orderNumber]	= $fileId;
					}
				}
			}
			// 所属販売単位の一括読み込み
			$this->loadRelatedUnitObjects( $request, $productObjectHash );
			
			// オーナー情報の読み込み
			if ( count($ownerIdArray)>0 ) {
				$sql	= 'SELECT * FROM '.TABLE_NAME_MEMBER
					.' WHERE member_id IN (\''.implode('\',\'',$ownerIdArray).'\')'
				;
				$memberObject	= spider_Controller::createObject('member_DaoMember');
				$result			= $dbo->queryAll( $sql, $memberObject, false, false );
				if ( $result === false ) {
					$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
				} else {
					$memberObjectHash = array();
					foreach( $result as $key => $object ) {
						$memberObjectHash[$object->member_id] = $object;
					}
					if ( count($memberObjectHash) > 0 ) {
						foreach ( $productOwnerHash as $productId => $ownerId ) {
							if (array_key_exists($ownerId, $memberObjectHash)) {
								$productObjectHash[$productId]->ownerObject = $memberObjectHash[$ownerId];
							}
						}
					}
				}
			}
			$request->setAttribute( 'shopping.product.product_array',	$productObjectHash );
			$request->setAttribute( 'shopping.product.total_count',		$totalCount );
			$request->setAttribute( 'shopping.product.total_page',		$totalPage );
			$request->setAttribute( 'shopping.product.page_number',		$pageNumber );
			$request->setAttribute( 'shopping.product.page_rows',		$pageRows );
			$request->setAttribute( 'shopping.product.query',			$queryWords );
			$request->setAttribute( 'shopping.product.lowerLimit',		$lowerLimit );
			$request->setAttribute( 'shopping.product.upperLimit',		$upperLimit );
			$request->setAttribute( 'shopping.product.sort_item_array',	$sortItemArray );
			$request->setAttribute( 'shopping.product.sort_order_array',$sortOrderArray );
			$request->setAttribute( 'shopping.product.category_id_array',	$categoryIdArray );
			$request->setAttribute( 'shopping.product.status_flag',		$statusFlag );
			$request->setAttribute( 'shopping.product.searchDataId',	$searchDataId );
			$request->setAttribute( 'shopping.product.deliveryType',	$deliveryType );
			$request->setAttribute( 'shopping.product.selectedRootCategoryObject', $selectedRootCategoryObject);
			$has_next_page	= false;
			if( $pageNumber < $totalPage ) {
				$has_next_page	= true;
			}
			$request->setAttribute( 'shopping.product.has_next_page', $has_next_page );
			$has_prev_page	= false;
			if( $pageNumber > 1 ) {
				$has_prev_page	= true;
			}
			$request->setAttribute( 'shopping.product.has_prev_page', $has_prev_page );
			
			// ページナビゲーション配列作成
			$page_navi_array = array();
			if ( $pageNumber < 10 ) {
				if ( $totalPage < 10 ) {
					for($i=1;$i<=$totalPage;$i++) {
						array_push($page_navi_array,$i);
					}
				} else {
					for($i=1;$i<=10;$i++) {
						array_push($page_navi_array,$i);
					}
				}
			} else {
				$startPage	= floor(($pageNumber-1)/10) * 10 + 1;
				for($i=$startPage;( $i<$startPage+10 && $i<=$totalPage );$i++) {
					array_push($page_navi_array,$i);
				}
			}
			$request->setAttribute('shopping.product.page_navi_array', $page_navi_array );
		}
	}
	/**
	 * 関連販売単位を読み込んで設定
	 * @param $request spider_HttpRequestオブジェクト参照
	 */
	function loadRelatedUnitObjects( & $request, & $productObjectHash ) {
		// 販売単位の読み込み
		$dbo					= $request->getAttribute( 'dbo' );
		$statusFlag				= $request->getParam('shpstf','get');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$productIdArray			= array_unique(array_keys($productObjectHash));
		$unitIdArray			= array();
		$daoShoppingProductUnit	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
		// 条件
		$whereConditionArray		= array();
		// 商品指定
		$str	= TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.product_id IN (\''.implode('\',\'',$productIdArray).'\')';
		array_push( $whereConditionArray, $str );
		// ログイン状態ごとの制御
		spider_Controller::loadClassDefinition('util_CharUtility');
		if( preg_match('/^\\/'.util_CharUtility::escapeRegxStr(SYSTEM_DIR_NAME_ADMIN_PANEL).'\\//',SPIDER_URI_APP) > 0
		|| preg_match('/^\\/admin\\//',SPIDER_URI_APP) > 0 ){
			// 管理パネルの場合
			if( preg_match('/^[0-9]{1,3}$/',$statusFlag) > 0 ) {
				$str = TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag='.$statusFlag;
				array_push( $whereConditionArray, $str );
			} else {
				$str = '( '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag>=0'
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag<200 )';
				array_push( $whereConditionArray, $str );
			}
		} else if( $this->isLogin( $request ) && is_a($loginUserObject,'member_DaoMember') ) {
			// 会員ログインの場合は自己所有商品で削除以外と公開商品
			$str = '( ( '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag>=100'
			.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag<200 ) OR ('
			.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag<200'
			.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.owner_id='.$dbo->quote($loginUserObject->getUniqueId()).' ) )';
			array_push( $whereConditionArray, $str );
			// 公開期間の制限
			$str	= '( '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.open_date IS NULL OR '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.open_date<='.$dbo->quote(date('Y-m-d H:i:s')).' )';
			array_push( $whereConditionArray, $str );
			$str	= '( '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.close_date IS NULL OR '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.close_date>='.$dbo->quote(date('Y-m-d H:i:s')).' )';
			array_push( $whereConditionArray, $str );
		} else {
			// ログインしていない場合は公開商品のみ
			$str = '( '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag>=100'
			.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag<200 )';
			array_push( $whereConditionArray, $str );
			// 公開期間の制限
			$str	= '( '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.open_date IS NULL OR '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.open_date<='.$dbo->quote(date('Y-m-d H:i:s')).' )';
			array_push( $whereConditionArray, $str );
			$str	= '( '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.close_date IS NULL OR '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.close_date>='.$dbo->quote(date('Y-m-d H:i:s')).' )';
			array_push( $whereConditionArray, $str );
		}
		$whereConditionString	= '';
		if( count($whereConditionArray) > 0 ) {
			$whereConditionString	= ' WHERE '.implode(' AND ',$whereConditionArray);
		}
		$sql	= 'SELECT * FROM '.TABLE_NAME_SHOPPING_PRODUCT_UNIT
		.$whereConditionString
		.' ORDER BY order_number ASC';
		$rows	= $dbo->queryAll( $sql, $daoShoppingProductUnit, false, false );
		if ( $rows === false ) {
			return false;
		} else {
			foreach( $rows as $row ) {
				$productId		= trim($row->product_id);
				$row->optimizeLoadedVars($dbo);
				if( isset($productObjectHash[$productId]) ) {
					$row->shoppingProductObject	= & $productObjectHash[$productId];
					// 公開設定
					$row->memberViewableArray	= array();
					$row->memberPurchasableArray	= array();
					$memberViewableStr	= sprintf('%016b',$row->member_viewable);
					$memberPurchasableStr	= sprintf('%016b',$row->member_purchasable);
					$keyCol	= 0;
					foreach ( $GLOBALS['MEMBER_MEMBER_CLASS_HASH'] as $key=>$value ) {
						if ( substr($memberViewableStr,15-$keyCol,1) == '1' ) {
							array_push($row->memberViewableArray,$key);
						}
						if ( substr($memberPurchasableStr,15-$keyCol,1) == '1' ) {
							array_push($row->memberPurchasableArray,$key);
						}
						$keyCol++;
					}
					array_push($productObjectHash[$productId]->unitObjectArray,$row);
					// unit_id配列の作成
					if ( !in_array($row->unit_id,$unitIdArray) ) {
						array_push($unitIdArray,$dbo->quote($row->unit_id));
					}
				}
			}
		}
		// 販売単位に関連する商品フラグIDのハッシュを作成
		$unitFlagIdHash = array();
		if( count($unitIdArray) > 0 ) {
			$sql	= 'SELECT '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.unit_id, '
				. TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.flag_id '
				. ' FROM '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION
				.' WHERE unit_id IN ('. implode( ',', $unitIdArray ) . ')'
				.' AND (('.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.open_date IS NULL'
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.close_date IS NULL)' 
				.' OR ('.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.open_date <= '.$dbo->quote(date('Y-m-d'))
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.close_date >= '.$dbo->quote(date('Y-m-d')).')'
				.' OR ('.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.open_date <= '.$dbo->quote(date('Y-m-d'))
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.close_date IS NULL)'
				.' OR ('.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.open_date IS NULL'
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.close_date >= '.$dbo->quote(date('Y-m-d')).'))'
			;
			$rows	= $dbo->queryAll( $sql, 'hash', false );
			if ( $rows === false ) {
				return false;
			} else {
				foreach( $rows as $row ) {
					$unitId		= trim($row['unit_id']);
					if ( !is_array($unitFlagIdHash[$unitId]) ) {
						$unitFlagIdHash[$unitId] = array();
					}
					array_push($unitFlagIdHash[$unitId],trim($row['flag_id']));
				}
			}
		}
		$request->setAttribute( 'shopping.product.unit_flag_id_hash',	$unitFlagIdHash );
	}
}
?>