<?php
/*
 * shopping/order/step/ConfirmAll.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-10-04
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'DaoShoppingOrder.class.php' );
class shopping_order_step_ConfirmAll extends system_login_ModuleBase {
	/**
	 * コンストラクタ
	 */
	function shopping_order_step_ConfirmAll() {
		array_push($this->require_module_array,'shopping.LoadConfig');
		array_push($this->require_module_array,'shopping.order.option.LoadList');
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
		if( isset($_GET['shpoi']) && strlen(trim($_GET['shpoi'])) > 0 ) {
			array_push($this->require_module_array,'shopping.order.CartAdmin');
		} else {
			array_push($this->require_module_array,'shopping.order.Cart');
		}
		array_push($this->require_module_array,'shopping.order.step.ConfirmStock');
	}
	/**
	 * executeメソッド
	 */
	function execute( & $request ) {
		// 属性の取得
		$dbo					= $request->getAttribute( 'dbo' );
		$loginUserObject		= $this->getLoginUserObject( $request );
		$shoppingOrderObject	= $request->getAttribute('shopping.order.orderObject');
		// 全てのステップを通過したか確認
		if( !$request->existsSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_PURCHASER)
		|| 'OK' != $request->getSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_PURCHASER) ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			return;
		} else if( !$request->existsSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_ADDRESS)
		|| 'OK' != $request->getSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_ADDRESS) ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			return;
		} else if( !$request->existsSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_ADDRESS_OPTION)
		|| 'OK' != $request->getSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_ADDRESS_OPTION) ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			return;
		} else if( !$request->existsSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_SETTLEMENT)
		|| 'OK' != $request->getSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_SETTLEMENT) ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			return;
		} else if( !$request->existsSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_OPTIONS)
		|| 'OK' != $request->getSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_OPTIONS) ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			return;
		} else if( !$request->existsSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_OPTIONS)
		|| 'OK' != $request->getSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_OPTIONS) ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
			return;
		}
		
		// 管理者か確認
		$requrireMailAddress = true;
		if( $this->isLogin( $request )
		&& SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
			$requrireMailAddress = false;
		}
		
		// 購入者情報の妥当性検査
		$shoppingOrderObject->validatePurchaser( $request, $requrireMailAddress );
		// 宛先住所の妥当性検査
		$shoppingOrderObject->validateAddress( $request );
		// オプションの妥当性検査
		$shoppingOrderObject->validateOptions( $request );
		// 妥当性検査:利用ポイントの確認
		if( strlen($shoppingOrderObject->point_use) == 0 || $shoppingOrderObject->point_use == 0 ) {
			$shoppingOrderObject->point_use	= 0;
		} else if( is_null($shoppingOrderObject->memberObject)
			|| strlen(trim($shoppingOrderObject->memberObject->member_id)) == 0
			|| strlen(trim($shoppingOrderObject->memberObject->member_number)) == 0
			|| $shoppingOrderObject->memberObject->member_class < 1 ) {
			$request->addLocaledError('shopping.error.point.requiremember',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( preg_match('/^[0-9]{1,6}$/',$shoppingOrderObject->point_use) == 0 ) {
			$request->addLocaledError('shopping.error.point.invalidinput',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			$currentPoint = $shoppingOrderObject->memberObject->pointCurrent( $request );
			if( false === $currentPoint ) {
				$request->addLocaledError('shopping.error.point.currentpoint',SPIDER_LOG_LEVEL_ERROR,array());
			} else if( $currentPoint < $shoppingOrderObject->point_use ) {
				$request->addLocaledError('shopping.error.point.shortage',SPIDER_LOG_LEVEL_ERROR,array($currentPoint));
			}
		}
		
		$shoppingOrderObject->calculate( $request, true );
		
		$request->setAttribute('shopping.order.orderObject',	$shoppingOrderObject );
	}
}
?>