<?php
/*
 * shopping/order/settlement/MethodBankAfter.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'MethodBase.class.php');
/**
 * shopping_order_settlement_MethodBankAfter
 * 決済プラグイン：料金後払い向けクラス
 * 
 * 銀行振込後払い決済向けの決済プラグイン実装クラスです。
 * 注文が完了した場合にデフォルトで注文状態を「新規」、決済状態を「未決済」に設定します。
 * 外部サービスとの連携は存在しません。
 */
class shopping_order_settlement_MethodBankAfter extends shopping_order_settlement_MethodBase {
	/**
	 * コンストラクタ
	 */
	function shopping_order_settlement_MethodBankAfter() {
		$this->viewName		= '銀行振込(後払)';
		$this->feeType		= 0;
		$this->feeValue		= 0;
		$this->statusSettle	= 0;
		$this->memberClassArray	= array(53);
		$this->mailComment	= "お支払い方法に銀行振込(後払)をご選択いただいています。商品到着後に下記記載の銀行口座にお振込お願いいたします。\n\n"
			."○○銀行 ○○支店 普通口座 口座番号 0000000\n"
			."○○○○株式会社";
		$this->mailOrder	= "";
		$this->explanation	= <<< __METHOD_EXPLANATION__
<div>
後払い銀行振込でのお支払いです。<br />
月締め請求翌月末のお支払いでお願いいたします。
</div>
__METHOD_EXPLANATION__;

	}
	/**
	 * 決済方法名を取得
	 */
	function getMethodName() {
		return '銀行振込(後払)決済プラグイン';
	}
	/**
	 * 決済方法固有の番号を取得します。
	 */
	function getMethodNumber() {
		return '11';
	}
}
?>