<?php
/*
 * shopping/order/settlement/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
/**
 * shopping_order_settlement_LoadList
 * spiderモジュール：shoppingパッケージ インストール済み決済方法プラグイン読み込みモジュール
 * 
 */
class shopping_order_settlement_LoadList extends system_login_ModuleBase {
	
	function shopping_order_settlement_LoadList() {
	}
	function execute( & $request ) {
		// 利用可能な決済方法の読み込み
		$loginUserObject		= $this->getLoginUserObject( $request );
		$settleMethodObjectArray	= array();
		$settleDir	= dirname(dirname(__FILE__)).DIRECTORY_SEPARATOR.'settlement';
		if( is_dir($settleDir) ) {
			if( $dh = @opendir($settleDir) ) {
				while (($fileName = readdir($dh)) !== false) {
					if( preg_match('/^Method/',$fileName) > 0 && 'MethodBase.class.php' != $fileName ) {
						$className		= 'shopping_order_settlement_'.preg_replace('/\\.class\\.php$/','',$fileName);
						$settleObject	= spider_Controller::createObject($className);
						// 設定読み込み
						$settleObject->load( $request );
						if( !is_array($settleObject->memberClassArray) ) {
							$settleObject->memberClassArray	= array();
						}
						if( $settleObject->enable ) {
							if( $this->isLogin( $request )
							&& SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
								$settleMethodObjectArray[$settleObject->getMethodNumber()]	= $settleObject;
							} else if( $this->isLogin( $request )
							&& is_a($loginUserObject,'member_DaoMember')
							&& array_key_exists($loginUserObject->member_class,$settleObject->memberClassArray) ) {
								$settleMethodObjectArray[$settleObject->getMethodNumber()]	= $settleObject;
							} else if( array_key_exists('0',$settleObject->memberClassArray) ) {
								$settleMethodObjectArray[$settleObject->getMethodNumber()]	= $settleObject;
							}
						}
					}
				}
				@closedir($settleDir);
			}
		}
		ksort($settleMethodObjectArray);
		$request->setAttribute('shopping.order.settlement.methodObjectArray',	$settleMethodObjectArray );
	}
}
?>