<?php
/*
 * shopping/order/CartAdmin.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-10-07
 */
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'Cart.class.php' );
class shopping_order_CartAdmin extends shopping_order_Cart {
	function shopping_order_CartAdmin() {
		array_push($this->require_module_array,'shopping.LoadConfig');
		array_push($this->require_module_array,'database2.Connect');
		array_push($this->require_module_array,'shopping.order.option.LoadList');
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$orderId				= $request->getParam('shpoi','get');
		$redirect		= $request->getParam('redirect','post');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$sessionObjectName		= SHOPPING_SESSION_NAME_ORDER_OBJECT.'.'.$orderId;
		$shoppingOrderObject	= $request->getSession($sessionObjectName);
		// オブジェクトがセッションにないなら読み込み
		if( !is_object($shoppingOrderObject) ) {
			if( preg_match('/^[0-9a-zA-Z\\-\\_\\.]+$/',$orderId) == 0 ) {
				$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				return;
			} else {
				// IDがあるなら読み込み
				$shoppingOrderObject	= spider_Controller::createObject('shopping_DaoShoppingOrder');
				if( $dbo->loadById( $shoppingOrderObject, $orderId, true ) ) {
					$shoppingOrderObject->optimize();
				} else {
					$request->addLocaledError('shopping.error.order.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
					return;
				}
			}
		}
		// 権限の確認
		$shoppingOrderObject->isOwnerUser	= false;
		$orderKey	= $request->getParam('shpokey','get');
		if( !$this->isLogin( $request ) && $orderKey != $shoppingOrderObject->order_key ) {
			$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
			return;
		} else if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
		} else if($shoppingOrderObject->owner_id==$loginUserObject->getUniqueId()) {
		} else if($orderKey == $shoppingOrderObject->order_key) {
		} else {
			$orderUnitIdArray	= array();
			foreach( $shoppingOrderObject->shoppingOrderAddressObjectArray as $shoppingOrderAddressObject ){
				foreach( $shoppingOrderAddressObject->shoppingOrderItemObjectArray as $orderItemObject ){
					array_push($orderUnitIdArray,$dbo->quote($orderItemObject->unit_id));
				}
			}
			$sql	= 'SELECT owner_id FROM '.TABLE_NAME_SHOPPING_PRODUCT_UNIT
			.' WHERE unit_id IN('.implode(',',$orderUnitIdArray).')';
			$rowArray	= $dbo->queryAll($sql,'hash');
			if( false===$rowArray) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
				return;
			} else {
				foreach( $rowArray as $idRow ) {
					if( $loginUserObject->getUniqueId() == $idRow['owner_id'] ) {
						$shoppingOrderObject->isOwnerUser	= true;
						break;
					}
				}
				if( !$shoppingOrderObject->isOwnerUser ) {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
					return;
				}
			}
		}
		// ログイン状態ごとの切り分け
		$this->_processLoginStatus( $request, $shoppingOrderObject );
		// コマンド分岐処理
		$execCommand	= $this->_processCommand( $request, $shoppingOrderObject );

		if( $execCommand ) {
			// コマンドを実行したらカラムごとのエラーメッセージは削除する
			$shoppingOrderObject->columnErrorHash	= array();
		}
		if(preg_match('/^([fF](|[aA][lL][sS][eE])|[nN][oO](|[nN][eE]))$/',$redirect)>0){
		}else{
			if( !$request->isError() && $execCommand ) {
				$request->redirectTo(SPIDER_URI_REQUEST);
			}
		}
		// カート内を現在の情報で再計算
		$shoppingOrderObject->calculate( $request, true );
		// 表示用に属性登録
		$request->setAttribute('shopping.order.modify.orderId',$orderId );
		$request->setAttribute('shopping.order.orderObject',$shoppingOrderObject );
	}
	/**
	 * ログイン状態によってプロモーションと会員オブジェクトを調整
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @param $shoppingOrderObject shopping_DaoShoppingOrderオブジェクト参照
	 */
	function _processLoginStatus( & $request, & $shoppingOrderObject ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$loginUserObject		= $this->getLoginUserObject( $request );
		if( $this->isLogin( $request )
			&& SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
			// 管理者ログインの場合
			if( isset( $_POST['promotion_code'] ) ) {
				// プロモーションコードを入力可能
				$shoppingOrderObject->promotion_code	= trim(stripslashes($_POST['promotion_code']));
				// プロモーションオブジェクトの再読み込み
				$shoppingOrderObject->getRelatedPromotionObject( $request, true );
			}
		} else if( $this->isLogin( $request ) ) {
			// 会員ログインの場合
		} else {
		}
	}
	/**
	 * モジュールの後処理を行います。
	 * @param $request spider_HttpRequestオブジェクト参照
	 */
	function post_process( & $request ) {
		$orderId				= $request->getParam('shpoi','get');
		$sessionObjectName		= SHOPPING_SESSION_NAME_ORDER_OBJECT.'.'.$orderId;
		$shoppingOrderObject	= $request->getAttribute('shopping.order.orderObject');
		$removeCart				= $request->getAttribute('shopping.order.removeCart');
		if( true !== $removeCart ){
			$removeCart	= false;
		}
		if( is_object($shoppingOrderObject) && !$removeCart ) {
			// カートオブジェクトから商品販売単位オブジェクトを削除
			$shoppingOrderObject->unsetAllUnitObject();
			// オプションの下位互換を削除
			unset($shoppingOrderObject->option_names);
			unset($shoppingOrderObject->option_values);
			unset($shoppingOrderObject->dbo);
			unset($shoppingOrderObject->request);
			unset($shoppingOrderObject->shoppingPromotionObject);
			// セッションに登録
			$request->setSession($sessionObjectName,$shoppingOrderObject,SPIDER_SESSION_SCOPE_GLOBAL);
		} else {
			// セッションを削除する
			$sessionObjectName		= SHOPPING_SESSION_NAME_ORDER_OBJECT.'.'.$orderId;
			$request->removeSession($sessionObjectName,SPIDER_SESSION_SCOPE_GLOBAL);
			$request->removeSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_PURCHASER,SPIDER_SESSION_SCOPE_GLOBAL);
			$request->removeSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_ADDRESS,SPIDER_SESSION_SCOPE_GLOBAL);
			$request->removeSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_ADDRESS_OPTION,SPIDER_SESSION_SCOPE_GLOBAL);
			$request->removeSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_SETTLEMENT,SPIDER_SESSION_SCOPE_GLOBAL);
			$request->removeSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_OPTIONS,SPIDER_SESSION_SCOPE_GLOBAL);
			$request->removeSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_ITEMOPTIONS,SPIDER_SESSION_SCOPE_GLOBAL);
			$request->removeSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_COMMENT,SPIDER_SESSION_SCOPE_GLOBAL);
			$request->removeSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_DELIVERY_OLD,SPIDER_SESSION_SCOPE_GLOBAL);
			$request->removeSession('shopping.order.selectedDateHash',SPIDER_SESSION_SCOPE_GLOBAL);
		}
	}
}
?>