<?php
/*
 * shopping/category/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'login'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'content'
.DIRECTORY_SEPARATOR.'Uploader.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoShoppingCategory.class.php');
class shopping_category_Confirm extends system_login_ModuleBase {
	
	function shopping_category_Confirm(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo					= $request->getAttribute( 'dbo' );
		$shoppingCategoryNumber	= stripslashes( $_GET['shpcn'] );
		$sessionObjectName		= 'shopping.category.modify.object.'.$shoppingCategoryNumber;
		$sessionConfirmName		= 'shopping.category.modify.confirm.'.$shoppingCategoryNumber;
		$shoppingCategoryObject	= $request->getSession($sessionObjectName);
		$request->removeSession($sessionConfirmName);
		
		if( 'shopping_daoshoppingcategory' == strtolower(get_class($shoppingCategoryObject)) ){
			// セッションに登録済みの場合アップロードファイルがあれば削除
			if( is_object($shoppingCategoryObject->contentUploader)
				&& 'content_uploader' == strtolower(get_class($shoppingCategoryObject->contentUploader)) ) {
				$shoppingCategoryObject->contentUploader->initialize( $request );
			}
		}
		// データベースの最新状態から差分をとる為読み込みしなおす
		$shoppingCategoryObject	= spider_Controller::createObject('shopping_DaoShoppingCategory');
		if( strlen(trim($shoppingCategoryNumber)) > 0 ) {
			// 管理者IDが指定されていないなら編集の為読み込み
			if( $dbo->loadByNumber( $shoppingCategoryObject, $shoppingCategoryNumber ) ) {
			} else {
				$request->addLocaledError('shopping.error.category.notfound',SPIDER_LOG_LEVEL_ERROR,array());
			}
		}
		// 入力値のセットとチェック
		$shoppingCategoryObject->category_id	= stripslashes($_POST['category_id']);
		$shoppingCategoryObject->category_name	= stripslashes($_POST['category_name']);
		$shoppingCategoryObject->category_kana	= stripslashes($_POST['category_kana']);
		$shoppingCategoryObject->parent_id		= stripslashes($_POST['parent_id']);
		$shoppingCategoryObject->order_number	= stripslashes($_POST['order_number']);
		$shoppingCategoryObject->description	= stripslashes($_POST['description']);
		// 妥当性検査実行
		$shoppingCategoryObject->validate( $request );
		if( !$request->isError() ) {
			// エラーがなければファイルアップロード処理
			$shoppingCategoryObject->contentUploader	= new content_Uploader('upfile');
			// 一時アップロード実行(サムネイルは作成しない)
			$shoppingCategoryObject->contentUploader->uploadConfirm( $request, '/upload/shopping/category/',
				array( array('width'=>24,'height'=>24) ) );
		}
		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName,$shoppingCategoryObject);
		$request->setAttribute('shopping.category.category_object',		$shoppingCategoryObject);
		$request->setAttribute('shopping.category.require_columns_hash',	$GLOBALS['SHOPPING_CATEGORY_REQUIRE_COLUMNS_HASH']);
		$request->setAttribute('shopping.category.regist_permit_hash',	$GLOBALS['REGIST_PERMIT_HASH']);
	}
}
?>