<?php
/*
 * shopping/order/modify/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'login'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoShoppingProduct.class.php' );
class shopping_bookmark_Execute extends system_login_ModuleBase {
	
	function shopping_bookmark_Execute() {
	}
	function execute( & $request ) {
		
		$dbo					= $request->getAttribute( 'dbo' );
		$productNumber			= stripslashes( $_GET['shpdn'] );
		$productId				= stripslashes($_GET['shpdi']);
		$loginUserObject		= $this->getLoginUserObject( $request );
		
		$productObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
		if( preg_match('/^[0-9]+$/',$productNumber) > 0 ) {
			// 商品番号が指定されているなら読み込み
			if( $dbo->loadByNumber( $productObject, $productNumber, true ) ){
			} else {
				$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_ERROR,array());
			}
		} else if( strlen(trim($productId)) > 0 ) {
			// 商品IDが指定されているなら読み込み
			if( $dbo->loadById( $productObject, $productId, true ) ){
			} else {
				$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_ERROR,array());
			}
		} else {
			// IDが指定されていないならエラー
			$request->addLocaledError('shopping.error.bookmark.productrequired',SPIDER_LOG_LEVEL_ERROR,array());
		}
		
		if( !$request->isError() ) {
			// 関連テーブルに追加されていないか確認
			$sql = 'SELECT COUNT(relation_number) FROM '.TABLE_NAME_ADMIN_GROUP
			;
			
			$sql	= 'SELECT COUNT(*) FROM '.TABLE_NAME_SHOPPING_PRODUCT_BOOKMARK
			.' WHERE product_id='.$dbo->quote($productObject->product_id)
			.' AND  member_id='.$dbo->quote($loginUserObject->member_id);
			$resultCount	= $dbo->queryOne($sql);
			if( false === $resultCount ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_ERROR,array($sql));
			} else if( $resultCount > 0 ) {
			} else {
				$sql = 'INSERT INTO '.TABLE_NAME_SHOPPING_PRODUCT_BOOKMARK
					.' ( product_id, member_id, registered_date )'
					.' VALUES ('
					.$dbo->quote($productObject->product_id)
					.','.$dbo->quote($loginUserObject->member_id)
					.','.$dbo->quote(date('Y-m-d H:i:s'))
					.')'
				;
				$result = $dbo->query( $sql );
				if( false === $result ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_ERROR,array($sql));
				}
			}
		}
		if( $request->isError() ) {
			if( strlen($_SERVER['HTTP_REFERER']) > 0 ) {
				$request->redirectTo($_SERVER['HTTP_REFERER']);
			} else {
				$isReferer	= false;
				if( strpos(trim($_POST['referer']),SPIDER_URL_BASE) === 0 ) {
					$isReferer = true;
				} else if( strpos(trim($_POST['referer']),SPIDER_ACCESS_URL_HTTP) === 0 ) {
					$isReferer = true;
				} else if( strpos(trim($_POST['referer']),SPIDER_ACCESS_URL_SSL) === 0 ) {
					$isReferer = true;
				} else {
					foreach( $GLOBALS['REV_PROXY_HASH'] as $key => $hash ) {
						$urlstr	= $hash['protocol'].'://'.$key.$hash['uri'];
						if( strpos(trim($_POST['referer']),$urlstr) === 0 ) {
							$isReferer	= true;
							break;
						}
					}
				}
				if( $isReferer ) {
					$request->redirectTo(trim($_POST['referer']));
				}
			}
		}
	}
}
?>