<?php
/*
 * shopping/PackageConfig.inc.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-09-18
 *
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'package_define.inc.php');
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'login'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'PackageConfigBase.class.php' );
require_once(dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'AbstractData.class.php' );
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'member'
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'member'
.DIRECTORY_SEPARATOR.'DaoMember.class.php' );
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'file'
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'file'
.DIRECTORY_SEPARATOR.'Uploader.class.php' );
require_once( dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'DataFileWriter.class.php' );
require_once( dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'CharUtility.class.php' );
/**
 * shopping_PackageConfig
 * - パッケージ名
 *   ショップ管理パッケージ
 * - 概要
 *   管理Webシステムを構築する上での基本となるパッケージです。
 *   管理者ユーザの登録と編集、管理者ログイン機能、管理者ユーザ基本権限など基本的な
 *   管理システムのベースを提供します。
 * - バージョン
 *   1.2.00
 * - 対応データベース
 *   MySQL
 *   PostgreSQL
 * - パッケージの詳細
 *   ショッピングカート機能
 */
class shopping_PackageConfig extends database2_PackageConfigBase {
	function shopping_PackageConfig() {
		$this->definitionHash			= array(
			'SHOPPING_INIT_OPTION'				=> '2',
			'SHOPPING_ORDER_ID_FORMAT'			=> 'SPODRA{num:6}',
			'SHOPPING_MAIL_ADDRESS_BCC'		=> '',
			'SHOPPING_MAIL_ADDRESS_NOTIFY'		=> '',
			'SHOPPING_POINT_METHOD'				=> '0',
			'SHOPPING_POINT_SETTLE_METHOD'		=> '1',
			'SHOPPING_POINT_SETTLE_RATE'		=> '100',
			'SHOPPING_POINT_UNIT'				=> '100',
			'SHOPPING_DELIVERY_FREE_PRICE'		=> '50000',
			'SHOPPING_DELIVERY_TYPE_OPERATION'	=> '0',
			'SHOPPING_DELIVERY_RAPPING_FREEWORD'	=> 'off',
			'SHOPPING_DELIVERY_WISHFUL_DAY_START'	=> '5',
			'SHOPPING_DELIVERY_WISHFUL_DAY_END'	=> '30',
			'SHOPPING_DOWNLOAD_URL'				=> SPIDER_URL_BASE.'shopping/order/download.php',
			'SHOPPING_DOWNLOAD_MAX_COUNT'			=> '3',
			'SHOPPING_DOWNLOAD_ENABLE_FROM_ORDER'	=> '7',
			'SHOPPING_DOWNLOAD_ENABLE_FROM_LAST'	=> '30',
			'SHOPPING_PROMO_FIXED_DISCOUNT_BTM'	=> '10000',
			'SHOPPING_PROMO_FIXED_FEE_BTM'			=> '10000',
			'SHOPPING_TAX_RULE'	=> '1',
			'SHOPPING_TAX_RATE'	=> '5',
			'SHOPPING_MEMBER_CLASSES'				=> array(),
			'SHOPPING_MEMBER_CLASSES_REGISTABLE'	=> array(),
			'SHOPPING_AFFILIATE_DISCOUNT_TYPE'	=> '',
			'SHOPPING_AFFILIATE_DISCOUNT_VALUE'	=> '0',
			'SHOPPING_AFFILIATE_PAY_TYPE'		=> '',
			'SHOPPING_AFFILIATE_PAY_VALUE'		=> '0',
			'SHOPPING_AFFILIATE_BUYING_FLAG'	=> '0',
			'SHOPPING_AFFILIATE_BUYING_RATE'	=> '0',
			'SHOPPING_MEMBER_VIEWABLE'			=> array(0,1,51,52,53),
			'SHOPPING_MEMBER_PURCHASBLE'		=> array(0,1,51,52,53),
			'SHOPPING_RESERVE_STAY_CHECKIN'		=> '15:00',
			'SHOPPING_RESERVE_STAY_CHECKOUT'	=> '10:00',
			'SHOPPING_RESERVE_ENABLE_START'		=> '5',
			'SHOPPING_RESERVE_ENABLE_LIMIT'		=> '90',
			'SHOPPING_RSV_LIMIT_TERM_AT_ONCE'	=> '1',
			'SHOPPING_RSV_LIMIT_UNIT_AT_ONCE'	=> '1',
			'SHOPPING_ORDER_ITEM_FILE_USE'		=> '0',
			'SHOPPING_ORDER_ITEM_FILE_ROOT'		=> DIR_PATH_DATA.DIRECTORY_SEPARATOR.'shopping'.DIRECTORY_SEPARATOR.'orderfiles',
			'SHOPPING_ORDER_STATUS_MAIL'		=> array(),
			'SHOPPING_ORDER_STATUS_OWNER_MAIL'	=> array(),
			'SHOPPING_ORDER_MODIFY_STATUS'	=> array(
				'1'	=> 10,	// 管理者変更
				'2'	=>	5,	// 申込者変更
				'3'	=> 10,	// オーナー変更
			),
		);
	}
	/**
	 * パッケージの表示順序を取得
	 * @return int パッケージ順序
	 */
	function getPackageOrder() {
		return 100;
	}
	/**
	 * パッケージの表示名を取得
	 * @return string パッケージ名称
	 */
	function getPackageViewName() {
		return 'ショップ管理';
	}
	/**
	 * パッケージ概要説明を取得します。
	 */
	function getPackageDescription() {
		return 'ショッピングカート機能。'.$GLOBALS['SHOPPING_LABEL_PRODUCT'].'や'.$GLOBALS['SHOPPING_LABEL_PRODUCT'].'カテゴリの管理、'.$GLOBALS['SHOPPING_LABEL_ORDER'].'の管理、プロモーションの管理などをおこないます。';
	}
	/**
	 * トップページで表示するパッケージ設定のアラートメッセージを取得します
	 */
	function getAlertMessages( & $request ) {
		if( $this->isInstall() ) {
		} else {
			return '<p style="color:#ff6060;font-weight:bold;">ショッピングパッケージのインストールと基本設定を行ってください<br />'
				.'システム設定の<a href="./system/package/">パッケージ管理</a>でインストールできます。</p>'
				.'<p style="text-align:right;"><a href="./system/package/install/form.php?sitpi=shopping">&gt;&gt; ショッピングパッケージのインストールへ</a></p>'
			;
		}
		return '';
	}
	/**
	 * パッケージ依存関係のハッシュを取得
	 * @return hash array('packageId'=>array('version','version',...))
	 */
	function getPackageDependenciesHash() {
		return array(
			'topic'		=> array('1.0.01'),
			'file'		=> array('1.1.00'),
			'member'	=> array('1.1.00'),
		);
	}
	/*
	 * インストール関連のメソッド
	 */
	/**
	 * definitionHashに設定された値の妥当性検査を行います。
	 * @param $request spider_HttpRequestクラスオブジェクトの参照
	 * @return boolean エラーがあるならfalse
	 */
	function validateDifinitionHash( & $request ) {
		if( preg_match('/^[0-3]$/',$this->definitionHash['SHOPPING_INIT_OPTION']) == 0 ) {
			$request->addLocaledError('shopping.error.dao.config.initoption',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( strlen($this->definitionHash['SHOPPING_ORDER_ID_FORMAT']) == 0 ) {
			$request->addLocaledError('shopping.error.dao.config.invalididformat',SPIDER_LOG_LEVEL_ERROR,array());
		} else if( preg_match('/^[0-9A-Z]*(|\\{[yYmn]\\})*[0-9A-Z]*\\{num\\:[3-6]\\}$/',$this->definitionHash['SHOPPING_ORDER_ID_FORMAT']) == 0 ) {
			$request->addLocaledError('shopping.error.dao.config.invalididformat',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			$str	= $this->definitionHash['SHOPPING_ORDER_ID_FORMAT'];
			$str	= str_replace('{Y}',date('Y'),$str);
			$str	= str_replace('{y}',date('y'),$str);
			$str	= str_replace('{m}',date('m'),$str);
			$str	= str_replace('{num:3}','000',$str);
			$str	= str_replace('{num:4}','0000',$str);
			$str	= str_replace('{num:5}','00000',$str);
			$str	= str_replace('{num:6}','000000',$str);
			if( strlen($str) > 16 ) {
				$request->addLocaledError('shopping.error.dao.config.overlengthidformat',SPIDER_LOG_LEVEL_ERROR,array());
			}
		}
		$this->definitionHash['SHOPPING_POINT_METHOD']	= mb_convert_kana($this->definitionHash['SHOPPING_POINT_METHOD'],'a');
		if( preg_match('/^[0-2]$/',$this->definitionHash['SHOPPING_POINT_METHOD']) == 0 ) {
			$request->addLocaledError('shopping.error.dao.config.invalidpointrule',SPIDER_LOG_LEVEL_ERROR,array());
		}
		$this->definitionHash['SHOPPING_POINT_SETTLE_METHOD']	= mb_convert_kana($this->definitionHash['SHOPPING_POINT_SETTLE_METHOD'],'a');
		if( preg_match('/^[0-2]$/',$this->definitionHash['SHOPPING_POINT_SETTLE_METHOD']) == 0 ) {
			$request->addLocaledError('shopping.error.dao.config.invalidpointsettle',SPIDER_LOG_LEVEL_ERROR,array());
		}
		$this->definitionHash['SHOPPING_POINT_SETTLE_RATE']	= mb_convert_kana($this->definitionHash['SHOPPING_POINT_SETTLE_RATE'],'a');
		if( preg_match('/^[0-9]{1,2}$/',$this->definitionHash['SHOPPING_POINT_SETTLE_RATE']) == 0
			&& 100 != $this->definitionHash['SHOPPING_POINT_SETTLE_RATE'] ) {
			$request->addLocaledError('shopping.error.dao.config.invalidpointsettle',SPIDER_LOG_LEVEL_ERROR,array());
		}
		$this->definitionHash['SHOPPING_POINT_UNIT']	= mb_convert_kana($this->definitionHash['SHOPPING_POINT_UNIT'],'a');
		if( preg_match('/^[0-9]{1,4}$/',$this->definitionHash['SHOPPING_POINT_UNIT']) == 0 ) {
			$request->addLocaledError('shopping.error.dao.config.invalidpointunit',SPIDER_LOG_LEVEL_ERROR,array());
		}
		$this->definitionHash['SHOPPING_DELIVERY_FREE_PRICE']	= mb_convert_kana($this->definitionHash['SHOPPING_DELIVERY_FREE_PRICE'],'a');
		if( preg_match('/^[0-9]{0,7}$/',$this->definitionHash['SHOPPING_DELIVERY_FREE_PRICE']) == 0 ) {
			$request->addLocaledError('shopping.error.dao.config.invaliddeliveryfree',SPIDER_LOG_LEVEL_ERROR,array());
		}
		$this->definitionHash['SHOPPING_DELIVERY_WISHFUL_DAY_START']	= mb_convert_kana($this->definitionHash['SHOPPING_DELIVERY_WISHFUL_DAY_START'],'a');
		if( preg_match('/^[0-9]{0,2}$/',$this->definitionHash['SHOPPING_DELIVERY_WISHFUL_DAY_START']) == 0 ) {
			$request->addLocaledError('shopping.error.dao.config.invaliddeliverydayopen',SPIDER_LOG_LEVEL_ERROR,array());
		}
		$this->definitionHash['SHOPPING_DELIVERY_WISHFUL_DAY_END']	= mb_convert_kana($this->definitionHash['SHOPPING_DELIVERY_WISHFUL_DAY_END'],'a');
		if( preg_match('/^[0-9]{0,2}$/',$this->definitionHash['SHOPPING_DELIVERY_WISHFUL_DAY_END']) == 0 ) {
			$request->addLocaledError('shopping.error.dao.config.invaliddeliverydayclose',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( strlen($this->definitionHash['SHOPPING_DOWNLOAD_MAX_COUNT']) == 0 ) {
		} else if( preg_match('/^[0-9]{0,2}$/',$this->definitionHash['SHOPPING_DOWNLOAD_MAX_COUNT']) == 0 ) {
			$request->addLocaledError('shopping.error.dao.config.invaliddownloadlimitcount',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( strlen($this->definitionHash['SHOPPING_DOWNLOAD_ENABLE_FROM_ORDER']) == 0 ) {
		} else if( preg_match('/^[0-9]{0,3}$/',$this->definitionHash['SHOPPING_DOWNLOAD_ENABLE_FROM_ORDER']) == 0 ) {
			$request->addLocaledError('shopping.error.dao.config.invaliddownloadlimitday',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( strlen($this->definitionHash['SHOPPING_DOWNLOAD_ENABLE_FROM_LAST']) == 0 ) {
		} else if( preg_match('/^[0-9]{1,7}$/',$this->definitionHash['SHOPPING_DOWNLOAD_ENABLE_FROM_LAST']) == 0 ) {
			$request->addLocaledError('shopping.error.dao.config.invaliddownloadlimitday2',SPIDER_LOG_LEVEL_ERROR,array());
		}

		$this->definitionHash['SHOPPING_PROMO_FIXED_DISCOUNT_BTM']	= mb_convert_kana($this->definitionHash['SHOPPING_PROMO_FIXED_DISCOUNT_BTM'],'a');
		if( preg_match('/^[0-9]{0,7}$/',$this->definitionHash['SHOPPING_PROMO_FIXED_DISCOUNT_BTM']) == 0 ) {
			$request->addLocaledError('shopping.error.dao.config.invalidconddiscount',SPIDER_LOG_LEVEL_ERROR,array());
		}
		$this->definitionHash['SHOPPING_PROMO_FIXED_FEE_BTM']	= mb_convert_kana($this->definitionHash['SHOPPING_PROMO_FIXED_FEE_BTM'],'a');
		if( preg_match('/^[0-9]{0,7}$/',$this->definitionHash['SHOPPING_PROMO_FIXED_FEE_BTM']) == 0 ) {
			$request->addLocaledError('shopping.error.dao.config.invalidcondfee',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( $request->isError() ) {
			return false;
		} else {
			return true;
		}
	}
	/**
	 * インストールを実行します。
	 */
	function install( & $request ) {
		if( parent::install($request) ) {
			$databasePackageConfig	= spider_Controller::createObject('database2_PackageConfig');
			if( $databasePackageConfig->load( $request ) ) {
				$memberPackageConfig	= spider_Controller::createObject('member_PackageConfig');
				if( $memberPackageConfig->load( $request ) ) {
				} else {
					$request->addLocaledError('shopping.error.dao.config.requirememberpackage',SPIDER_LOG_LEVEL_ERROR,array());
				}
			} else {
				$databasePackageConfig	= $request->getAttribute('database.configuration_object');
				if( is_null($databasePackageConfig) || get_class($databasePackageConfig) != get_class(spider_Controller::createObject('database2_PackageConfig')) ) {
					$request->addLocaledError('shopping.error.dao.config.requiredatabase2package',SPIDER_LOG_LEVEL_ERROR,array());
					return false;
				}
			}
			$instPath	= DIR_PATH_DATA.'/shopping.define.inc.php';
			if( !file_exists($instPath) || $this->definitionHash['MEMBER_INIT_OPTION'] != 1) {
				$connection	= $databasePackageConfig->getWritableConnection( $request );
				if( $connection ) {
					$request->setAttribute('dbo',$connection);
					// 初期の送料設定を挿入
					for( $weight=10; $weight<=30; $weight=$weight+10 ) {
						foreach( $GLOBALS['PREFECTURE_HASH'] as $prefNum => $prefName ) {
							$sql	= 'INSERT INTO '. TABLE_NAME_SHOPPING_DELIVERY_SETTING.'('
								.'setting_id,delivery_weight,prefecture_number,delivery_price,updated_date,registered_date'
								.') VALUES('
								.$connection->quote('A'.sprintf('%03d',$weight).sprintf('%03d',$prefNum))
								.','.$weight
								.','.$prefNum
								.','.($weight*50)
								.',NOW(),NOW()'
								.')';
							$connection->query($sql);
						}
					}
					// 標準メールテンプレートのインストール
					spider_Controller::loadClassDefinition('member_DaoMemberMailTemplate');
					if(member_DaoMemberMailTemplate::insertTemplateByRootFolder( $request,
					dirname(__FILE__).DIRECTORY_SEPARATOR.'install'.DIRECTORY_SEPARATOR.'mail')){
					} else {
						$request->addLocaledError('member.error.mail.template.install',SPIDER_LOG_LEVEL_FATAL,array($this->getPackageViewName()));
					}
					// 状態ごとの通知メールテンプレートを空で作成
					foreach( $GLOBALS['SHOPPING_ORDER_STATUS_HASH'] as $statusKey => $statusLabel ){
						// オーナー宛通知メール
						$templateId					= 'SHOPMAILSTA'.sprintf('%03d',$statusKey);
						$mailTemplateObject	= new member_DaoMemberMailTemplate();
						$mailTemplateObject->template_id		= $templateId;
						$connection->loadById($mailTemplateObject,$templateId);
						$mailTemplateObject->template_name	= '['.$GLOBALS['SHOPPING_LABEL_ORDER'].'][オーナー宛][状態変更通知]'.$statusLabel;
						$mailTemplateObject->subject		= '['.$GLOBALS['SHOPPING_LABEL_ORDER'].'][オーナー宛][状態変更通知]'.$statusLabel;
						$mailTemplateObject->description	= '['.$GLOBALS['SHOPPING_LABEL_ORDER'].'][オーナー宛][状態変更通知]'.$statusLabel;
						$mailTemplateObject->mail_from_name		= SYSTEM_MAIL_FROM_NAME;
						$mailTemplateObject->mail_from_address	= SYSTEM_MAIL_FROM_ADDRESS;
						$mailTemplateObject->mail_reply_address	= SYSTEM_MAIL_REPLY_ADDRESS;
						$mailTemplateObject->mail_return_path	= SYSTEM_MAIL_RETURN_ADDRESS;
						$mailTemplateObject->updated_date		= date('Y-m-d H:i:s');
						$mailTemplateObject->registered_date	= date('Y-m-d H:i:s');
						$mailTemplateObject->owner_id			= 'SYSADMIN';
						$mailTemplateObject->modifier_id		= 'SYSADMIN';
						if( strlen($mailTemplateObject->template_number) > 0){
							if($connection->update($mailTemplateObject)){
							} else {
								$request->addLocaledError('member.error.mail.template.install',SPIDER_LOG_LEVEL_FATAL,array($this->getPackageViewName()));
							}
						} else {
							if($connection->insert($mailTemplateObject)){
							} else {
								$request->addLocaledError('member.error.mail.template.install',SPIDER_LOG_LEVEL_FATAL,array($this->getPackageViewName()));
							}
						}
						// 申込者宛通知メール
						$templateId					= 'SHOPMAILSTP'.sprintf('%03d',$statusKey);
						$mailTemplateObject	= new member_DaoMemberMailTemplate();
						$connection->loadById($mailTemplateObject,$templateId);
						$mailTemplateObject->template_id		= $templateId;
						$mailTemplateObject->template_name	= '['.$GLOBALS['SHOPPING_LABEL_ORDER'].']['.$GLOBALS['SHOPPING_LABEL_ORDER'].'者宛][状態変更通知]'.$statusLabel;
						$mailTemplateObject->subject		= '['.$GLOBALS['SHOPPING_LABEL_ORDER'].']['.$GLOBALS['SHOPPING_LABEL_ORDER'].'者宛][状態変更通知]'.$statusLabel;
						$mailTemplateObject->description	= '['.$GLOBALS['SHOPPING_LABEL_ORDER'].']['.$GLOBALS['SHOPPING_LABEL_ORDER'].'者宛][状態変更通知]'.$statusLabel;
						$mailTemplateObject->mail_from_name		= SYSTEM_MAIL_FROM_NAME;
						$mailTemplateObject->mail_from_address	= SYSTEM_MAIL_FROM_ADDRESS;
						$mailTemplateObject->mail_reply_address	= SYSTEM_MAIL_REPLY_ADDRESS;
						$mailTemplateObject->mail_return_path	= SYSTEM_MAIL_RETURN_ADDRESS;
						$mailTemplateObject->updated_date		= date('Y-m-d H:i:s');
						$mailTemplateObject->registered_date	= date('Y-m-d H:i:s');
						$mailTemplateObject->owner_id			= 'SYSADMIN';
						$mailTemplateObject->modifier_id		= 'SYSADMIN';
						if( strlen($mailTemplateObject->template_number) > 0){
							if($connection->update($mailTemplateObject)){
							} else {
								$request->addLocaledError('member.error.mail.template.install',SPIDER_LOG_LEVEL_FATAL,array($this->getPackageViewName()));
							}
						} else {
							if($connection->insert($mailTemplateObject)){
							} else {
								$request->addLocaledError('member.error.mail.template.install',SPIDER_LOG_LEVEL_FATAL,array($this->getPackageViewName()));
							}
						}
					}
				}
			}
		}
		if( $request->isError() ) {
			return false;
		} else {
			return true;
		}
	}
	//
	// 消費税計算関連メソッド
	//
	/**
	 * 消費税計算方法を取得します
	 * @return 0=全体一括, 1=商品ごとに計算して合計
	 */
	function _getTaxCalculateType() {
		$calculateType	= '0';
		$roundType		= '1';
		if( defined('SHOPPING_TAX_RULE') && strlen(SHOPPING_TAX_RULE)>0 ) {
			$settingStr		= sprintf('%02d',SHOPPING_TAX_RULE);
			$calculateType	= substr($settingStr,0,1);
			$roundType		= substr($settingStr,1,1);
		}
		return $calculateType;
	}
	/**
	 * 消費税小数点以下のまるめ方法を取得します
	 * @return 1=切り捨て, 2=切り上げ, 3=四捨五入, 4=五捨六入
	 */
	function _getTaxRoundType() {
		$calculateType	= '0';
		$roundType		= '1';
		if( defined('SHOPPING_TAX_RULE') && strlen(SHOPPING_TAX_RULE)>0 ) {
			$settingStr		= sprintf('%02d',SHOPPING_TAX_RULE);
			$calculateType	= substr($settingStr,0,1);
			$roundType		= substr($settingStr,1,1);
		}
		return $roundType;
	}
	/**
	 * 割引の消費税小数点以下のまるめ方法を取得します
	 */
	function _getTaxRoundDiscountType() {
		$roundMethod	= shopping_PackageConfig::_getTaxRoundType();
		if( $roundMethod == 4 ) {
			// 五捨六入なら四捨五入
			return 3;
		} else if( $roundMethod == 3 ) {
			// 四捨五入なら五捨六入
			return 4;
		} else if( $roundMethod == 2 ) {
			// 切り上げなら切り捨て
			return 1;
		} else {
			// 切り捨てなら切り上げ
			return 2;
		}
	}
	/**
	 * 端数を丸める静的メソッド（PHP4ではround関数で五捨六入が出来ない為実装。PHP5では不要になるかもしれない)
	 * @param $numeric 小数を含む数字
	 * @param $roundMethod int 1=切り捨て, 2=切り上げ, 3=四捨五入, 4=五捨六入
	 * @return int 整数
	 */
	function _roundNumeric( $num, $roundMethod=0 ) {
		if( $roundMethod == 4 ) {
			// 五捨六入
			if( ( $num * 10 ) % 10 > 5 ) {
				return ceil($num);
			} else {
				return floor($num);
			}
		} else if( $roundMethod == 3 ) {
			// 四捨五入
			return round($num);
		} else if( $roundMethod == 2 ) {
			// 切り上げ
			return ceil($num);
		} else {
			// 切り捨て
			return floor($num);
		}
	}
	//
	//
	//
	/**
	 * 指定名のテンプレート件名・文章を取得
	 * @param $request spider_HttpRequestオブジェクトのインスタンス
	 * @param $templateName テンプレート名
	 * @param $targetAddress 宛先メールアドレス
	 * @return hash array('subject'=>メール件名, 'body'=>メール本文, 'fileName'=>ファイル名, 'isMobile'=>boolean携帯宛)
	 */
	function getMailTemplateInformation( & $request, $templateName='SHOPMAILTHANKSNW', $targetAddress ) {
		// 送信先アドレスが携帯か確認
		$isMobile	= false;
		foreach( $GLOBALS['MOBILE_MAIL_DOMAIN_ARRAY'] as $fqdn ) {
			$fqdn_regx	= str_replace('.','\\.',$fqdn );
			if( preg_match('/\\@'.$fqdn_regx.'$/',$targetAddress) > 0 ) {
				$isMobile	= true;
				break;
			}
		}
		$dbo	= $request->getAttribute('dbo');
		$memberMailTemplate	= spider_Controller::createObject('member_DaoMemberMailTemplate');
		// ロケール確認
		$isExists	= false;
		$templateId = $templateName.'_'.$request->locale;
		if( $dbo->loadById($memberMailTemplate,$templateId) ){
			$isExists	= true;
		} else if( $dbo->loadById($memberMailTemplate,$templateName) ) {
			$isExists	= true;
		}
		if( $isExists ) {
			$fromName		= $memberMailTemplate->mail_from_name;
			if( strlen($fromName) == 0 && defined('SYSTEM_MAIL_FROM_NAME') && strlen(SYSTEM_MAIL_FROM_NAME) > 0 ) {
				$fromName	= SYSTEM_MAIL_FROM_NAME;
			}
			$fromAddress	= $memberMailTemplate->mail_from_address;
			if( strlen($fromAddress) == 0 && defined('SYSTEM_MAIL_FROM_ADDRESS') ) {
				$fromAddress	= SYSTEM_MAIL_FROM_ADDRESS;
			}
			$replyAddress	= $memberMailTemplate->mail_reply_address;
			if( strlen($replyAddress) == 0 && defined('SYSTEM_MAIL_REPLY_ADDRESS') ) {
				$replyAddress	= SYSTEM_MAIL_REPLY_ADDRESS;
			}
			$returnAddress	= $memberMailTemplate->mail_return_path;
			if( strlen($returnAddress) == 0 && defined('SYSTEM_MAIL_RETURN_ADDRESS') ) {
				$returnAddress	= SYSTEM_MAIL_RETURN_ADDRESS;
			}
			$mailSubject	= $memberMailTemplate->subject;
			if( $isMobile && strlen($memberMailTemplate->subject_mobile) > 0 ) {
				$mailSubject	= $memberMailTemplate->subject_mobile;
			}
			$mailBody	= $memberMailTemplate->text_body_default;
			if( $isMobile && strlen($memberMailTemplate->text_body_mobile) > 0 ) {
				$mailBody	= $memberMailTemplate->text_body_mobile;
			}
			$fromString	= $fromAddress;
			if( strlen($fromName) > 0 ) {
				$fromString	= $fromName.' <'.$fromAddress.'>';
			}
			return array(
				'subject'		=> $mailSubject,
				'body'			=> $mailBody,
				'fileName'		=> $templateName,	// 非推奨
				'isMobile'		=> $isMobile,
				'strings'		=> $mailBody,
				'fromAddress'	=> $fromAddress,
				'fromName'		=> $fromName,
				'fromString'	=> $fromString,
				'replyAddress'	=> $replyAddress,
				'returnAddress'	=> $returnAddress,
				'templateName'	=> $memberMailTemplate->template_name,
			);
		} else {
			$request->addLocaledError('member.error.mail.template.notfound',SPIDER_LOG_LEVEL_FATAL,array($templateName));
			return false;
		}
	}
}
?>