<?php
/*
 * shopping/LoadConfig.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * shopping_LoadConfig
 * spiderモジュール：shoppingパッケージ shoppingパッケージ設定読み込みモジュール
 * 
 */
class shopping_LoadConfig extends system_login_ModuleBase {
	function shopping_LoadConfig() {
	}
	function execute( & $request ) {
		$shoppingDefFilePath	= DIR_PATH_DATA.DIRECTORY_SEPARATOR.'shopping.define.inc.php';
		$isSetup	= false;
		if( file_exists($shoppingDefFilePath) ) {
			$isSetup	= true;
			require_once($shoppingDefFilePath);
		}
		$request->setAttribute('shopping.is_setup',			$isSetup);
		// ラッピング選択肢の読み込み
		$rappingSettingUri		= SHOPPING_RAPPING_FILE_URI;
		$deliveryRappingOptions	= trim(system_DataFileWriter::getContents( $request, $rappingSettingUri, DIR_NAME_DATA ));
		$deliveryWrappingHash	= array();
		if( strlen($deliveryRappingOptions) > 0 ) {
			$deliveryRappingArray	= explode("\n",$deliveryRappingOptions);
			foreach( $deliveryRappingArray as $key => $line ) {
				$tmpArray	= explode(',',trim($line));
				if( count( $tmpArray ) > 1 ) {
					$wrappingPrice	= array_pop($tmpArray);
					$wrappingName	= implode(',',$tmpArray);
				} else {
					$wrappingPrice	= 0;
					$wrappingName	= implode(',',$tmpArray);
				}
				if( !isset($deliveryWrappingHash[$key]) || !is_array($deliveryWrappingHash[$key]) ) {
					$deliveryWrappingHash[$key]	= array();
				}
				$deliveryWrappingHash[$key]['name']	= $wrappingName;
				$deliveryWrappingHash[$key]['price']	= $wrappingPrice;
			}
		}
		// ラッピング追加フリーワード表示
		$viewWrappingFreeWord2	= false;
		if( preg_match('/^[oO][nN]$/',SHOPPING_DELIVERY_RAPPING_FREEWORD) > 0 ) {
			$viewWrappingFreeWord2	= true;
		}
		// お届け希望日
		$deliveryWishfulDayStart	= null;
		$deliveryWishfulDayEnd		= null;
		if( defined('SHOPPING_DELIVERY_WISHFUL_DAY_START')
			&& preg_match('/^[0-9]{1,2}$/',SHOPPING_DELIVERY_WISHFUL_DAY_START) > 0 ) {
			$deliveryWishfulDayStart	= SHOPPING_DELIVERY_WISHFUL_DAY_START;
		}
		if( defined('SHOPPING_DELIVERY_WISHFUL_DAY_END')
			&& preg_match('/^[0-9]{1,2}$/',SHOPPING_DELIVERY_WISHFUL_DAY_END) > 0 ) {
			$deliveryWishfulDayEnd		= SHOPPING_DELIVERY_WISHFUL_DAY_END;
		}
		// お届け希望時間帯 選択肢の読み込み
		$wishfulTimesUri		= SHOPPING_WISHFUL_TIME_FILE_URI;
		$wishfulTimesStrings	= system_DataFileWriter::getContents( $request, $wishfulTimesUri, DIR_NAME_DATA );
		if( !is_null($wishfulTimesStrings) && strlen(trim($wishfulTimesStrings)) > 0 ) {
			$wishfulTimeArray		= explode("\n",trim($wishfulTimesStrings));
		} else {
			$wishfulTimeArray		= array();
		}
		// ポイント付与規則
		$pointAddMethod	= 0;
		if( defined('SHOPPING_POINT_METHOD') && strlen(SHOPPING_POINT_METHOD) > 0 ) {
			$pointAddMethod	= SHOPPING_POINT_METHOD;
		}
		// ポイント清算規則
		$pointSettleMethod	= 0;
		if( defined('SHOPPING_POINT_SETTLE_METHOD') && strlen(SHOPPING_POINT_SETTLE_METHOD) > 0 ) {
			$pointSettleMethod	= SHOPPING_POINT_SETTLE_METHOD;
		}
		$pointSettleRate	= 100;
		if( defined('SHOPPING_POINT_SETTLE_RATE') && strlen(SHOPPING_POINT_SETTLE_RATE) > 0 ) {
			$pointSettleRate	= SHOPPING_POINT_SETTLE_RATE;
		}
		// ポイント利用単位
		$pointUnit			= 100;
		if( defined('SHOPPING_POINT_UNIT') && strlen(SHOPPING_POINT_UNIT) > 0 ) {
			$pointUnit	= SHOPPING_POINT_UNIT;
		}
		// 会員公募設定
		$registMemberByUser	= true;
		if( !defined('MEMBER_PERMIT_REGIST_BY_USER')
		|| preg_match('/^[tT](|[rR][uU][eE])$/',MEMBER_PERMIT_REGIST_BY_USER) == 0 ) {
			$registMemberByUser	= false;
		}
		$request->setAttribute('shopping.order.deliveryRappingHash',	$deliveryWrappingHash );
		$request->setAttribute('shopping.order.viewWrappingFreeWord2',	$viewWrappingFreeWord2 );
		$request->setAttribute('shopping.order.deliveryWishfulDayStart',	$deliveryWishfulDayStart );
		$request->setAttribute('shopping.order.deliveryWishfulDayEnd',	$deliveryWishfulDayEnd );
		$request->setAttribute('shopping.order.wishfulTimeArray',	$wishfulTimeArray );
		$request->setAttribute('shopping.order.pointAddMethod',	$pointAddMethod );
		$request->setAttribute('shopping.order.pointSettleMethod',	$pointSettleMethod );
		$request->setAttribute('shopping.order.pointSettleRate',	$pointSettleRate );
		$request->setAttribute('shopping.order.pointUnit',	$pointUnit );
		$request->setAttribute('shopping.order.registMemberByUser',	$registMemberByUser );
	}
}
?>