<?php
/*
 * shopping/DaoShoppingProduct.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'DaoShoppingProductUnit.class.php' );
/**
 * shopping_DaoShoppingProduct
 * shoppingパッケージ データアクセスオブジェクトクラス shopping_productテーブル用
 */
class shopping_DaoShoppingProduct extends database2_AbstractData {
	/** シリアル番号	*/
	var $product_number;
	/** 商品ID	*/
	var $product_id;
	/** 商品名	*/
	var $product_name;
	/** 商品名フリガナ	*/
	var $product_kana;
	/** 状態フラグ	*/
	var $status_flag	= 101;
	/** 配送種別: 0=通常便, 1=クール便, 11=ダウンロード商品, 21>=継続商品	*/
	var $delivery_type	= 0;
	/** 公開設定:閲覧	*/
	var $member_viewable	= -1;
	/** 公開設定:購入	*/
	var $member_purchasable		= -1;
	/** 順序番号	*/
	var $order_number	= 0;
	/** 検索キーワード	*/
	var $keywords;
	/** キャッチコピー	*/
	var $catch_copy;
	/** 商品概要	*/
	var $description;
	/** 詳細コメント	*/
	var $detail_comment;
	/** 卸業者名	*/
	var $wholesaler_name;
	/** 卸業者発注用メールアドレス	*/
	var $wholesaler_email;
	/** 卸業者メモ	*/
	var $wholesaler_note;
	/** 商品公式ＵＲＬ	*/
	var $product_url;
	/** 表記カウント単位	*/
	var $unit_string;
	/** オプション1選択名	*/
	var $option1_name;
	/** オプション1選択肢	*/
	var $option1_items;
	/** オプション1説明文 */
	var $option1_explanation;
	/** オプション1説明ＵＲＬ	*/
	var $option1_url;
	/** オプション1計算方法	*/
	var $option1_calculate	= 0;
	/** オプション2選択名	*/
	var $option2_name;
	/** オプション2選択肢	*/
	var $option2_items;
	/** オプション2説明文 */
	var $option2_explanation;
	/** オプション2説明ＵＲＬ	*/
	var $option2_url;
	/** オプション2計算方法	*/
	var $option2_calculate	= 0;
	/** オプション3選択名	*/
	var $option3_name;
	/** オプション3選択肢	*/
	var $option3_items;
	/** オプション3説明文 */
	var $option3_explanation;
	/** オプション3説明ＵＲＬ	*/
	var $option3_url;
	/** オプション3計算方法	*/
	var $option3_calculate	= 0;
	/** オプション4選択名	*/
	var $option4_name;
	/** オプション4選択肢	*/
	var $option4_items;
	/** オプション4説明文 */
	var $option4_explanation;
	/** オプション4説明ＵＲＬ	*/
	var $option4_url;
	/** オプション4計算方法	*/
	var $option4_calculate	= 0;
	/** オプション5選択名	*/
	var $option5_name;
	/** オプション5選択肢	*/
	var $option5_items;
	/** オプション5説明文 */
	var $option5_explanation;
	/** オプション5説明ＵＲＬ	*/
	var $option5_url;
	/** オプション5計算方法	*/
	var $option5_calculate	= 0;
	/** 更新日	*/
	var $updated_date;
	/** 登録日	*/
	var $registered_date;
	/** カレンダータイプ	*/
	var $calendar_type	= 1;
	/** 関連ID: 検索パッケージのデータと関連させる為のID	*/
	var $search_data_id;
	/** 登録者ID	*/
	var $owner_id;
	/** 変更者ＩＤ	*/
	var $modifier_id;
	
	/** オブジェクト拡張：公開対象配列	*/
	var $openTargetArray	= array();
	/** オブジェクト拡張：カテゴリID配列	*/
	var $categoryIdArray	= array();
	/** オブジェクト拡張：商品ファイル配列	*/
	var $fileIdArray		= array();
	/** オブジェクト拡張：販売単位オブジェクト配列	*/
	var $unitObjectArray	= array();
	/** オブジェクト拡張：販売単位に関連する商品フラグIDハッシュ	*/
	var $unitFlagIdHash		= array();

	/** オブジェクト拡張：公開設定(閲覧)ハッシュ	*/
	var $memberViewableArray	= array();
	/** オブジェクト拡張：公開設定(購入)ハッシュ	*/
	var $memberPurchasableArray	= array();
	
	/** オブジェクト拡張：関連商品ID配列	*/
	var $relatedProductIdArray		= array();

	/** オブジェクト：オーナー情報	*/
	var $ownerObject;
	/** オブジェクト拡張：関連検索データ	*/
	var $searchDataObject;
	
	/**
	 * コンストラクタ
	 */
	function shopping_DaoShoppingProduct(){
		$this->openTargetArray		= array();
		$this->categoryIdArray		= array();
		$this->categoryIdArray_org	= array();
		$this->fileIdArray			= array();
		$this->fileIdArray_org		= array();
		$this->relatedProductIdArray			= array();
		$this->relatedProductIdArray_org	= array();
		$this->unitObjectArray		= array();
		$this->unitFlagIdHash		= array();
		$this->ownerObject			= null;
	}
	/**
	 * 付加情報を読み込み
	 * @param $dbo database2_Connectionオブジェクト
	 */
	function loadRelation( $dbo ) {
		// 読み込みカラムの調整
		$this->optimizeLoadedVars();
		// 所属カテゴリの読み込み
		if( $this->loadRelatedCategories( $dbo ) === false ) { return false; }
		// 添付ファイルの読み込み
		if( $this->loadRelatedFiles( $dbo ) === false ) { return false; }
		// 関連商品の読み込み
		if( $this->loadRelatedProductId( $dbo ) === false ){ return false; }
		// 販売単位の読み込み
		if( $this->loadRelatedUnitObjects( $dbo ) === false ) { return false; }
		// 検索パッケージ連携
		if( $this->loadRelatedSearchData( $dbo ) === false ) { return false; }
		return true;
	}
	/**
	 * 所属カテゴリの読み込み
	 * @param $dbo database2_Connectionオブジェクト
	 */
	function loadRelatedCategories( $dbo ) {
		$this->categoryIdArray	= array();
		$this->categoryIdArray_org	= array();
		$sql	= 'SELECT category_id FROM '.TABLE_NAME_SHOPPING_CATEGORY_PRODUCT
			.' WHERE product_id='.$dbo->quote($this->product_id)
			.' ORDER BY order_number ASC';
		$rows	= $dbo->queryAll( $sql, 'hash', false );
		if ( $rows === false ) {
			return false;
		} else {
			foreach( $rows as $row ) {
				array_push( $this->categoryIdArray, trim($row['category_id']));
				array_push( $this->categoryIdArray_org, trim($row['category_id']));
			}
		}
		return true;
	}
	/**
	 * 添付画像の読み込み
	 * @param $dbo database2_Connectionオブジェクト
	 */
	function loadRelatedFiles( $dbo ) {
		$this->fileIdArray		= array();
		$this->fileIdArray_org	= array();
		$sql	= 'SELECT file_id,order_number FROM '.TABLE_NAME_SHOPPING_PRODUCT_FILE
			.' WHERE product_id='.$dbo->quote($this->product_id)
			.' ORDER BY order_number ASC';
		$rows	= $dbo->queryAll( $sql, 'hash', false );
		if ( $rows === false ) {
			return false;
		} else {
			foreach( $rows as $row ) {
				$this->fileIdArray[$row['order_number']]	= trim($row['file_id']);
				$this->fileIdArray_org[$row['order_number']]	= trim($row['file_id']);
			}
		}
		return true;
	}
	/**
	 * 関連商品の読み込み
	 * @param $dbo database2_Connectionオブジェクト
	 */
	function loadRelatedProductId( $dbo ) {
		$this->relatedProductIdArray			= array();
		$this->relatedProductIdArray_org	= array();
		$sql	= 'SELECT related_product_id,display_order FROM '.TABLE_NAME_SHOPPING_PRODUCT_RELATION
			.' WHERE product_id='.$dbo->quote($this->product_id)
			.' ORDER BY display_order ASC';
		$rows	= $dbo->queryAll( $sql, 'hash', false );
		if ( $rows === false ) {
			return false;
		} else {
			foreach( $rows as $row ) {
				$this->fileIdArray[$row['display_order']]	= trim($row['related_product_id']);
				$this->fileIdArray_org[$row['display_order']]	= trim($row['related_product_id']);
			}
		}
		return true;
	}
	/**
	 * 所属販売単位の読み込み
	 * @param $dbo database2_Connectionオブジェクト
	 */
	function loadRelatedUnitObjects( $dbo ) {
		$unitIdArray		= array();
		$this->unitObjectArray		= array();
		$daoShoppingProductUnit		= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
		$sql	= 'SELECT * FROM '.TABLE_NAME_SHOPPING_PRODUCT_UNIT
			.' WHERE product_id='.$dbo->quote($this->product_id)
			.' AND status_flag < 200 '
			.' ORDER BY order_number ASC';
		$rows	= $dbo->queryAll( $sql, $daoShoppingProductUnit, false );
		if ( $rows === false ) {
			return false;
		} else {
			foreach( $rows as $row ) {
				$row->loadRelationExceptProduct( $dbo );
				$row->shoppingProductObject	= & $this;
				$row->optimizeLoadedVars($dbo);
				array_push($this->unitObjectArray,$row);
				array_push($unitIdArray,$dbo->quote($row->unit_id));
			}
		}
		// 販売単位に関連する商品フラグIDのハッシュを作成
		$unitFlagIdHash = array();
		if ( is_array($unitIdArray) && count($unitIdArray)>0 ) {
			$sql	= 'SELECT '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.unit_id, '
				. TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.flag_id '
				. ' FROM '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION
				.' WHERE unit_id IN ('. implode( ',', $unitIdArray ) . ')'
				.' AND (('.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.open_date IS NULL'
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.close_date IS NULL)' 
				.' OR ('.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.open_date <= '.$dbo->quote(date('Y-m-d'))
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.close_date >= '.$dbo->quote(date('Y-m-d')).')'
				.' OR ('.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.open_date <= '.$dbo->quote(date('Y-m-d'))
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.close_date IS NULL)'
				.' OR ('.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.open_date IS NULL'
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.close_date >= '.$dbo->quote(date('Y-m-d')).'))'
			;
			$rows	= $dbo->queryAll( $sql, 'hash', false );
			if ( $rows === false ) {
				return false;
			} else {
				foreach( $rows as $row ) {
					$unitId		= trim($row['unit_id']);
					if ( !is_array($unitFlagIdHash[$unitId]) ) {
						$unitFlagIdHash[$unitId] = array();
					}
					array_push($unitFlagIdHash[$unitId],trim($row['flag_id']));
				}
			}
		}
		$this->unitFlagIdHash	= $unitFlagIdHash;
		
		return true;
	}
	/**
	 * メンバ調整
	 */
	function optimizeLoadedVars() {
		// オプション文字列の分割
		for( $i=1; $i<=5; $i++ ) {
			$fieldNameOptionItems		= 'option'.$i.'_items';
			$optionNameArrayName	= 'option'.$i.'_item_array';
			$optionPriceArrayName	= 'option'.$i.'_price_array';
			$optionCostArrayName	= 'option'.$i.'_cost_array';
			if( strlen( $this->$fieldNameOptionItems ) > 0 ) {
				// オプション選択肢が設定されているなら処理
				$this->$fieldNameOptionItems			= str_replace("\r\n","\n",$this->$fieldNameOptionItems);
				$this->$fieldNameOptionItems			= str_replace("\r","\n",$this->$fieldNameOptionItems);
				$this->$optionNameArrayName		= array();
				$this->$optionPriceArrayName	= array();
				$this->$optionCostArrayName		= array();
				$itemStringArray				= explode("\n",$this->$fieldNameOptionItems);
				if( preg_match('/\\:/',$this->$fieldNameOptionItems) > 0 ) {
					// :を含むなら価格と分割
					foreach( $itemStringArray as $str ) {
						list( $itemName, $itemPrice, $itemCost )	= explode(':',$str);
						array_push($this->$optionNameArrayName,$itemName);
						if( strlen($itemPrice)==0 ) {
							$itemPrice	= 0;
						}
						if( strlen($itemCost)==0 ) {
							$itemCost	= 0;
						}
						array_push($this->$optionPriceArrayName,$itemPrice);
						array_push($this->$optionCostArrayName,$itemCost);
					}
				} else {
					$this->$optionNameArrayName	= $itemStringArray;
				}
			}
		}
		// 公開設定を配列に設定
		$this->memberViewableArray	= array();
		$this->memberPurchasableArray	= array();
		$memberViewableStr	= sprintf('%016b',$this->member_viewable);
		$memberPurchasableStr	= sprintf('%016b',$this->member_purchasable);
		
		$keyCol	= 0;
		foreach ( $GLOBALS['MEMBER_MEMBER_CLASS_HASH'] as $key=>$value ) {
			if ( substr($memberViewableStr,15-$keyCol,1) == '1' ) {
				array_push($this->memberViewableArray,$key);
			}
			if ( substr($memberPurchasableStr,15-$keyCol,1) == '1' ) {
				array_push($this->memberPurchasableArray,$key);
			}
			$keyCol++;
		}
	}
	/**
	 * 検索パッケージ連携：関連検索データを読み込む
	 */
	function loadRelatedSearchData( $dbo ) {
		if( strlen(trim($this->search_data_id)) > 0 ) {
			try{
				$searchDataObject	= spider_Controller::createObject('search_DaoSearchData');
				if( $dbo->loadById($searchDataObject,$this->search_data_id) ) {
					$this->searchDataObject	= $searchDataObject;
				} else {
					$this->searchDataObject	= null;
					return false;
				}
			} catch ( Exception $exption ) {
				// 特に何もしないことにする
			}
		}
		return true;
	}
	/**
	 * 指定日時が営業か確認
	 * @param spider_HttpRequest &$request spider_HttpRequestクラスインスタンス参照
	 * @param datetime $serviceStartDate 開始時間（予約の場合のみ指定可能）
	 * @param datetime $serviceLimitDate 終了時間（予約の場合のみ指定可能）
	 */
	function isOnService( & $request, $targetDatetime ){
		$dbo	= $request->getAttribute('dbo');
		// TODO 未実装
	}
	/**
	 * インサート前に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function pre_insert( $dbo ) {
		return true;
	}
	/**
	 * インサート後に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function post_insert( $dbo ) {
		// カテゴリ関連付けをインサートする
		if( is_array($this->categoryIdArray) ) {
			foreach( $this->categoryIdArray as $key => $categoryId ) {
				if( strlen(trim($categoryId)) > 0 ) {
					$sql	= 'INSERT INTO '.TABLE_NAME_SHOPPING_CATEGORY_PRODUCT.'(category_id,product_id,order_number) VALUES ('
						.$dbo->quote($categoryId)
						.','.$dbo->quote($this->product_id)
						.','.$key
						.' )'
					;
					$result = $dbo->query( $sql );
					if( false === $result ) {
						return false;
					}
				}
			}
		}
		// ファイル関連付けをインサートする
		if( is_array($this->fileIdArray) ) {
			foreach( $this->fileIdArray as $key => $fileId ) {
				if( strlen(trim($fileId)) > 0 ) {
					$sql	= 'INSERT INTO '.TABLE_NAME_SHOPPING_PRODUCT_FILE.'(file_id,product_id,file_class,order_number) VALUES ('
						.$dbo->quote($fileId).','.$dbo->quote($this->product_id).',0'.','.$key.' )';
					$result = $dbo->query( $sql );
					if( false === $result ) {
						return false;
					}
				}
			}
		}
		// 商品関連付けをインサートする
		if( is_array($this->relatedProductIdArray) ) {
			foreach( $this->relatedProductIdArray as $key => $relatedProductId ) {
				if( strlen(trim($relatedProductId)) > 0 ) {
					$sql	= 'INSERT INTO '.TABLE_NAME_SHOPPING_PRODUCT_RELATION
					.'(product_id,related_product_id,display_order) VALUES ('
					.$dbo->quote($this->product_id).','.$dbo->quote($relatedProductId).','.$key.' )';
					$result = $dbo->query( $sql );
					if( false === $result ) {
						return false;
					}
				}
			}
		}
		return true;
	}
	/**
	 * アップデート前に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function pre_update( $dbo ) {
		return true;
	}
	/**
	 * アップデート後に行いたい処理
	 * @param MDBObject $dbo MDB2オブジェクトかその互換オブジェクト
	 * @return boolean 成功したらtrue
	 */
	function post_update( $dbo ) {
		$request	= spider_Controller::createObject('spider_HttpRequest');
		// カテゴリ関連付けをインサートしなおす
		$sql	= 'DELETE FROM '.TABLE_NAME_SHOPPING_CATEGORY_PRODUCT.' WHERE product_id='.$dbo->quote($this->product_id);
		$result = $dbo->query( $sql );
		if( false === $result ) {
			return false;
		}
		if( is_array($this->categoryIdArray) ) {
			foreach( $this->categoryIdArray as $key => $categoryId ) {
				if( strlen(trim($categoryId)) > 0 ) {
					$sql	= 'INSERT INTO '.TABLE_NAME_SHOPPING_CATEGORY_PRODUCT
					.'(category_id,product_id,order_number) VALUES ('
					.$dbo->quote($categoryId)
					.','.$dbo->quote($this->product_id)
					.','.$key
					.' )';
					$result = $dbo->query( $sql );
					if( false === $result ) {
						return false;
					}
				}
			}
		}
		// ファイル関連付け
		if( is_array($this->fileIdArray_org) ) {
			// 旧関連ファイルで新にないものは削除する
			foreach( $this->fileIdArray_org as $key => $fileId ) {
				if( strlen(trim($fileId)) > 0 ) {
					if( !is_array($this->fileIdArray) || !in_array($fileId,$this->fileIdArray) ) {
						$fileObject	= spider_Controller::createObject('file_DaoFileBin');
						if( $dbo->loadById( $fileObject, $fileId ) ) {
							// 読み込めたら削除
							$fileObject->deleteFileAll( $request );
							$dbo->delete($fileObject);
						}
						$sql	= 'DELETE FROM '.TABLE_NAME_SHOPPING_PRODUCT_FILE
							.' WHERE product_id='.$dbo->quote($this->product_id)
							.' AND file_id='.$dbo->quote($fileId);
						$result = $dbo->query( $sql );
						if( false === $result ) {
							return false;
						}
					}
				}
			}
		}
		if( is_array($this->fileIdArray) ) {
			// 旧関連ファイルで新にあるものを登録する
			foreach( $this->fileIdArray as $key => $fileId ) {
				if( strlen(trim($fileId)) > 0 ) {
					if( !is_array($this->fileIdArray_org) || !in_array($fileId,$this->fileIdArray_org) ) {
						$sql	= 'INSERT INTO '.TABLE_NAME_SHOPPING_PRODUCT_FILE.'(file_id,product_id,file_class,order_number) VALUES ('
							.$dbo->quote($fileId).','.$dbo->quote($this->product_id).',0'.','.$key	.' )';
						$result = $dbo->query( $sql );
						if( false === $result ) {
							return false;
						}
					}
				}
			}
		}
		// 商品関連付けをインサートしなおす
		$sql	= 'DELETE FROM '.TABLE_NAME_SHOPPING_PRODUCT_RELATION
		.' WHERE product_id='.$dbo->quote($this->product_id);
		$result = $dbo->query( $sql );
		if( false === $result ) {
			return false;
		}
		if( is_array($this->relatedProductIdArray) ) {
			foreach( $this->relatedProductIdArray as $key => $relatedProductId ) {
				if( strlen(trim($relatedProductId)) > 0 ) {
					$sql	= 'INSERT INTO '.TABLE_NAME_SHOPPING_PRODUCT_RELATION
					.'(product_id,related_product_id,display_order) VALUES ('
					.$dbo->quote($this->product_id).','.$dbo->quote($relatedProductId).','.$key.' )';
					$result = $dbo->query( $sql );
					if( false === $result ) {
						return false;
					}
				}
			}
		}
		if( $this->status_flag >= 200 || $this->status_flag < 100 ) {
			// 削除の場合
			if ( $this->status_flag >= 200 ) {
				// 削除の場合、商品IDをSDELETED00000000の書式で連番変更する
				$productIdNew = 'SDELETED'.sprintf('%08d',$this->product_number);
				// 商品IDをSDELETED00000000の書式で連番変更する
				$sql	= 'UPDATE '.TABLE_NAME_SHOPPING_PRODUCT.' SET '
					.' product_id='.$dbo->quote($productIdNew)
					.' WHERE product_number='.$this->product_number;
				$dbo->query($sql);
				// 関連販売単位の関連付けを全て変更
				$sql  = 'UPDATE '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.' SET '
				.' product_id='.$dbo->quote($productIdNew)
				.' WHERE product_id='.$dbo->quote($this->product_id);
				$dbo->query($sql);
				if( false === $result ) {
					return false;
				}
			}
			// 紐づいている販売単位の商品IDと状態を同期する
			foreach ( $this->unitObjectArray as $unitObject ) {
				$unitObject->status_flag	= $this->status_flag;
				$unitObject->updated_date	= date('Y-m-d H:i:s');
				if( $dbo->update($unitObject,false) ) {
				} else {
					return false;
				}
			}
		}
		return true;
	}
	/**
	 * 設定された値の妥当性検査を行います
	 */
	function validate( & $request ) {
		$dbo	= $request->getAttribute( 'dbo' );
		// 商品ID
		if( strlen(trim($this->product_id)) == 0 ) {
		} else if( preg_match('/^[0-9a-zA-Z\\_]{1,32}$/',$this->product_id) == 0 ) {
			$request->addLocaledError('shopping.error.dao.product.invalidid',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else if( preg_match('/^SDELETED[0-9]{8}$/',$this->product_id) > 0 ) {
			$request->addLocaledError('shopping.error.dao.product.reservedid',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else {
			$compareShoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
			if( $dbo->loadById( $compareShoppingProductObject, $this->product_id ) ) {
				if( $this->product_number != $compareShoppingProductObject->product_number ) {
					if( $compareShoppingProductObject->status_flag < 200 ) {
						$request->addLocaledError('shopping.error.dao.product.duplicatedid',SPIDER_LOG_LEVEL_ERROR,array(''));
					} else if( is_numeric($compareShoppingProductObject->product_number) ) {
						$compareShoppingProductObject->status_flag	= 255;
						$compareShoppingProductObject->updated_date	= date('Y-m-d H:i:s');
						$dbo->update($compareShoppingProductObject,false);
					}
				}
			}
		}
		// 商品名
		if( strlen(trim($this->product_name)) == 0 ) {
			$request->addLocaledError('shopping.error.dao.product.requirename',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else if( strlen(trim($this->product_name)) > 240 ) {
			$request->addLocaledError('shopping.error.dao.product.invalidname',SPIDER_LOG_LEVEL_ERROR,array(''));
		}
		// 商品名フリガナ
		if( strlen(trim($this->product_kana)) == 0 ) {
		} else if( strlen(trim($this->product_kana)) > 240 ) {
			$request->addLocaledError('shopping.error.dao.product.invalidkana',SPIDER_LOG_LEVEL_ERROR,array(''));
		}
		// 配送種別
		$this->delivery_type	= mb_convert_kana($this->delivery_type,'a');
		if( !array_key_exists( $this->delivery_type, $GLOBALS['SHOPPING_DELIVERY_TYPE_HASH'] ) ) {
			$this->delivery_type	= '0';
		}
		// カレンダータイプ
		$this->calendar_type	= mb_convert_kana($this->calendar_type,'a');
		if( strlen(trim($this->calendar_type)) == 0 ) {
			$this->calendar_type	= '1';
		} else if( $this->calendar_type != '1' ){
			$this->calendar_type	= '0';
		}

		// 公開設定（閲覧）
		if ( !is_array($this->memberViewableArray) ) {
			$memberViewableArray = array();
			if ( strlen($this->memberViewableArray)>0 ) {
				array_push($memberViewableArray,$this->memberViewableArray);
			}
			$this->memberViewableArray = $memberViewableArray;
		}
		foreach ( $this->memberViewableArray as $key=>$value ) {
			if( strlen($value) > 0 ) {
				if( preg_match('/^[0-9]{1,2}$/',$value) == 0 ) {
					$isExist = false;
					foreach ( $GLOBALS['MEMBER_MEMBER_CLASS_HASH'] as $mkey=>$mvalue ) {
						if ( $mvalue==$value ) {
							$this->memberViewableArray[$key] = $mkey;
							$isExist = true;
							break;
						}
					}
					if ( !$isExist ) {
						$request->addLocaledError('shopping.error.dao.product.invalidviewmemberclass',SPIDER_LOG_LEVEL_ERROR,array($value));
						break;
					}			
				} else {
					if ( !array_key_exists($value,$GLOBALS['MEMBER_MEMBER_CLASS_HASH']) ) {
						$request->addLocaledError('shopping.error.dao.product.invalidviewmemberclass',SPIDER_LOG_LEVEL_ERROR,array($value));
						break;
					}
				}
			}
		}
		// 公開設定（購入）
		if ( !is_array($this->memberPurchasableArray) ) {
			$memberPurchasableArray = array();
			if ( strlen($this->memberPurchasableArray)>0 ) {
				array_push($memberPurchasableArray,$this->memberPurchasableArray);
			}
			$this->memberPurchasableArray = $memberPurchasableArray;
		}
		foreach ( $this->memberPurchasableArray as $key=>$value ) {
			if( strlen($value) > 0 ) {
				if( preg_match('/^[0-9]{1,2}$/',$value) == 0 ) {
					$isExist = false;
					foreach ( $GLOBALS['MEMBER_MEMBER_CLASS_HASH'] as $mkey=>$mvalue ) {
						if ( $mvalue==$value ) {
							$this->memberPurchasableArray[$key] = $mkey;
							$isExist = true;
							break;
						}
					}
					if ( !$isExist ) {
						$request->addLocaledError('shopping.error.dao.product.invalidpurchasememberclass',SPIDER_LOG_LEVEL_ERROR,array($value));
						break;
					}			
				} else {
					if ( !array_key_exists($value,$GLOBALS['MEMBER_MEMBER_CLASS_HASH']) ) {
						$request->addLocaledError('shopping.error.dao.product.invalidpurchasememberclass',SPIDER_LOG_LEVEL_ERROR,array($value));
						break;
					}
				}
			}
		}
		if( !$request->isError() ) {
			$keyOpen	= 1;
			foreach ( $GLOBALS['MEMBER_MEMBER_CLASS_HASH'] as $key=>$value ) {
				if( is_array($this->memberViewableArray) && in_array($key,$this->memberViewableArray) ) {
					$this->member_viewable	= $this->member_viewable | $keyOpen;
				}
				if( is_array($this->memberPurchasableArray) && in_array($key,$this->memberPurchasableArray) ) {
					$this->member_purchasable	= $this->member_purchasable | $keyOpen;
				}
				$keyOpen = $keyOpen * 2;
			}
		}

		$this->order_number	= mb_convert_kana($this->order_number,'a');
		if( strlen(trim($this->order_number)) == 0 ) {
			$this->order_number	= $this->product_number;
		} else if( preg_match('/^[0-9]{1,4}$/',$this->order_number) == 0 ) {
			$request->addLocaledError('shopping.error.dao.product.invalidorder',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 検索キーワード
		if( strlen(trim($this->keywords)) == 0 ) {
		} else if( strlen(trim($this->keywords)) > 240 ) {
			$request->addLocaledError('shopping.error.dao.product.invalidkeyword',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 商品キャッチコピー
		if( strlen(trim($this->catch_copy)) == 0 ) {
		} else if( strlen(trim($this->catch_copy)) > 240 ) {
			$request->addLocaledError('shopping.error.dao.product.invalidcatchcopy',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 商品概要
		$this->description	= str_replace("\r\n","\n",$this->description);
		$this->description	= str_replace("\r","\n",$this->description);
		if( strlen(trim($this->description)) == 0 ) {
		} else if( strlen(trim($this->description)) > 3000 ) {
			$request->addLocaledError('shopping.error.dao.product.invaliddescription',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 商品詳細
		$this->detail_comment	= str_replace("\r\n","\n",$this->detail_comment);
		$this->detail_comment	= str_replace("\r","\n",$this->detail_comment);
		if( strlen(trim($this->detail_comment)) == 0 ) {
		} else if( strlen(trim($this->detail_comment)) > 15000 ) {
			$request->addLocaledError('shopping.error.dao.product.invaliddetail',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 卸業者名
		if( strlen(trim($this->wholesaler_name)) == 0 ) {
		} else if( strlen(trim($this->wholesaler_name)) > 240 ) {
			$request->addLocaledError('shopping.error.dao.product.invalidwholesaler',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 卸業者発注用メールアドレス
		if( strlen(trim($this->wholesaler_email)) == 0 ) {
		} else if( strlen(trim($this->wholesaler_email)) > 80 ) {
			$request->addLocaledError('shopping.error.dao.product.invalidwholesaleremail',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 卸業者メモ
		if( strlen(trim($this->wholesaler_note)) == 0 ) {
		} else if( strlen(trim($this->wholesaler_note)) > 1500 ) {
			$request->addLocaledError('shopping.error.dao.product.invalidwholesalermemo',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 公式URL
		if( strlen(trim($this->product_url)) == 0 ) {
		} else if( strlen(trim($this->product_url)) > 80 ) {
			$request->addLocaledError('shopping.error.dao.product.invalidurl',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// 表記カウント単位
		if( strlen(trim($this->unit_string)) == 0 ) {
		} else if( strlen(trim($this->unit_string)) > 32 ) {
			$request->addLocaledError('shopping.error.dao.product.invalidunitstring',SPIDER_LOG_LEVEL_ERROR,array());
		}
		// オプション妥当性検査
		for( $num=1; $num<=5; $num++ ){
			// オプション名
			$varName	= 'option'.$num.'_name';
			if( strlen(trim($this->$varName)) == 0 ) {
			} else if( strlen(trim($this->$varName)) > 180 ) {
				$request->addLocaledError('shopping.error.dao.product.invalidoptionname',SPIDER_LOG_LEVEL_ERROR,array($num));
			}
			// オプションURL
			$varName	= 'option'.$num.'_url';
			if( strlen(trim($this->$varName)) == 0 ) {
			} else if( strlen(trim($this->$varName)) > 180 ) {
				$request->addLocaledError('shopping.error.dao.product.invalidoptionurl',SPIDER_LOG_LEVEL_ERROR,array($num));
			}
			// オプション計算フラグ
			$varName	= 'option'.$num.'_calculate';
			if( strlen(trim($this->$varName)) != '1' ) {
				$this->$varName	= 0;
			}
		}
		
		// 関連ID
		if( strlen(trim($this->search_data_id)) == 0 ) {
		} else if( strlen(trim($this->search_data_id)) > 32 ) {
			$request->addLocaledError('shopping.error.dao.product.invalidrelatedid',SPIDER_LOG_LEVEL_ERROR,array());
		}
		
		$this->updated_date		= str_replace('/','-',$this->updated_date);
		$this->registered_date	= str_replace('/','-',$this->registered_date);
		
		return true;
	}
	/**
	 * サーバー上の任意フォルダ内にプロダクトID_01～05.jpgファイルがあったら登録します
	 * @param spider_HttpRequest &$request spider_HttpRequestオブジェクト参照
	 * @param system_login_AbstractUser &$abstractUser 実行ユーザーオブジェクト参照
	 * @param string $targetFolderUri ファイル格納フォルダURI
	 * @param boolean $override 上書き登録する場合はtrue,falseの場合は既に画像登録があるものには登録しない
	 */
	function importImageFiles( & $request, & $abstractUser, $targetFolderUri, $override=false ) {
		$dbo	= $request->getAttribute( 'dbo' );
		if( preg_match('/\\/$/',$targetFolderUri) == 0 ) {
			$targetFolderUri	.= '/';
		}
		if( !is_array($this->fileIdArray) ) {
			$this->fileIdArray	= array();
		}
		for( $i=1; $i<=10; $i++ ) {
			if( $override === false && isset($this->fileIdArray[$i-1])
			&& strlen(trim($this->fileIdArray[$i-1])) > 0 ){
				// 上書き指定出ない場合にファイル登録が既にあるなら次のループへ
				continue;
			}
			$imageFileName	= $this->product_id.'_'.sprintf('%02d',$i).'.jpg';
			$fileUri		= $targetFolderUri.$imageFileName;
			$registFilePath	= system_DataFileWriter::getFilePathOnAnyHost( $request, $fileUri, 'public' );
			if( is_null($registFilePath) || strlen($registFilePath) == 0 ){
				$imageFileName	= $this->product_id.'_'.sprintf('%02d',$i).'.JPG';
				$fileUri		= $targetFolderUri.$imageFileName;
				$registFilePath	= system_DataFileWriter::getFilePathOnAnyHost( $request, $fileUri, 'public' );
			}
			if( !is_null($registFilePath) && strlen($registFilePath) > 1 ) {
				// ファイルが分散サーバいずれかに存在すれば処理
				$deleteFileId	= $this->fileIdArray[($i-1)];
				if( strlen($deleteFileId) > 0 ) {
					$fileBinObject	= spider_Controller::createObject('file_DaoFileBin');
					if( $dbo->loadById( $fileBinObject, $deleteFileId ) ) {
						if($fileBinObject->deleteFileAll( $request ) ) {
							$dbo->delete( $fileBinObject );
						} else {
							$request->addLocaledError('system.error.common.file.delete',SPIDER_LOG_LEVEL_ERROR,array($imageFileName));
						}
					}
				}
				// 新しいファイルを登録
				$fileBinObject	= spider_Controller::createObject('file_DaoFileBin');
				$fileBinObject->file_name		= $imageFileName;
				$fileBinObject->file_size		= filesize( $registFilePath );
				$fileBinObject->extension		= 'jpg';
				$fileBinObject->mime_type		= 'image/jpeg';
				$fileBinObject->owner_id		= $abstractUser->getUniqueId();
				$fileBinObject->modifier_id		= $abstractUser->getUniqueId();
				$fileBinObject->updated_date	= date('Y-m-d H:i:s');
				$fileBinObject->registered_date	= date('Y-m-d H:i:s');
				$fileBinObject->file_id			= null;
				if( false !== $imageInfoHash = $fileBinObject->getImageInfo( $request ) ) {
					// 画像ファイルで情報を取得できた場合
					if( $imageInfoHash[0] > SHOPPING_PRODUCT_IMAGE_MAX_WIDTH
						|| $imageInfoHash[1] > SHOPPING_PRODUCT_IMAGE_MAX_HEIGHT ) {
						// 幅か高さがshoppingパッケージ設定上限値を超えているならリサイズ
						if( util_File::resizeImage( $registFilePath, $registFilePath, SHOPPING_PRODUCT_IMAGE_MAX_WIDTH, SHOPPING_PRODUCT_IMAGE_MAX_HEIGHT, 'ffffff' ) ) {
						} else {
							$request->addLocaledError('system.error.common.file.resize',SPIDER_LOG_LEVEL_ERROR,array($imageFileName));
							break;
						}
					}
				}
				// データベース登録
				if( $dbo->setNextId( $fileBinObject, 'FDAAAA{num:18}') ) {
					if( $dbo->insert( $fileBinObject ) ) {
						// インサートに成功したらファイルを保存フォルダに移動する
						if( $saveRootPath = $fileBinObject->getSaveRootPath( $request, true ) ) {
							// 保存フォルダ作成に成功したらファイルを保存パスに移動
							if( @copy( $registFilePath, $fileBinObject->getOriginalFilePath( $request ) ) ) {
								@chmod($fileBinObject->getOriginalFilePath( $request ),0666);
								if( is_writable($this->cacheContentPath) ) {
									@unlink($registFilePath);
								}
								$this->fileIdArray[($i-1)]	= $fileBinObject->file_id;
							} else {
								$request->addLocaledError('system.error.common.file.write',SPIDER_LOG_LEVEL_ERROR,array($imageFileName));
								break;
							}
						}
					} else {
						$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array($imageFileName));
						break;
					}
				} else {
					$request->addLocaledError('database2.error.setnextid',SPIDER_LOG_LEVEL_FATAL,array($imageFileName));
					break;
				}
			} else {
				// ファイルが存在しない場合何もしない
			}
		}
		if( $request->isError() ) {
			return false;
		} else {
			return true;
		}
	}
	//
	// AbstractDataのオーバーライドメソッド
	//
	/**
	 * オブジェクト情報を指定された順序のCSV行にして取得します。
	 */
	function getCsvString( &$request, $columnOrderHash, $quote=true ) {
		// 販売単位のカラムも指定されているか確認
		$includeUnitInformation	= false;
		foreach ( $columnOrderHash as $varName => $order_number ) {
			if( preg_match( '/^unit\\_/', $varName ) > 0 ) {
				$includeUnitInformation	= true;
				break;
			}
		}
		if( $includeUnitInformation ) {
			// 販売単位情報も含む場合の処理
			$unitLineArray	= array();
			foreach( $this->unitObjectArray as $unitObject ) {
				$columnValueArray	= array();
				foreach ( $columnOrderHash as $varName=>$order_number ) {
					$value	= '';
					if( preg_match( '/^unit\\_/', $varName ) > 0 ) {
						// 販売単位の値
						$varName	= preg_replace('/^unit\\_/','',$varName);
						$value	= $unitObject->getColumnString( $varName, $quote );
					} else {
						// 商品の値
						$value	= $this->getColumnString( $request, $varName, $quote );
					}
					$columnValueArray[$order_number]	= $value;
				}
				// キーでソート
				ksort( $columnValueArray );
				// カンマで結合
				$str	= implode(',',$columnValueArray);
				array_push($unitLineArray,$str);
			}
			return implode("\n",$unitLineArray)."\n";
		} else {
			// 販売単位情報を含まない場合は親メソッド
			foreach ( $columnOrderHash as $varName=>$order_number ) {
				$value	= $this->getColumnString( $request, $varName, $quote );
				$columnValueArray[$order_number]	= $value;
			}
			// キーでソート
			ksort( $columnValueArray );
			// カンマで結合
			return implode(',',$columnValueArray)."\n";
		}
	}
	/**
	 * CSVダウンロードの為のカラム取得メソッド
	 * 項目キーから値を取得します
	 */
	function getColumnString( &$request, $key, $quote=true, $filter=null ) {
		$returnValue	= $this->$key;
		if( 'member_viewable' == $key || 'member_purchasable' == $key ) {
			// 公開設定は、該当の会員種別の文字列で返す
			$returnStrings	= '';
			$memberClassNameArray	= array();
			$memberOpenFlagStr		= sprintf('%016b',$returnValue);
			$keyCol	= 0;
			foreach ( $GLOBALS['MEMBER_MEMBER_CLASS_HASH'] as $key=>$value ) {
				if ( substr($memberOpenFlagStr,15-$keyCol,1) == '1' ) {
					array_push($memberClassNameArray,$value);
				}
				$keyCol++;
			}
			$returnStrings = implode('/',$memberClassNameArray);
			if( !is_null($filter) && strlen($filter) ){
				$returnStrings	= mb_convert_kana($returnStrings,$filter);
			}
			if( $quote ){
				$returnStrings	= '"'.str_replace('"','""',$returnStrings).'"';
			}
			return $returnStrings;
		} else if( 'categoryIdArray' == $key ) {
			// カテゴリIDの場合は名前でダウンロードに変更
			$dbo	= $request->getAttribute('dbo');
			$categoryNameArray	= array();
			foreach( $this->categoryIdArray as $categoryId ) {
				$categoryObject	= spider_Controller::createObject('shopping_DaoShoppingCategory');
				if( $dbo->loadById($categoryObject,$categoryId,false) ) {
					$categoryObject->_load_optional_data( $dbo, false, true );
					array_push($categoryNameArray,$categoryObject->getCategoryFullName(' - '));
				}
			}
			$returnStrings	= implode(',',$categoryNameArray);
			if( !is_null($filter) && strlen($filter) ){
				$returnStrings	= mb_convert_kana($returnStrings,$filter);
			}
			if( $quote ){
				$returnStrings	= '"'.str_replace('"','""',$returnStrings).'"';
			}
			return $returnStrings;
		} else {
			return parent::getColumnString( $key, $quote, $filter );
		}
	}
	/**
	 * 渡されたAbstractDataオブジェクトに対する編集権限があるか確認します
	 * @param &$request spider_HttpRequestオブジェクト
	 * @param $abstractUser system_login_AbstractUser実装クラスインスタンス
	 */
	function canEditData( & $request, $abstractUser ) {
		if( is_a($abstractUser,'system_login_UserAdministrator') ) {
			// システム管理者ならtrue
			return true;
		} else if( is_a($abstractUser,'admin_DaoAdminMember') ) {
			// adminパッケージのログインユーザの場合
			return true;
		} else if( is_a($abstractUser,'member_DaoMember') ) {
			// memberパッケージのログインユーザなら自分自身はtrue
			if( $this->owner_id == $abstractUser->member_id ) {
				return true;
			} else {
				return false;
			}
		} else {
			// パッケージユーザ以外は編集不可
			return false;
		}
	}
	/**
	 * 渡されたAbstractDataオブジェクトのステータスフラグの編集権限があるか確認します
	 * @param &$request spider_HttpRequestオブジェクト
	 * @param $abstractUser system_login_AbstractUser実装クラスインスタンス
	 */
	function canEditStatus( & $request, $abstractUser ) {
		if( is_a($abstractUser,'system_login_UserAdministrator') ) {
			// システム管理者ならtrue
			return true;
		} else if( is_a($abstractUser,'admin_DaoAdminMember') ) {
			// adminパッケージのログインユーザの場合
			return true;
		} else if( is_a($abstractUser,'member_DaoMember') ) {
			// memberパッケージのログインユーザの場合
			if ( $this->status_flag_org == 0 ) {
				// ステータスが新規の場合、編集不可
				return false;
			} else if ( $this->status_flag_org == 101 || $this->status_flag_org == 91 ) {
				// 変更前のステータスが掲載中、又は非公開の場合、新規以外のステータスへ編集可能
				if ( $this->status_flag == 0 ) {
					return false;
				} else {
					return true;
				}
			} else if ( $this->status_flag_org > 200 ) {
				// ステータスが削除の場合、編集不可
				return false;
			} else {
				return false;
			}
		} else {
			// パッケージユーザ以外は編集不可
			return false;
		}
	}
	//
	// オプション関連
	//
	/**
	 * 本オブジェクト配下の販売単位が固有の注文オプションを保持しているか確認
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @return boolean 販売単位が固有オブジェクトを保持しているならtrue
	 */
	function hasUniqueUnitOption( & $request ) {
		if( is_null($this->unitObjectArray)
		|| !is_array($this->unitObjectArray)
		|| count($this->unitObjectArray) == 0 ) {
			$dbo	= $request->getAttribute('dbo');
			$this->loadRelatedUnitObjects( $dbo );
		}
		foreach( $this->unitObjectArray as $unitObject ) {
			if( $unitObject->hasUniqueOption() ) {
				return true;
			}
		}
		return false;
	}
	/**
	 * 本オブジェクトの設定から注文オプションオブジェクトの配列を取得
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @return array shopping_DaoShoppingOrderOption拡張実装クラスオブジェクトの配列
	 */
	function getOrderOptionObjectArray( & $request ) {
		$orderOptionObjectArray	= array();
		for( $num=1; $num<=5; $num++ ) {
			$fieldNameOptionName	= 'option'.$num.'_name';
			$fieldNameOptionItems	= 'option'.$num.'_items';
			$fieldNameOptionExp	= 'option'.$num.'_explanation';
			$fieldNameOptionCalc	= 'option'.$num.'_calculate';
			$optionName		= trim($this->$fieldNameOptionName);
			$optionItems	= trim($this->$fieldNameOptionItems);
			if( strlen($optionName) > 0 ) {
				spider_Controller::loadClassDefinition('shopping_DaoShoppingOrderOption');
				$orderOptionObject	= null;
				if( $orderOptionObject = shopping_DaoShoppingOrderOption::createProductOptionObject( $optionName, $optionItems ) ) {
					$orderOptionObject->optionNumber	= $num-1;
					$orderOptionObject->item_order		= $num-1;
					$orderOptionObject->required		= true;
					$orderOptionObject->calculate_flag		= $this->$fieldNameOptionCalc;
					$orderOptionObject->explanation		= $this->$fieldNameOptionExp;
					$orderOptionObjectArray[$num-1]		= $orderOptionObject;
				}
			}
		}
		ksort($orderOptionObjectArray);
		return $orderOptionObjectArray;
	}
	/**
	 * 検索パッケージ連携機能：設定されている検索データIDから検索データを読み込んでメンバに設定
	 * @param $request spider_HttpRequestオブジェクト参照
	 * @param $loginUserObject system_login_AbstractUserクラスオブジェクト。渡された場合は編集権限の確認をおこなう
	 * @return boolean 成功ならtrue
	 */
	function loadSearchData( & $request, $loginUserObject=null ) {
		// 検索パッケージ連携
		$dbo	= $request->getAttribute('dbo');
		if( strlen(trim($this->search_data_id)) > 0 ) {
			try{
				$searchDataObject	= spider_Controller::createObject('search_DaoSearchData');
			} catch ( Exception $exception ) {
				$request->addLocaledError('shopping.error.search.noinstalled',SPIDER_LOG_LEVEL_ERROR,array());
				return false;
			}
			if( $dbo->loadById($searchDataObject,$this->search_data_id) ) {
				if( is_null($loginUserObject) ) {
				} else if( !is_a($loginUserObject,'system_login_AbstractUser') ) {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				} else {
					if( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel()
					&& $searchDataObject->owner_id != $loginUserObject->getUniqueId() ) {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
					}
				}
			} else {
				$request->addLocaledError('shopping.error.search.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		} else {
			$this->searchDataObject	= null;
			$this->search_data_id	= null;
			return true;
		}
		if( $request->isError() ) {
			$this->searchDataObject	= null;
			$this->search_data_id	= null;
			return false;
		} else {
			$this->searchDataObject	= $searchDataObject;
			return true;
		}
	}
	/**
	 * 表示画像のURIを取得
	 */
	function getImageUri( & $request, $imageNumber=0, $maxWidth=null, $maxHeight=null ) {
		$fileId	= null;
		if( isset($this->fileIdArray[$imageNumber]) ) {
			$fileId	= $this->fileIdArray[$imageNumber];
		}
		if( is_null($fileId) || strlen($fileId) == 0 ) {
			return false;
		}
		spider_Controller::loadClassDefinition('file_DaoFileBin');
		return file_DaoFileBin::getPublicCacheUri( $request,$fileId,$maxWidth,$maxHeight);
	}
	//
	// 非推奨メソッド
	//
	/**
	 * 追加情報を読み込み
	 * @deprecated
	 */
	function _load_optional_data( $dbo ) {
		return $this->loadRelation( $dbo );
	}
}
?>