<?php
/*
 * member/member/reject/Form.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 編集フォーム表示用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_reject_Form extends system_login_ModuleBase {
	function member_member_reject_Form() {
		array_push($this->require_module_array,'database2.Connect');
		array_push( $this->require_module_array, 'member.mail.reject.LoadList' );
	}
	function execute( & $request ) {
		
		$dbo					= $request->getAttribute( 'dbo' );
		$memberId				= stripslashes( $_GET['mi'] );
		$sessionObjectName		= 'member.member.reject.modify.object.'.$memberId;
		$sessionConfirmName		= 'member.member.reject.modify.confirm.'.$memberId;
		$memberObject			= $request->getSession($sessionObjectName);
		$compareMemberObject	= spider_Controller::createObject('member_DaoMember');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$request->removeSession($sessionConfirmName);
		
		if( get_class($compareMemberObject) == get_class($memberObject) ){
			// セッションに登録済みならそのまま利用する
		} else {
			// セッションにないなら作成する
			$memberObject			= spider_Controller::createObject('member_DaoMember');
			if( strlen(trim($memberId)) > 0 ) {
				// IDが指定されているなら編集のため読み込み
				if( $dbo->loadById( $memberObject, $memberId ) ){
					// 読み込めたら編集可能か確認
					if( $memberObject->canEditData( $request, $loginUserObject ) ) {
					} else {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				} else {
					$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		if( !$request->isError() ) {
			// member_idが設定済みならロック処理
			if( strlen($memberObject->member_id ) > 0 ) {
				if( false === $this->lockData( $request, $memberObject ) ) {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
		}
		
		$request->setAttribute('member.member.reject.memberObject',$memberObject);
		
	}
}
?>