<?php
/*
 * member/member/delete/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員削除確認用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage delete 削除パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_delete_Confirm extends system_login_ModuleBase {
	function member_member_delete_Confirm(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$memberId				= $_GET['mi'];
		$target					= $_GET['target'];
		$memberIdArray		= array();
		$memberObjectArray	= array();
		if( 'selectedlist' == $target ) {
			$sessionSelectedHash	= $request->getSession( MEMBER_SESSION_NAME_SELECTED_LIST );
			if( !is_array($sessionSelectedHash) || count( $sessionSelectedHash ) == 0 ) {
				$request->addLocaledError('member.error.common.selectmember',SPIDER_LOG_LEVEL_FATAL,array(''));
			} else {
				foreach( $sessionSelectedHash as $memberId=>$member_name ) {
					$memberObject			= spider_Controller::createObject('member_DaoMember');
					if( strlen(trim($memberId)) > 0 ) {
						// IDが指定されているなら編集のため読み込み
						if( $dbo->loadById($memberObject,$memberId) ){
							array_push( $memberObjectArray , $memberObject );
						} else {
							$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
						}
					}
				}
			}
		} else {
			$memberObject			= spider_Controller::createObject('member_DaoMember');
			if( strlen(trim($memberId)) > 0 ) {
				// IDが指定されているなら編集のため読み込み
				if( $dbo->loadById($memberObject,$memberId) ){
					array_push( $memberObjectArray , $memberObject );
				} else {
					$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				$request->addLocaledError('member.error.common.selectmember',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}

		$request->setAttribute('member.member.delete.target',$target);
		$request->setAttribute('member.member.delete.member_object_array',$memberObjectArray);

	}
}
?>