<?php
/*
 * member/member/correspond/comment/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(dirname(__FILE__))))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 ポイント編集実行用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_correspond_comment_Execute extends system_login_ModuleBase {
	function member_member_correspond_comment_Execute() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$correspondId				= trim(stripslashes( $_GET['mci'] ));
		$commentNumber				= trim(stripslashes( $_GET['mcmn'] ));
		$sessionObjectName			= 'member.member.correspond.comment.modify.object.'.$commentNumber.'.'.$correspondId;
		$sessionConfirmName			= 'member.member.correspond.comment.modify.confirm.'.$commentNumber.'.'.$correspondId;
		$memberObject				= spider_Controller::createObject('member_DaoMember');
		$correspondObject			= spider_Controller::createObject('member_DaoMemberCorrespond');
		$correspondCommentObject	= $request->getSession($sessionObjectName);
		$compareCommentObject		= spider_Controller::createObject('member_DaoMemberCorrespondComment');
		$loginUserObject			= $this->getLoginUserObject( $request );
		$comfirmResult				= $request->getSession($sessionConfirmName);

		if( 'OK' != $comfirmResult ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( get_class($correspondCommentObject) != get_class($compareCommentObject) ){
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			if( !$dbo->loadById($correspondObject,$correspondCommentObject->correspond_id) ) {
				$request->addLocaledError('member.error.correspond.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				return;
			} else if( !$dbo->loadById($memberObject,$correspondObject->member_id) ) {
				$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				return;
			}
			// 投降後の状態と更新日時を設定
			$correspondObject->status_flag			= $correspondCommentObject->status_flag;
			$correspondObject->correspond_date		= $correspondCommentObject->correspond_date;
			// 変更者のIDを登録
			$correspondCommentObject->modifier_id	= $loginUserObject->getUniqueId();
			if( strlen(trim($correspondCommentObject->comment_number)) > 0 ) {
				// IDが設定済みなら更新
				$correspondCommentObject->updated_date	= date('Y-m-d H:i:s');
				if( $dbo->update($correspondCommentObject,false) ) {
				} else {
					$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(""));
				}
			} else {
				// IDがないならインサート
				$correspondCommentObject->modifier_id		= $loginUserObject->getUniqueId();
				$correspondCommentObject->owner_id			= $loginUserObject->getUniqueId();
				$correspondCommentObject->updated_date		= date('Y-m-d H:i:s');
				$correspondCommentObject->registered_date	= date('Y-m-d H:i:s');
				if( $dbo->insert($correspondCommentObject) ){
				} else {
					$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array(""));
				}
			}
			// エラーがないなら対応の状態と対応日時を更新する
			if( !$dbo->update($correspondObject,false) ) {
				$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(""));
			}
		}
		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('member.member.correspond.comment.memberObject',$memberObject);
		$request->setAttribute('member.member.correspond.comment.correspondObject',$correspondObject);
		$request->setAttribute('member.member.correspond.comment.correspondCommentObject',$correspondCommentObject);
	}
}
?>