<?php
/*
 * member/member/correspond/Form.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 ポイント編集フォーム表示用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_correspond_Form extends system_login_ModuleBase {
	function member_member_correspond_Form() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$memberId					= trim(stripslashes( $_GET['mi'] ));
		$correspondId				= trim(stripslashes( $_GET['mci'] ));
		$sessionObjectName			= 'member.member.correspond.modify.object.'.$memberId.'.'.$correspondId;
		$sessionConfirmName			= 'member.member.correspond.modify.confirm.'.$memberId.'.'.$correspondId;
		$memberObject				= spider_Controller::createObject('member_DaoMember');
		$correspondObject			= $request->getSession($sessionObjectName);
		$compareCorrespondObject	= spider_Controller::createObject('member_DaoMemberCorrespond');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$request->removeSession($sessionConfirmName);
		
		if( get_class($compareCorrespondObject) == get_class($correspondObject) ){
			// セッションに登録済みならそのまま利用する
		} else {
			// セッションにないなら作成する
			$correspondObject			= spider_Controller::createObject('member_DaoMemberCorrespond');
			if( strlen(trim($correspondId)) > 0 ) {
				// IDが指定されているなら編集のため読み込み
				if( $dbo->loadById( $correspondObject, $correspondId ) ){
					// 読み込めたら編集可能か確認
					if( $correspondObject->canEditData( $request, $loginUserObject ) ) {
						// 対応履歴が読み込めたら会員情報を読み込み
						if( !$dbo->loadById($memberObject,$correspondObject->member_id) ) {
							$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
						}
					} else {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				} else {
					$request->addLocaledError('member.error.correspond.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				// IDが指定されていないなら会員情報を確認
				if( strlen($memberId) == 0 ) {
					$request->addLocaledError('member.error.common.selectmember',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else if( !$dbo->loadById($memberObject,$memberId) ) {
					$request->addLocaledError('member.error.common.membernotfound',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else {
					// 会員情報があるなら処理続行
					$correspondObject->member_id	= $memberObject->member_id;
					// 現在の日時を入力
					$correspondObject->start_date		= date('Y-m-d H:i');
					$correspondObject->correspond_date	= date('Y-m-d H:i');
				}
			}
		}
		if( !$request->isError() ) {
			// correspond_idが設定済みならロック処理
			if( strlen($correspondObject->correspond_id ) > 0 ) {
				if( false === $this->lockData( $request, $correspondObject ) ) {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
		}
		
		$request->setAttribute('member.member.correspond.memberObject',$memberObject);
		$request->setAttribute('member.member.correspond.correspondObject',$correspondObject);
	}
}
?>