<?php
/*
 * member/member/LoadPackageSummery.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員に紐づいたパッケージ情報ページURI読み込みアクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.00
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.3
 */
class member_member_LoadPackageSummery extends system_login_ModuleBase {
	function member_member_LoadPackageSummery() {
		array_push($this->require_module_array,'system.login.Require');
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$packageSummeryUriArray	= array();
		$targetDir				= SPIDER_BASE_PATH;
		if ($curDh = opendir($targetDir)) {
			while (($fileName = readdir($curDh)) !== false) {
				if( preg_match('/^\\./',$fileName) == 0
					&& 'js' != $fileName && 'css' != $fileName && 'upload' != $fileName
					&& SYSTEM_DIR_NAME_ADMIN_PANEL != $fileName
				) {
					$absolutePath	= $targetDir.DIRECTORY_SEPARATOR.$fileName;
					if( preg_match('/[dD][iI][rR]/',filetype($absolutePath) ) > 0 ) {
						$summaryPath	= $absolutePath.DIRECTORY_SEPARATOR.'member.php';
						if( file_exists($summaryPath) ) {
							// サマリーファイルが存在するならURIを追加します
							$summaryUrl		= '/'.$fileName.'/member.php';
							$packageSummeryUriArray[$fileName]	= $summaryUrl;
						}
					}
				}
			}
			closedir($curDh);
		}
		$httpRequestObject	= spider_Controller::createObject('util_HttpRequest');
		$request->setAttribute('member.member.httpRequestObject',$httpRequestObject);
		$request->setAttribute('member.member.packageSummeryUriArray',$packageSummeryUriArray);
	}
}
?>