<?php
/*
 * member/member/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 編集実行用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_Execute extends system_login_ModuleBase {
	function member_member_Execute() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$memberNumber			= stripslashes( $_GET['mn'] );
		$temporaryId			= trim(stripslashes($_GET['tkey']));		
		$sessionObjectName		= 'member.member.modify.object.'.$memberNumber;
		$sessionConfirmName		= 'member.member.modify.confirm.'.$memberNumber;
		$memberObject			= $request->getSession($sessionObjectName);
		$compareMemberObject	= spider_Controller::createObject('member_DaoMember');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$comfirmResult			= $request->getSession($sessionConfirmName);
		
		// 1日以上前に記録された一時空メールアドレスデータは削除する
		$sql	= 'DELETE FROM '.TABLE_NAME_MEMBER_REGIST_TEMPORARY.' WHERE registered_date<'.$dbo->quote(date('Y-m-d H:i:s',strtotime('-1 day')));
		$dbo->query($sql);

		if(strlen($memberObject->member_number)==0){
			if( ( SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel() )
			&& ( !defined('MEMBER_PERMIT_REGIST_BY_USER') || preg_match('/^[tT](|[rR][uU][eE])$/',MEMBER_PERMIT_REGIST_BY_USER) == 0 ) ) {
				$request->addLocaledError('member.error.join.nopublicreg',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		
		if( 'OK' != $comfirmResult ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( get_class($memberObject) != get_class($compareMemberObject) ){
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			// 変更者のIDを登録
			$memberObject->modifier_id		= $loginUserObject->getUniqueId();
			$memberObject->registered_date	= date('Y-m-d H:i:s');
			$memberObject->convertKanaFields( 'KVa' );
			
			// メール通知と挙動の判断
			$isMobile			= false;
			$deliveryAddress	= null;
			$templateType		= ''; // MEMBERMODCNF / MEMBERMODCMP / MEMBERJOINCMP / MEMBERJOINCNF;
			if( is_object($loginUserObject)
				&& SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
				// 管理者ログインの場合は指定テンプレートで指定アドレス宛てに送信
				$templateType	= trim(stripslashes($_POST['template_type']));
				if( strlen($templateType) == 0 ) {
					// テンプレートが指定されていないならメールは送信しない
					$deliveryAddress	= null;
				} else if('MEMBERJOINCNF' != $templateType
					&& 'MEMBERJOINCMP' != $templateType
					&& 'MEMBERMODCNF' != $templateType
					&& 'MEMBERMODCMP' != $templateType) {
					// テンプレートが不正ならメールは送信しない
					$deliveryAddress	= null;
					$templateType		= '';
				} else {
					$targetType		= trim(stripslashes($_POST['target_type']));
					if( preg_match('/^[mM](|[oO][bB][iI][lL][eE])$/',$targetType) > 0 ) {
						$deliveryAddress	= $memberObject->mb_mail;
						$isMobile			= true;
					} else {
						$deliveryAddress	= $memberObject->pc_mail;
						$isMobile			= false;
					}
				}
			} else {
				// 管理者でない場合は自動宛先判断
				if( strlen(trim($memberObject->member_number_org)) > 0
				&& strlen($memberObject->member_class_org)>0 && $memberObject->member_class_org > 0
				&& strlen($memberObject->status_flag_org)>0 && $memberObject->status_flag_org == 101 ) {
					// 更新の場合
					if( $memberObject->isMobileMailValidated ) {
						$templateType	= 'MEMBERMODCMP';
					} else {
						$templateType	= 'MEMBERMODCNF';
					}
				} else {
					// 新規登録の場合
					if( $memberObject->isMobileMailValidated ) {
						$templateType	= 'MEMBERJOINCMP';
					} else {
						$templateType	= 'MEMBERJOINCNF';
					}
				}
				if( $memberObject->changePcMail && strlen($memberObject->pc_mail)>0 ) {
					// パソコンアドレスが変更されて入力されている場合
					$deliveryAddress	= $memberObject->pc_mail;
					$isMobile			= false;
				} else if( $memberObject->changeMobileMail && strlen($memberObject->mb_mail)>0 ) {
					// 携帯アドレスが変更されて入力されている場合
					$deliveryAddress	= $memberObject->mb_mail;
					$isMobile			= true;
				} else if( 'default' == $request->agentClass ) {
					// ユーザーエージェントがdefaultの場合はPCアドレスに配信
					$deliveryAddress	= $memberObject->pc_mail;
					$isMobile			= false;
				} else {
					// defaultでない場合は携帯宛てと判断
					$deliveryAddress	= $memberObject->mb_mail;
					$isMobile			= true;
				}
			}
			if(strlen($templateType)>0 && strlen($deliveryAddress)==0) {
				// 自動判断で送信が必要なのにメールアドレスが空の場合設定されている方のアドレスにする
				if( $isMobile ) {
					$deliveryAddress	= $memberObject->pc_mail;
					$isMobile		= false;
				} else {
					$deliveryAddress	= $memberObject->mb_mail;
					$isMobile		= true;
				}
			}
			
			// 登録処理分岐
			$memberObject->auth_key	= date('YmdHis').util_CharUtility::get_rundom_key(10);
			if( $templateType== 'MEMBERJOINCMP' ) {
				// 登録完了通知メールを送信する新規登録ケースの場合そのままデータベースに保存
				$this->insertNewMember( $request, $memberObject, $loginUserObject );
			} else if( $templateType== 'MEMBERJOINCNF' ) {
				// 登録完了用URL通知を送信する新規登録のケースの場合はオブジェクトをシリアル化して一時ファイルに保存する
				$this->saveTemporaryMember( $request, $memberObject, 'join' );
			} else if( $templateType== 'MEMBERMODCMP' ) {
				// 変更完了通知を送信するケースの場合はそのままデータベースをアップデートする
				$this->updateMember( $request, $memberObject, $loginUserObject );
			} else if( $templateType== 'MEMBERMODCNF' ) {
				// 変更完了用URL通知を送信するケースの場合はオブジェクトをシリアル化して一時ファイルに保存する
				$this->saveTemporaryMember( $request, $memberObject, 'modify' );
			} else if(is_object($loginUserObject)
				&& SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel()) {
				// 上記以外で管理者の場合はデータベース保存のみ行う
				if( strlen(trim($memberObject->member_number)) > 0 ) {
					$this->updateMember( $request, $memberObject, $loginUserObject );
				} else {
					$this->insertNewMember( $request, $memberObject, $loginUserObject );
				}
			} else {
				$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
			
			if( strlen($memberObject->mb_mail) > 0 ) {
				// 登録された一時テーブルのメールアドレスは削除する
				$sql	= 'DELETE FROM '.TABLE_NAME_MEMBER_REGIST_TEMPORARY
					.' WHERE email='.$dbo->quote($memberObject->pc_mail)
					.' OR email='.$dbo->quote($memberObject->mb_mail);
				$dbo->query($sql);
			}
			
			// 通知メールが必要な場合の処理
			if( strlen($templateType) > 0 && strlen($deliveryAddress) > 0 ) {
				$templateName	= $templateType;
				$mailTemplateObject	= spider_Controller::createObject('member_DaoMemberMailTemplate');
				// ロケール確認
				$isExists	= false;
				$templateId = $templateName.'_'.$request->locale;
				if( $dbo->loadById($mailTemplateObject,$templateId) ){
					$isExists	= true;
				} else if( $dbo->loadById($mailTemplateObject,$templateName) ) {
					$isExists	= true;
				}
				if( $isExists ) {
					$replaceWordHash				= array();
					$replaceWordHash['member']		= $memberObject;
					// 登録完了用URL文字列の作成
					$completeUrl	= '';
					if( $templateType== 'MEMBERMODCNF' ) {
						$completeUrl	= dirname(MEMBER_MODIFY_MAIL_URL).'/complete.php?mjmi='.$memberObject->member_id.'&mjak='.$memberObject->auth_key;
					} else if( $templateType== 'MEMBERJOINCNF' ) {
						$completeUrl	= dirname(MEMBER_REGIST_MAIL_URL).'/complete.php?mjmi=new&mjak='.$memberObject->auth_key;
					}
					$replaceWordHash['url_complete']	= $completeUrl;
					$replaceWordHash['complete_url']	= $completeUrl;
					// メール送信実行
					$deliveryStatus	= $mailTemplateObject->sendMail( $request, $deliveryAddress, $replaceWordHash );
					if( 1 != $deliveryStatus ) {
						$request->addLocaledError('member.error.common.sendmail',SPIDER_LOG_LEVEL_FATAL,array($deliveryStatus));
					}
				} else {
					$request->addLocaledError('member.error.common.mailnobody',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
			// 登録が完了していてエラーがない場合はパスワードを暗号化
			if( $memberObject->isMobileMailValidated || ( is_object($loginUserObject)
			&& SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) ) {
				if( !$request->isError() && $memberObject->login_password_org != $memberObject->login_password ) {
					$sql	= 'UPDATE '.TABLE_NAME_MEMBER
					.' SET login_password='.$dbo->quote($memberObject->encodePassword( $request, $memberObject->login_password ))
					.' WHERE member_id='.$dbo->quote($memberObject->member_id);
					if($dbo->query($sql)) {
					} else {
						$request->addLocaledError('member.error.common.failtocrypt',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
			}
		}
		// 1時間以上経過した一時ファイルを削除する
		member_member_Execute::deleleteTempFiles( $request, 'join' );
		member_member_Execute::deleleteTempFiles( $request, 'modify' );

		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('member.member.memberObject',$memberObject);
	}
	/**
	 * 新規インサート処理
	 */
	function insertNewMember( & $request, & $memberObject, & $loginUserObject ) {
		$dbo	= $request->getAttribute( 'dbo' );
		// 同一ログインIDで状態が登録完了になっていないまたは削除済みのレコードのlogin_idを重複回避にmember_idに変更
		$sql	= 'UPDATE '.TABLE_NAME_MEMBER.' SET login_id=member_id'
			.' WHERE login_id='.$dbo->quote($memberObject->login_id).' AND (status_flag<100 OR status_flag>=200 )'
		;
		$dbo->query($sql);
		// 初期値の設定
		$memberObject->updated_date		= date('Y-m-d H:i:s');
		$memberObject->owner_id			= $loginUserObject->getUniqueId();
		$memberObject->auth_key			= date('YmdHis').util_CharUtility::get_rundom_key(10);
		$memberObject->status_flag		= '101';
		if( !$dbo->setNextId( $memberObject, 'MBAA{num:4}' ) ) {
			$request->addLocaledError('database2.error.setnextid',SPIDER_LOG_LEVEL_FATAL,array(''));
		} else {
			if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
			} else {
				// 新規で管理者以外が登録する場合はオーナーと変更者を自分自身に設定
				$memberObject->owner_id		= $memberObject->member_id;
				$memberObject->modifier_id	= $memberObject->member_id;
			}
			if( $dbo->insert($memberObject,$request) ){
				// パッケージコネクタの追加登録処理をおこなう
				if( is_array($GLOBALS['member.existsConnectorHash'] ) ) {
					foreach( $GLOBALS['member.existsConnectorHash'] as $packageId => $connectorObject ) {
						$connectorObject->additionalPostInsertProcess( $request, $memberObject );
					}
				}
			} else {
				$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		if ( $request->isError() ) {
			return false;
		} else {
			return true;
		}
	}
	/**
	 * 会員情報を更新する
	 */
	function updateMember( & $request, & $memberObject, & $loginUserObject ) {
		$dbo	= $request->getAttribute( 'dbo' );
		if( $memberObject->canEditData( $request, $loginUserObject ) ) {
			if( $this->lockData( $request, $memberObject ) ) {
				// 編集ロックを再取得できたら更新
				$memberObject->updated_date	= date('Y-m-d H:i:s');
				$errors	= array();
				if( $dbo->update($memberObject,true) ) {
					// パッケージコネクタの追加更新処理をおこなう
					if( is_array($GLOBALS['member.existsConnectorHash'] ) ) {
						foreach( $GLOBALS['member.existsConnectorHash'] as $packageId => $connectorObject ) {
							$connectorObject->additionalPostUpdateProcess( $request, $memberObject );
						}
					}
				} else {
					$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(""));
				}
				$this->unlockData( $request, $memberObject );
			} else {
				$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		} else {
			$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
		}
		if ( $request->isError() ) {
			return false;
		} else {
			return true;
		}
	}
	/**
	 * 会員オブジェクトをシリアル化して保存する
	 */
	function saveTemporaryMember( & $request, & $memberObject, $type='join' ) {
		if( $type != 'modify' ) {
			$type	= 'join';
		}
		$tmpUri		= '/member/'.$type.'/'.$memberObject->auth_key.'.tmp';
		$loopCount	= 0;
		while( system_DataFileWriter::isExists( $request, $tmpUri, DIR_NAME_TMP ) ) {
			if( $loopCount > 100 ) {
				$request->addLocaledError('system.error.writer.save',SPIDER_LOG_LEVEL_FATAL,array(''));
				break;
			}
			$memberObject->auth_key	= date('YmdHis').util_CharUtility::get_rundom_key(10);
			$tmpUri	= '/member/modify/'.$memberObject->auth_key.'.tmp';
			$loopCount++;
		}
		if ( !$request->isError() ) {
			$fileWriter	= spider_Controller::createObject('system_DataFileWriter');
			if( $fileWriter->open( $request, $tmpUri, 'w', DIR_NAME_TMP ) ) {
				$strings	= serialize($memberObject);
				$fileWriter->write($strings);
				$fileWriter->close($request);
			} else {
				$request->addLocaledError('system.error.writer.save',SPIDER_LOG_LEVEL_FATAL,array(''));
				return false;
			}
		} else {
			return false;
		}
		return true;
	}
	/**
	 * 一時保存ファイルを消去する
	 */
	function deleleteTempFiles( & $request, $target='join' ) {
		if( 'modify' != $target ) {
			$target	= 'join';
		}
		$delUriArray	= array();
		$tmpPath	= system_DataFileWriter::getRealAbsolutePath( $request, '/member/'.$target, DIR_NAME_TMP );
		if (is_dir($tmpPath)) {
			if ($dh = opendir($tmpPath)) {
				while (($fileName = readdir($dh)) !== false) {
					if( preg_match('/^./',$fileName) == 0 ) {
						$absolutePath	= $tmpPath.DIRECTORY_SEPARATOR.$fileName;
						if( !is_dir($absolutePath) && time()-filemtime($absolutePath) > 60*60 ) {
							$tarUri	= '/member/join/'.$fileName;
							array_push($delUriArray,$tarUri);
						}
					}
				}
				closedir($dh);
			}
		}
		foreach( $delUriArray as $delUri ) {
			if( strlen($delUri) > 0 ) {
				system_DataFileWriter::delete( $request, $delUri, DIR_NAME_TMP );
			}
		}
	}
}
?>