<?php
/*
 * member/mail/template/Form.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : メンバーメール テンプレート作成 入力フォーム表示用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @subpackage template テンプレートパッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_template_Form extends system_login_ModuleBase {
	function member_mail_template_Form(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo									= $request->getAttribute( 'dbo' );
		$templateNumber				= $request->getParam('tpln','get');
		$sessionObjectName		= 'member.mail.template.modify.object.'.$templateNumber;
		$sessionConfirmName		= 'member.mail.template.modify.confirm.'.$templateNumber;
		$compareTemplateObject= spider_Controller::createObject('member_DaoMemberMailTemplate');
		$mailTemplateObject		= $request->getSession($sessionObjectName);
		$loginUserObject			= $this->getLoginUserObject( $request );
		$request->removeSession($sessionConfirmName);
		
		if( get_class($compareTemplateObject) == get_class($mailTemplateObject) ){
			// セッションに登録済みならそのまま利用する
		} else {
			// セッションにないなら作成する
			$mailTemplateObject			= spider_Controller::createObject('member_DaoMemberMailTemplate');
			if( strlen(trim($templateNumber)) > 0 ) {
				// IDが指定されているなら編集のため読み込み
				if( $dbo->loadByNumber( $mailTemplateObject, $templateNumber ) ){
					if( $loginUserObject->getUniqueId() != 'SYSADMIN'
						&& $mailTemplateObject->open_flag != 0
						&& $mailTemplateObject->owner_id != $loginUserObject->getUniqueId() ) {
						// 公開フラグが共有になっていない場合は所有者でなければエラー
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
					} else {
						$this->lockData( $request, $mailTemplateObject );
					}
				} else {
					$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
				}
			} else {
				// IDが指定されていないなら新規作成
			}
		}
		
		$request->setAttribute('member.mail.template.mail_template_object',$mailTemplateObject);

	}
}
?>